/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LayeredIcon;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgramRunnerUtil {
    private static final Logger LOG = Logger.getInstance(ProgramRunnerUtil.class);

    private ProgramRunnerUtil() {
    }

    @Nullable
    public static ProgramRunner getRunner(@NotNull String executorId, @Nullable RunnerAndConfigurationSettings configuration2) {
        return configuration2 == null ? null : ProgramRunner.getRunner((String)executorId, (RunProfile)configuration2.getConfiguration());
    }

    public static void executeConfiguration(@NotNull ExecutionEnvironment environment, boolean showSettings, boolean assignNewId) {
        ProgramRunnerUtil.executeConfigurationAsync(environment, showSettings, assignNewId, null);
    }

    @NotNull
    public static String getCannotRunOnErrorMessage(@NotNull RunProfile profile2, @NotNull ExecutionTarget target2) {
        return StringUtil.escapeXmlEntities((String)("Cannot run '" + profile2.getName() + "' on '" + target2.getDisplayName() + "'"));
    }

    public static void executeConfigurationAsync(@NotNull ExecutionEnvironment environment, boolean showSettings, boolean assignNewId, ProgramRunner.Callback callback2) {
        if (ExecutorRegistry.getInstance().isStarting(environment)) {
            return;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
        Project project = environment.getProject();
        if (runnerAndConfigurationSettings != null) {
            if (!ExecutionTargetManager.canRun((ExecutionEnvironment)environment)) {
                ExecutionUtil.handleExecutionError((ExecutionEnvironment)environment, (ExecutionException)new ExecutionException(ProgramRunnerUtil.getCannotRunOnErrorMessage(environment.getRunProfile(), environment.getExecutionTarget())));
                return;
            }
            if ((!RunManagerImpl.canRunConfiguration(environment) || showSettings && runnerAndConfigurationSettings.isEditBeforeRun()) && !DumbService.isDumb((Project)project)) {
                String title;
                String message;
                if (!RunDialog.editConfiguration(environment, "Edit configuration")) {
                    return;
                }
                while (!RunManagerImpl.canRunConfiguration(environment) && Messages.showYesNoDialog((Project)project, (String)(message = "Configuration is still incorrect. Do you want to edit it again?"), (String)(title = "Change Configuration Settings"), (String)"Edit", (String)"Continue Anyway", (Icon)Messages.getErrorIcon()) == 0) {
                    if (RunDialog.editConfiguration(environment, "Edit configuration")) continue;
                    return;
                }
            }
        }
        try {
            if (assignNewId) {
                environment.assignNewExecutionId();
            }
            if (callback2 != null) {
                environment.getRunner().execute(environment, callback2);
            } else {
                environment.getRunner().execute(environment);
            }
        }
        catch (ExecutionException e) {
            ProgramRunnerUtil.handleExecutionError(project, environment, e, (RunProfile)(runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null));
        }
    }

    public static void handleExecutionError(Project project, @NotNull ExecutionEnvironment environment, Throwable e, RunProfile configuration2) {
        String name = configuration2 != null ? configuration2.getName() : environment.getRunProfile().getName();
        String windowId = ExecutionManager.getInstance((Project)project).getContentManager().getToolWindowIdByEnvironment(environment);
        if (configuration2 instanceof ConfigurationWithCommandLineShortener && ExecutionUtil.isProcessNotCreated((Throwable)e)) {
            ProgramRunnerUtil.handelProcessNotStartedError((ConfigurationWithCommandLineShortener)configuration2, (ExecutionException)((ProcessNotCreatedException)e), name, windowId);
        } else {
            ExecutionUtil.handleExecutionError((Project)project, (String)windowId, (String)name, (Throwable)e);
        }
    }

    private static void handelProcessNotStartedError(ConfigurationWithCommandLineShortener configuration2, ExecutionException e, String name, String windowId) {
        String description = e.getMessage();
        HyperlinkListener listener2 = null;
        Project project = configuration2.getProject();
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runManager.getAllSettings().stream().filter(settings -> settings.getConfiguration() == configuration2).findFirst().orElse(null);
        if (runnerAndConfigurationSettings != null && (configuration2.getShortenCommandLine() == null || configuration2.getShortenCommandLine() == ShortenCommandLine.NONE)) {
            ConfigurationFactory factory = runnerAndConfigurationSettings.getFactory();
            RunnerAndConfigurationSettings configurationTemplate = runManager.getConfigurationTemplate(factory);
            description = "Command line is too long. Shorten command line for <a href=\"current\">" + name + "</a>";
            if (((ConfigurationWithCommandLineShortener)configurationTemplate.getConfiguration()).getShortenCommandLine() == null) {
                description = description + " or also for " + factory.getName() + " <a href=\"default\">default</a> configuration";
            }
            description = description + ".";
            listener2 = event -> {
                boolean isDefaultConfigurationChosen;
                SingleConfigurableEditor dialog2;
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (dialog2 = RunDialog.editShortenClasspathSetting((isDefaultConfigurationChosen = "default".equals(event.getDescription())) ? configurationTemplate : runnerAndConfigurationSettings, "Edit" + (isDefaultConfigurationChosen ? " Default" : "") + " Configuration")).showAndGet() && isDefaultConfigurationChosen) {
                    configuration2.setShortenCommandLine(((ConfigurationWithCommandLineShortener)configurationTemplate.getConfiguration()).getShortenCommandLine());
                }
            };
        }
        ExecutionUtil.handleExecutionError((Project)project, (String)windowId, (String)name, (Throwable)e, (String)description, listener2);
    }

    @Deprecated
    public static void executeConfiguration(@NotNull Project project, @NotNull RunnerAndConfigurationSettings configuration2, @NotNull Executor executor) {
        ProgramRunnerUtil.executeConfiguration(configuration2, executor);
    }

    public static void executeConfiguration(@NotNull RunnerAndConfigurationSettings configuration2, @NotNull Executor executor) {
        ExecutionEnvironmentBuilder builder2;
        try {
            builder2 = ExecutionEnvironmentBuilder.create((Executor)executor, (RunnerAndConfigurationSettings)configuration2);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            return;
        }
        ProgramRunnerUtil.executeConfiguration(builder2.contentToReuse(null).dataContext(null).activeTarget().build(), true, true);
    }

    public static Icon getConfigurationIcon(RunnerAndConfigurationSettings settings, boolean invalid) {
        Icon configurationIcon;
        Icon icon = ProgramRunnerUtil.getRawIcon(settings);
        Icon icon2 = configurationIcon = settings.isTemporary() ? ProgramRunnerUtil.getTemporaryIcon(icon) : icon;
        if (invalid) {
            return LayeredIcon.create((Icon)configurationIcon, (Icon)AllIcons.RunConfigurations.InvalidConfigurationLayer);
        }
        return configurationIcon;
    }

    @NotNull
    public static Icon getRawIcon(@NotNull RunnerAndConfigurationSettings settings) {
        Icon icon = settings.getFactory().getIcon(settings.getConfiguration());
        return icon == null ? AllIcons.Actions.Help : icon;
    }

    @NotNull
    public static Icon getTemporaryIcon(@NotNull Icon rawIcon) {
        return IconLoader.getTransparentIcon((Icon)rawIcon, (float)0.3f);
    }

    @NotNull
    public static String shortenName(@Nullable String name, int toBeAdded) {
        if (name == null) {
            return "";
        }
        int symbols = Math.max(10, 20 - toBeAdded);
        return name.length() < symbols + 3 ? name : name.substring(0, symbols) + "...";
    }
}

