/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRunConfigurationAction
extends ActionGroup {
    protected static final Logger LOG = Logger.getInstance(BaseRunConfigurationAction.class);

    protected BaseRunConfigurationAction(String text, String description, Icon icon) {
        super(text, description, icon);
        this.setPopup(true);
        this.setEnabledInModalContext(true);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        return e != null ? this.getChildren(e.getDataContext()) : EMPTY_ARRAY;
    }

    private AnAction[] getChildren(DataContext dataContext) {
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        if (!Registry.is((String)"suggest.all.run.configurations.from.context") && context.findExisting() != null) {
            return EMPTY_ARRAY;
        }
        return this.createChildActions(context, this.getConfigurationsFromContext(context)).toArray(EMPTY_ARRAY);
    }

    @NotNull
    protected List<AnAction> createChildActions(final @NotNull ConfigurationContext context, @NotNull List<? extends ConfigurationFromContext> configurations) {
        if (configurations.size() <= 1) {
            return Collections.emptyList();
        }
        ArrayList<AnAction> childActions = new ArrayList<AnAction>();
        for (final ConfigurationFromContext configurationFromContext : configurations) {
            ConfigurationType configurationType = configurationFromContext.getConfigurationType();
            String actionName = BaseRunConfigurationAction.childActionName(configurationFromContext);
            AnAction anAction = new AnAction(actionName, configurationType.getDisplayName(), configurationFromContext.getConfiguration().getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    BaseRunConfigurationAction.this.perform(configurationFromContext, context);
                }
            };
            anAction.getTemplatePresentation().setText(actionName, false);
            childActions.add(anAction);
        }
        return childActions;
    }

    @NotNull
    private List<ConfigurationFromContext> getConfigurationsFromContext(ConfigurationContext context) {
        List fromContext = context.getConfigurationsFromContext();
        if (fromContext == null) {
            return Collections.emptyList();
        }
        ArrayList<ConfigurationFromContext> enabledConfigurations = new ArrayList<ConfigurationFromContext>();
        for (ConfigurationFromContext configurationFromContext : fromContext) {
            if (!this.isEnabledFor(configurationFromContext.getConfiguration())) continue;
            enabledConfigurations.add(configurationFromContext);
        }
        return enabledConfigurations;
    }

    protected boolean isEnabledFor(RunConfiguration configuration2) {
        return true;
    }

    public boolean canBePerformed(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && DumbService.isDumb((Project)project)) {
            return false;
        }
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        RunnerAndConfigurationSettings existing = context.findExisting();
        if (existing == null) {
            List<ConfigurationFromContext> fromContext = this.getConfigurationsFromContext(context);
            return fromContext.size() <= 1;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        MacroManager.getInstance().cacheMacrosPreview(e.getDataContext());
        final ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        RunnerAndConfigurationSettings existing = context.findExisting();
        if (existing == null) {
            List<ConfigurationFromContext> producers = this.getConfigurationsFromContext(context);
            if (producers.isEmpty()) {
                return;
            }
            if (producers.size() > 1) {
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                Collections.sort(producers, ConfigurationFromContext.NAME_COMPARATOR);
                ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ConfigurationFromContext>(ExecutionBundle.message((String)"configuration.action.chooser.title", (Object[])new Object[0]), producers){

                    @NotNull
                    public String getTextFor(ConfigurationFromContext producer) {
                        return BaseRunConfigurationAction.childActionName(producer);
                    }

                    public Icon getIconFor(ConfigurationFromContext producer) {
                        return producer.getConfigurationType().getIcon();
                    }

                    public PopupStep onChosen(ConfigurationFromContext producer, boolean finalChoice) {
                        BaseRunConfigurationAction.this.perform(producer, context);
                        return FINAL_CHOICE;
                    }
                });
                InputEvent event = e.getInputEvent();
                if (event instanceof MouseEvent) {
                    popup2.show(new RelativePoint((MouseEvent)event));
                } else if (editor != null) {
                    popup2.showInBestPositionFor(editor);
                } else {
                    popup2.showInBestPositionFor(dataContext);
                }
            } else {
                this.perform(producers.get(0), context);
            }
            return;
        }
        this.perform(context);
    }

    private void perform(ConfigurationFromContext configurationFromContext, ConfigurationContext context) {
        RunnerAndConfigurationSettings configurationSettings = configurationFromContext.getConfigurationSettings();
        context.setConfiguration(configurationSettings);
        configurationFromContext.onFirstRun(context, () -> this.perform(context));
    }

    protected abstract void perform(ConfigurationContext var1);

    public void update(@NotNull AnActionEvent event) {
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)event.getDataContext());
        Presentation presentation = event.getPresentation();
        RunnerAndConfigurationSettings existing = context.findExisting();
        RunnerAndConfigurationSettings configuration2 = existing;
        if (configuration2 == null) {
            configuration2 = context.getConfiguration();
        }
        if (configuration2 == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
        } else {
            presentation.setEnabled(true);
            presentation.setVisible(true);
            List<ConfigurationFromContext> fromContext = this.getConfigurationsFromContext(context);
            if (existing == null && !fromContext.isEmpty()) {
                context.setConfiguration(fromContext.get(0).getConfigurationSettings());
            }
            String name = BaseRunConfigurationAction.suggestRunActionName((LocatableConfiguration)configuration2.getConfiguration());
            this.updatePresentation(presentation, existing != null || fromContext.size() <= 1 ? name : "", context);
        }
    }

    public boolean isDumbAware() {
        return false;
    }

    @NotNull
    public static String suggestRunActionName(LocatableConfiguration configuration2) {
        String actionName;
        if (configuration2 instanceof LocatableConfigurationBase && configuration2.isGeneratedName() && (actionName = ((LocatableConfigurationBase)configuration2).getActionName()) != null) {
            return actionName;
        }
        return ProgramRunnerUtil.shortenName(configuration2.getName(), 0);
    }

    @NotNull
    private static String childActionName(ConfigurationFromContext configurationFromContext) {
        String locationDisplayName;
        RunConfiguration configuration2 = configurationFromContext.getConfiguration();
        if (!(configuration2 instanceof LocatableConfiguration)) {
            return configurationFromContext.getConfigurationType().getDisplayName();
        }
        if (configurationFromContext.isFromAlternativeLocation() && (locationDisplayName = configurationFromContext.getAlternativeLocationDisplayName()) != null) {
            return ((LocatableConfigurationBase)configuration2).getActionName() + " " + locationDisplayName;
        }
        return StringUtil.unquoteString((String)BaseRunConfigurationAction.suggestRunActionName((LocatableConfiguration)configurationFromContext.getConfiguration()));
    }

    protected abstract void updatePresentation(Presentation var1, @NotNull String var2, ConfigurationContext var3);
}

