/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.actions.StopAction;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EOFAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    @NonNls
    public static final String ACTION_ID = "SendEOF";

    public void update(@NotNull AnActionEvent e) {
        RunContentDescriptor descriptor = StopAction.getRecentlyStartedContentDescriptor(e.getDataContext());
        ProcessHandler handler2 = descriptor != null ? descriptor.getProcessHandler() : null;
        e.getPresentation().setEnabledAndVisible(e.getData(LangDataKeys.CONSOLE_VIEW) != null && e.getData(CommonDataKeys.EDITOR) != null && handler2 != null && !handler2.isProcessTerminated());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ProcessHandler activeProcessHandler;
        RunContentDescriptor descriptor = StopAction.getRecentlyStartedContentDescriptor(e.getDataContext());
        ProcessHandler processHandler2 = activeProcessHandler = descriptor != null ? descriptor.getProcessHandler() : null;
        if (activeProcessHandler == null || activeProcessHandler.isProcessTerminated()) {
            return;
        }
        try (OutputStream input = activeProcessHandler.getProcessInput();){
            ConsoleView console;
            if (input != null && (console = (ConsoleView)e.getData(LangDataKeys.CONSOLE_VIEW)) != null) {
                console.print("^D\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

