/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationsComboBoxAction
extends ComboBoxAction
implements DumbAware {
    private static final String BUTTON_MODE = "ButtonMode";
    public static final Icon CHECKED_ICON = JBUI.scale((JBUI.JBIcon)new SizedIcon(AllIcons.Actions.Checked, 16, 16));
    public static final Icon CHECKED_SELECTED_ICON = JBUI.scale((JBUI.JBIcon)new SizedIcon(AllIcons.Actions.Checked_selected, 16, 16));
    public static final Icon EMPTY_ICON = EmptyIcon.ICON_16;
    private ComboBoxAction.ComboBoxButton myButton;

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace())) {
            presentation.setDescription(ExecutionBundle.message((String)"choose.run.configuration.action.description", (Object[])new Object[0]));
        }
        try {
            if (project == null || project.isDisposed() || !project.isOpen()) {
                RunConfigurationsComboBoxAction.updatePresentation(null, null, null, presentation, e.getPlace());
                presentation.setEnabled(false);
            } else {
                RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget((Project)project), RunManager.getInstance((Project)project).getSelectedConfiguration(), project, presentation, e.getPlace());
                presentation.setEnabled(true);
            }
        }
        catch (IndexNotReadyException e1) {
            presentation.setEnabled(false);
        }
    }

    private static void updatePresentation(@Nullable ExecutionTarget target2, @Nullable RunnerAndConfigurationSettings settings, @Nullable Project project, @NotNull Presentation presentation, String actionPlace) {
        presentation.putClientProperty(BUTTON_MODE, null);
        if (project != null && target2 != null && settings != null) {
            String name = Executor.shortenNameIfNeed((String)settings.getName());
            if (target2 != DefaultExecutionTarget.INSTANCE && !target2.isExternallyManaged()) {
                name = name + " | " + target2.getDisplayName();
            } else if (!ExecutionTargetManager.canRun((RunConfiguration)settings.getConfiguration(), (ExecutionTarget)target2)) {
                name = name + " | Nothing to run on";
            }
            presentation.setText(name, false);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                RunConfigurationsComboBoxAction.setConfigurationIcon(presentation, settings, project);
            }
        } else {
            presentation.putClientProperty(BUTTON_MODE, (Object)Boolean.TRUE);
            presentation.setText("Add Configuration...");
            presentation.setDescription(ActionsBundle.actionDescription((String)"editRunConfigurations"));
            if ("TouchBarGeneral".equals(actionPlace)) {
                presentation.setIcon(AllIcons.General.Add);
            } else {
                presentation.setIcon(null);
            }
        }
    }

    private static void setConfigurationIcon(Presentation presentation, RunnerAndConfigurationSettings settings, Project project) {
        try {
            presentation.setIcon(RunManagerEx.getInstanceEx(project).getConfigurationIcon(settings, true));
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Presentation presentation;
        if ("TouchBarGeneral".equals(e.getPlace()) && Boolean.TRUE.equals((presentation = e.getPresentation()).getClientProperty(BUTTON_MODE))) {
            RunConfigurationsComboBoxAction.performWhenButton((Component)this.myButton, "TouchBarGeneral");
            return;
        }
        super.actionPerformed(e);
    }

    protected boolean shouldShowDisabledActions() {
        return true;
    }

    @NotNull
    public JComponent createCustomComponent(final @NotNull Presentation presentation, @NotNull String place) {
        this.myButton = new ComboBoxAction.ComboBoxButton(presentation){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = Math.max(d.width, JBUI.scale((int)75));
                return d;
            }

            protected void fireActionPerformed(ActionEvent event) {
                if (Boolean.TRUE.equals(presentation.getClientProperty(RunConfigurationsComboBoxAction.BUTTON_MODE))) {
                    RunConfigurationsComboBoxAction.performWhenButton((Component)((Object)this), "unknown");
                    return;
                }
                super.fireActionPerformed(event);
            }

            protected boolean isArrowVisible(@NotNull Presentation presentation2) {
                return !Boolean.TRUE.equals(presentation2.getClientProperty(RunConfigurationsComboBoxAction.BUTTON_MODE));
            }
        };
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        JBEmptyBorder border = UIUtil.isUnderDefaultMacTheme() ? JBUI.Borders.empty((int)0, (int)2) : JBUI.Borders.empty((int)0, (int)5, (int)0, (int)4);
        panel2.setBorder((Border)border);
        panel2.add((Component)this.myButton);
        return panel2;
    }

    private static void performWhenButton(@NotNull Component src, String place) {
        ActionManager manager = ActionManager.getInstance();
        manager.tryToExecute(manager.getAction("editRunConfigurations"), (InputEvent)new MouseEvent(src, 501, System.currentTimeMillis(), 0, 0, 0, 0, false, 0), src, place, true);
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
        DefaultActionGroup allActionsGroup = new DefaultActionGroup();
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)button2));
        if (project == null) {
            return allActionsGroup;
        }
        allActionsGroup.add(ActionManager.getInstance().getAction("editRunConfigurations"));
        allActionsGroup.add((AnAction)new SaveTemporaryAction());
        allActionsGroup.addSeparator();
        RunnerAndConfigurationSettings selected = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (selected != null) {
            ExecutionTarget activeTarget = ExecutionTargetManager.getActiveTarget((Project)project);
            for (ExecutionTarget eachTarget : ExecutionTargetManager.getTargetsToChooseFor((Project)project, (RunConfiguration)selected.getConfiguration())) {
                allActionsGroup.add((AnAction)new SelectTargetAction(project, eachTarget, eachTarget.equals((Object)activeTarget)));
            }
            allActionsGroup.addSeparator();
        }
        for (Map<String, List<RunnerAndConfigurationSettings>> structure : RunManagerImpl.getInstanceImpl(project).getConfigurationsGroupedByTypeAndFolder(true).values()) {
            DefaultActionGroup actionGroup = new DefaultActionGroup();
            for (Map.Entry<String, List<RunnerAndConfigurationSettings>> entry : structure.entrySet()) {
                String folderName = entry.getKey();
                DefaultActionGroup group = folderName == null ? actionGroup : new DefaultActionGroup(folderName, true);
                group.getTemplatePresentation().setIcon(AllIcons.Nodes.Folder);
                for (RunnerAndConfigurationSettings settings : entry.getValue()) {
                    group.add((AnAction)new SelectConfigAction(settings, project));
                }
                if (group == actionGroup) continue;
                actionGroup.add((AnAction)group);
            }
            allActionsGroup.add((AnAction)actionGroup);
            allActionsGroup.addSeparator();
        }
        return allActionsGroup;
    }

    private static class SelectConfigAction
    extends DumbAwareAction {
        private final RunnerAndConfigurationSettings myConfiguration;
        private final Project myProject;

        SelectConfigAction(RunnerAndConfigurationSettings configuration2, Project project) {
            this.myConfiguration = configuration2;
            this.myProject = project;
            String name = Executor.shortenNameIfNeed((String)configuration2.getName());
            if (name.isEmpty()) {
                name = " ";
            }
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(name, false);
            presentation.setDescription("Select " + configuration2.getType().getConfigurationTypeDescription() + " '" + name + "'");
            this.updateIcon(presentation);
        }

        private void updateIcon(Presentation presentation) {
            RunConfigurationsComboBoxAction.setConfigurationIcon(presentation, this.myConfiguration, this.myProject);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            RunManager.getInstance((Project)this.myProject).setSelectedConfiguration(this.myConfiguration);
            RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget((Project)this.myProject), this.myConfiguration, this.myProject, e.getPresentation(), e.getPlace());
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            this.updateIcon(e.getPresentation());
        }
    }

    private static class SelectTargetAction
    extends AnAction {
        private final Project myProject;
        private final ExecutionTarget myTarget;

        SelectTargetAction(Project project, ExecutionTarget target2, boolean selected) {
            this.myProject = project;
            this.myTarget = target2;
            String name = target2.getDisplayName();
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(name, false);
            presentation.setDescription("Select " + name);
            presentation.setIcon(selected ? CHECKED_ICON : EMPTY_ICON);
            presentation.setSelectedIcon(selected ? CHECKED_SELECTED_ICON : EMPTY_ICON);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ExecutionTargetManager.setActiveTarget((Project)this.myProject, (ExecutionTarget)this.myTarget);
            RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget((Project)this.myProject), RunManager.getInstance((Project)this.myProject).getSelectedConfiguration(), this.myProject, e.getPresentation(), e.getPlace());
        }

        public boolean isDumbAware() {
            RunnerAndConfigurationSettings configuration2 = RunManager.getInstance((Project)this.myProject).getSelectedConfiguration();
            return configuration2 == null || configuration2.getType().isDumbAware();
        }
    }

    private static class SaveTemporaryAction
    extends DumbAwareAction {
        SaveTemporaryAction() {
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.Actions.Menu_saveall);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            RunnerAndConfigurationSettings settings;
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project != null && (settings = SaveTemporaryAction.chooseTempSettings(project)) != null) {
                RunManager runManager = RunManager.getInstance((Project)project);
                runManager.makeStable(settings);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project == null) {
                SaveTemporaryAction.disable(presentation);
                return;
            }
            RunnerAndConfigurationSettings settings = SaveTemporaryAction.chooseTempSettings(project);
            if (settings == null) {
                SaveTemporaryAction.disable(presentation);
            } else {
                presentation.setText(ExecutionBundle.message((String)"save.temporary.run.configuration.action.name", (Object[])new Object[]{Executor.shortenNameIfNeed((String)settings.getName())}));
                presentation.setDescription(presentation.getText());
                presentation.setVisible(true);
                presentation.setEnabled(true);
            }
        }

        private static void disable(Presentation presentation) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
        }

        @Nullable
        private static RunnerAndConfigurationSettings chooseTempSettings(@NotNull Project project) {
            RunnerAndConfigurationSettings selectedConfiguration2 = RunManager.getInstance((Project)project).getSelectedConfiguration();
            if (selectedConfiguration2 != null && selectedConfiguration2.isTemporary()) {
                return selectedConfiguration2;
            }
            return (RunnerAndConfigurationSettings)ContainerUtil.getFirstItem((List)RunManager.getInstance((Project)project).getTempConfigurationsList());
        }
    }
}

