/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.SuggestUsingRunDashBoardUtil;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContextAction
extends BaseRunConfigurationAction {
    private final Executor myExecutor;

    public RunContextAction(final @NotNull Executor executor) {
        super(ExecutionBundle.message((String)"perform.action.with.context.configuration.action.name", (Object[])new Object[]{executor.getStartActionText()}), null, (Icon)new IconLoader.LazyIcon(){

            protected Icon compute() {
                return executor.getIcon();
            }
        });
        this.myExecutor = executor;
    }

    @Override
    protected void perform(ConfigurationContext context) {
        RunnerAndConfigurationSettings configuration2 = context.findExisting();
        RunManagerEx runManager = (RunManagerEx)context.getRunManager();
        if (configuration2 == null) {
            configuration2 = context.getConfiguration();
            if (configuration2 == null) {
                return;
            }
            runManager.setTemporaryConfiguration(configuration2);
        }
        if (Registry.is((String)"select.run.configuration.from.context")) {
            runManager.setSelectedConfiguration(configuration2);
        }
        ExecutionUtil.doRunConfiguration((RunnerAndConfigurationSettings)configuration2, (Executor)this.myExecutor, null, null, (DataContext)context.getDataContext());
    }

    @Override
    protected boolean isEnabledFor(RunConfiguration configuration2) {
        return this.getRunner(configuration2) != null;
    }

    @Nullable
    private ProgramRunner getRunner(RunConfiguration configuration2) {
        return ProgramRunner.getRunner((String)this.myExecutor.getId(), (RunProfile)configuration2);
    }

    @Override
    protected void updatePresentation(Presentation presentation, @NotNull String actionText, ConfigurationContext context) {
        presentation.setText(this.myExecutor.getStartActionText(actionText), true);
        Pair<Boolean, Boolean> b = this.isEnabledAndVisible(context);
        presentation.setEnabled(((Boolean)b.first).booleanValue());
        presentation.setVisible(((Boolean)b.second).booleanValue());
    }

    private Pair<Boolean, Boolean> isEnabledAndVisible(ConfigurationContext context) {
        ProgramRunner runner;
        RunnerAndConfigurationSettings configuration2 = context.findExisting();
        if (configuration2 == null) {
            configuration2 = context.getConfiguration();
        }
        ProgramRunner programRunner = runner = configuration2 == null ? null : this.getRunner(configuration2.getConfiguration());
        if (runner == null) {
            return Pair.create((Object)false, (Object)false);
        }
        return Pair.create((Object)(!ExecutorRegistry.getInstance().isStarting(context.getProject(), this.myExecutor.getId(), runner.getRunnerId()) ? 1 : 0), (Object)true);
    }

    @Override
    @NotNull
    protected List<AnAction> createChildActions(@NotNull ConfigurationContext context, @NotNull List<? extends ConfigurationFromContext> configurations) {
        ArrayList<AnAction> childActions = new ArrayList<AnAction>(super.createChildActions(context, configurations));
        boolean isMultipleConfigurationsFromAlternativeLocations = configurations.size() > 1 && configurations.get(0).isFromAlternativeLocation();
        boolean isRunAction = this.myExecutor.getId().equals(DefaultRunExecutor.EXECUTOR_ID);
        if (isMultipleConfigurationsFromAlternativeLocations && isRunAction) {
            childActions.add(this.runAllConfigurationsAction(context, configurations));
        }
        return childActions;
    }

    @NotNull
    private AnAction runAllConfigurationsAction(final @NotNull ConfigurationContext context, final @NotNull List<? extends ConfigurationFromContext> configurationsFromContext) {
        return new AnAction("Run all", "Run all configurations available in this context", AllIcons.RunConfigurations.Compound){

            public void actionPerformed(@NotNull AnActionEvent e) {
                long groupId = ExecutionEnvironment.getNextUnusedExecutionId();
                List types = ContainerUtil.map((Collection)configurationsFromContext, context1 -> context1.getConfiguration().getType());
                SuggestUsingRunDashBoardUtil.promptUserToUseRunDashboard((Project)context.getProject(), (Collection)types);
                for (ConfigurationFromContext configuration2 : configurationsFromContext) {
                    ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration2.getConfigurationSettings(), (Executor)RunContextAction.this.myExecutor, (long)groupId);
                }
            }
        };
    }
}

