/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.IconUtil;
import com.intellij.util.SmartList;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StopAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    private WeakReference<JBPopup> myActivePopupRef = null;

    private static boolean isPlaceGlobal(@NotNull AnActionEvent e) {
        return ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || "MainToolbar".equals(e.getPlace()) || "NavBarToolbar".equals(e.getPlace()) || "TouchBarGeneral".equals(e.getPlace());
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enable = false;
        Icon icon = this.getTemplatePresentation().getIcon();
        String description = this.getTemplatePresentation().getDescription();
        Presentation presentation = e.getPresentation();
        if (StopAction.isPlaceGlobal(e)) {
            List<RunContentDescriptor> stoppableDescriptors = StopAction.getActiveStoppableDescriptors(e.getDataContext());
            int stopCount = stoppableDescriptors.size();
            boolean bl = enable = stopCount >= 1;
            if (stopCount > 1) {
                presentation.setText(this.getTemplatePresentation().getText() + "...");
                icon = IconUtil.addText((Icon)icon, (String)String.valueOf(stopCount));
            } else if (stopCount == 1) {
                presentation.setText(ExecutionBundle.message((String)"stop.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)StringUtil.notNullize((String)stoppableDescriptors.get(0).getDisplayName()))}));
            }
        } else {
            RunProfile runProfile;
            ProcessHandler processHandler2;
            RunContentDescriptor contentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
            ProcessHandler processHandler3 = processHandler2 = contentDescriptor == null ? null : contentDescriptor.getProcessHandler();
            if (processHandler2 != null && !processHandler2.isProcessTerminated()) {
                if (!processHandler2.isProcessTerminating()) {
                    enable = true;
                } else if (processHandler2 instanceof KillableProcess && ((KillableProcess)processHandler2).canKillProcess()) {
                    enable = true;
                    icon = AllIcons.Debugger.KillProcess;
                    description = "Kill process";
                }
            }
            if ((runProfile = (RunProfile)e.getData(LangDataKeys.RUN_PROFILE)) == null && contentDescriptor == null) {
                presentation.setText(this.getTemplatePresentation().getText());
            } else {
                presentation.setText(ExecutionBundle.message((String)"stop.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)(runProfile == null ? StringUtil.notNullize((String)contentDescriptor.getDisplayName()) : runProfile.getName()))}));
            }
        }
        presentation.setEnabled(enable);
        presentation.setIcon(icon);
        presentation.setDescription(description);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        List<RunContentDescriptor> stoppableDescriptors = StopAction.getActiveStoppableDescriptors(dataContext);
        int stopCount = stoppableDescriptors.size();
        if (StopAction.isPlaceGlobal(e)) {
            Component component;
            if (stopCount == 1) {
                ExecutionManagerImpl.stopProcess(stoppableDescriptors.get(0));
                return;
            }
            if (e.getPlace().equals("TouchBarGeneral") && !stoppableDescriptors.isEmpty()) {
                StopAction._showStopRunningBar(stoppableDescriptors);
                return;
            }
            final Pair<List<HandlerItem>, HandlerItem> handlerItems = StopAction.getItemsList(stoppableDescriptors, StopAction.getRecentlyStartedContentDescriptor(dataContext));
            if (handlerItems == null || ((List)handlerItems.first).isEmpty()) {
                return;
            }
            HandlerItem stopAllItem = new HandlerItem(ExecutionBundle.message((String)"stop.all", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"Stop")}), AllIcons.Actions.Suspend, true){

                @Override
                void stop() {
                    for (HandlerItem item : (List)handlerItems.first) {
                        if (item == this) continue;
                        item.stop();
                    }
                }
            };
            JBPopup activePopup = (JBPopup)SoftReference.dereference(this.myActivePopupRef);
            if (activePopup != null) {
                stopAllItem.stop();
                activePopup.cancel();
                return;
            }
            List items = (List)handlerItems.first;
            if (stopCount > 1) {
                items.add(stopAllItem);
            }
            IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(items).setRenderer(new GroupedItemsListRenderer(new ListItemDescriptorAdapter<HandlerItem>(){

                @Nullable
                public String getTextFor(HandlerItem item) {
                    return item.displayName;
                }

                @Nullable
                public Icon getIconFor(HandlerItem item) {
                    return item.icon;
                }

                public boolean hasSeparatorAboveOf(HandlerItem item) {
                    return item.hasSeparator;
                }
            })).setMovable(true).setTitle(items.size() == 1 ? "Confirm process stop" : "Stop process").setNamerForFiltering(o -> o.displayName).setItemsChosenCallback(valuesList -> {
                for (HandlerItem item : valuesList) {
                    item.stop();
                }
            }).addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    StopAction.this.myActivePopupRef = null;
                }
            }).setRequestFocus(true);
            if (handlerItems.second != null) {
                builder2.setSelectedValue(handlerItems.second, true);
            }
            JBPopup popup2 = builder2.createPopup();
            this.myActivePopupRef = new WeakReference<JBPopup>(popup2);
            InputEvent inputEvent = e.getInputEvent();
            Component component2 = component = inputEvent != null ? inputEvent.getComponent() : null;
            if (component != null && ("MainToolbar".equals(e.getPlace()) || "NavBarToolbar".equals(e.getPlace()))) {
                popup2.showUnderneathOf(component);
            } else if (project == null) {
                popup2.showInBestPositionFor(dataContext);
            } else {
                popup2.showCenteredInCurrentWindow(project);
            }
        } else {
            ExecutionManagerImpl.stopProcess(StopAction.getRecentlyStartedContentDescriptor(dataContext));
        }
    }

    @Nullable
    private static Pair<List<HandlerItem>, HandlerItem> getItemsList(List<RunContentDescriptor> descriptors, RunContentDescriptor toSelect2) {
        if (descriptors.isEmpty()) {
            return null;
        }
        ArrayList<4> items = new ArrayList<4>(descriptors.size());
        HandlerItem selected = null;
        for (final RunContentDescriptor descriptor : descriptors) {
            ProcessHandler handler2 = descriptor.getProcessHandler();
            if (handler2 == null) continue;
            HandlerItem item = new HandlerItem(descriptor.getDisplayName(), descriptor.getIcon(), false){

                @Override
                void stop() {
                    ExecutionManagerImpl.stopProcess(descriptor);
                }
            };
            items.add(item);
            if (descriptor != toSelect2) continue;
            selected = item;
        }
        return Pair.create(items, selected);
    }

    @Nullable
    static RunContentDescriptor getRecentlyStartedContentDescriptor(@NotNull DataContext dataContext) {
        RunContentDescriptor contentDescriptor = (RunContentDescriptor)LangDataKeys.RUN_CONTENT_DESCRIPTOR.getData(dataContext);
        if (contentDescriptor != null) {
            return contentDescriptor;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project == null ? null : ExecutionManager.getInstance((Project)project).getContentManager().getSelectedContent();
    }

    @NotNull
    private static List<RunContentDescriptor> getActiveStoppableDescriptors(DataContext dataContext) {
        List<Object> runningProcesses;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        List<Object> list2 = runningProcesses = project == null ? Collections.emptyList() : ExecutionManagerImpl.getAllDescriptors(project);
        if (runningProcesses.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList activeDescriptors = new SmartList();
        for (RunContentDescriptor runContentDescriptor : runningProcesses) {
            if (!StopAction.canBeStopped(runContentDescriptor)) continue;
            activeDescriptors.add(runContentDescriptor);
        }
        return activeDescriptors;
    }

    private static boolean canBeStopped(@Nullable RunContentDescriptor descriptor) {
        ProcessHandler processHandler2;
        ProcessHandler processHandler3 = processHandler2 = descriptor != null ? descriptor.getProcessHandler() : null;
        if (processHandler2 instanceof KillableProcess) {
            return ((KillableProcess)processHandler2).canKillProcess();
        }
        return processHandler2 != null && !processHandler2.isProcessTerminated() && !processHandler2.isProcessTerminating();
    }

    private static void _showStopRunningBar(@NotNull List<RunContentDescriptor> stoppableDescriptors) {
        if (!TouchBarsManager.isTouchBarAvailable()) {
            return;
        }
        ArrayList<Pair> descriptors = new ArrayList<Pair>(stoppableDescriptors.size());
        for (RunContentDescriptor sd : stoppableDescriptors) {
            descriptors.add(Pair.create((Object)sd, () -> ApplicationManager.getApplication().invokeLater(() -> ExecutionManagerImpl.stopProcess(sd))));
        }
        TouchBarsManager.showStopRunningBar(descriptors);
    }

    static abstract class HandlerItem {
        final String displayName;
        final Icon icon;
        final boolean hasSeparator;

        HandlerItem(String displayName, Icon icon, boolean hasSeparator) {
            this.displayName = displayName;
            this.icon = icon;
            this.hasSeparator = hasSeparator;
        }

        public String toString() {
            return this.displayName;
        }

        abstract void stop();
    }
}

