/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.actions.StopAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StopBackgroundProcessesAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(!StopBackgroundProcessesAction.getCancellableProcesses(e.getProject()).isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Component component;
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        List<StopAction.HandlerItem> handlerItems = StopBackgroundProcessesAction.getItemsList(StopBackgroundProcessesAction.getCancellableProcesses(project));
        if (handlerItems.isEmpty()) {
            return;
        }
        JBList list2 = new JBList(handlerItems);
        list2.setCellRenderer(new GroupedItemsListRenderer(new ListItemDescriptorAdapter<StopAction.HandlerItem>(){

            @Nullable
            public String getTextFor(StopAction.HandlerItem item) {
                return item.displayName;
            }

            @Nullable
            public Icon getIconFor(StopAction.HandlerItem item) {
                return item.icon;
            }

            public boolean hasSeparatorAboveOf(StopAction.HandlerItem item) {
                return item.hasSeparator;
            }
        }));
        JBPopup popup2 = JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setMovable(true).setTitle(handlerItems.size() == 1 ? "Confirm background process stop" : "Stop background process").setNamerForFiltering(o -> ((StopAction.HandlerItem)o).displayName).setItemChoosenCallback(() -> {
            List valuesList = list2.getSelectedValuesList();
            for (Object o : valuesList) {
                if (!(o instanceof StopAction.HandlerItem)) continue;
                ((StopAction.HandlerItem)o).stop();
            }
        }).setRequestFocus(true).createPopup();
        InputEvent inputEvent = e.getInputEvent();
        Component component2 = component = inputEvent != null ? inputEvent.getComponent() : null;
        if (component != null && ("MainToolbar".equals(e.getPlace()) || "NavBarToolbar".equals(e.getPlace()))) {
            popup2.showUnderneathOf(component);
        } else if (project == null) {
            popup2.showInBestPositionFor(dataContext);
        } else {
            popup2.showCenteredInCurrentWindow(project);
        }
    }

    @NotNull
    private static List<Pair<TaskInfo, ProgressIndicator>> getCancellableProcesses(@Nullable Project project) {
        StatusBarEx statusBar;
        IdeFrame frame = ((WindowManagerEx)WindowManager.getInstance()).findFrameFor(project);
        StatusBarEx statusBarEx = statusBar = frame == null ? null : (StatusBarEx)frame.getStatusBar();
        if (statusBar == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.findAll(statusBar.getBackgroundProcesses(), pair -> ((TaskInfo)pair.first).isCancellable() && !((ProgressIndicator)pair.second).isCanceled());
    }

    @NotNull
    private static List<StopAction.HandlerItem> getItemsList(@NotNull List<Pair<TaskInfo, ProgressIndicator>> tasks) {
        ArrayList<StopAction.HandlerItem> items = new ArrayList<StopAction.HandlerItem>(tasks.size());
        for (final Pair<TaskInfo, ProgressIndicator> eachPair : tasks) {
            items.add(new StopAction.HandlerItem(((TaskInfo)eachPair.first).getTitle(), AllIcons.Process.Step_passive, false){

                @Override
                void stop() {
                    ((ProgressIndicator)eachPair.second).cancel();
                }
            });
        }
        return items;
    }
}

