/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.compound;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.ConfigurationSelectionUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.impl.RunConfigurationSelector;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.ide.DataManager;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class CompoundRunConfigurationSettingsEditor
extends SettingsEditor<CompoundRunConfiguration> {
    private final Project myProject;
    private final JBList myList;
    private final RunManagerImpl myRunManager;
    private final SortedListModel<Pair<RunConfiguration, ExecutionTarget>> myModel;
    private CompoundRunConfiguration mySnapshot;

    public CompoundRunConfigurationSettingsEditor(@NotNull Project project) {
        this.myProject = project;
        this.myRunManager = RunManagerImpl.getInstanceImpl(project);
        this.myModel = new SortedListModel((o1, o2) -> CompoundRunConfiguration.COMPARATOR.compare((RunConfiguration)o1.first, (RunConfiguration)o2.first));
        this.myList = new JBList(this.myModel);
        this.myList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
                RunConfiguration configuration2 = (RunConfiguration)((Pair)((CompoundRunConfigurationSettingsEditor)CompoundRunConfigurationSettingsEditor.this).myModel.get((int)index)).first;
                ExecutionTarget target2 = (ExecutionTarget)((Pair)((CompoundRunConfigurationSettingsEditor)CompoundRunConfigurationSettingsEditor.this).myModel.get((int)index)).second;
                this.setIcon(configuration2.getType().getIcon());
                this.append(ConfigurationSelectionUtil.getDisplayText(configuration2, target2));
            }
        });
        this.myList.setVisibleRowCount(15);
    }

    private boolean canBeAdded(@NotNull RunConfiguration candidate, @NotNull CompoundRunConfiguration root) {
        if (candidate.getType() == root.getType() && candidate.getName().equals(root.getName())) {
            return false;
        }
        List<BeforeRunTask<?>> tasks = RunManagerImplKt.doGetBeforeRunTasks(candidate);
        for (BeforeRunTask<?> task2 : tasks) {
            RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask runTask;
            RunnerAndConfigurationSettings settings;
            if (!(task2 instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask) || (settings = (runTask = (RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)task2).getSettings()) == null || this.canBeAdded(settings.getConfiguration(), root)) continue;
            return false;
        }
        if (candidate instanceof CompoundRunConfiguration) {
            for (RunConfiguration configuration2 : ((CompoundRunConfiguration)candidate).getConfigurationsWithTargets(this.myRunManager).keySet()) {
                if (this.canBeAdded(configuration2, root)) continue;
                return false;
            }
        }
        return true;
    }

    protected void resetEditorFrom(@NotNull CompoundRunConfiguration compoundRunConfiguration) {
        this.myModel.clear();
        this.myModel.addAll((Collection)ContainerUtil.map2List(compoundRunConfiguration.getConfigurationsWithTargets(this.myRunManager)));
        this.mySnapshot = compoundRunConfiguration;
    }

    protected void applyEditorTo(@NotNull CompoundRunConfiguration compoundConfiguration) throws ConfigurationException {
        THashMap checked = new THashMap();
        for (int i = 0; i < this.myModel.getSize(); ++i) {
            Pair configurationAndTarget = (Pair)this.myModel.get(i);
            RunConfiguration configuration2 = (RunConfiguration)configurationAndTarget.first;
            String message = LangBundle.message("compound.run.configuration.cycle", configuration2.getType().getDisplayName(), configuration2.getName());
            if (!this.canBeAdded(configuration2, compoundConfiguration)) {
                throw new ConfigurationException(message);
            }
            checked.put(configuration2, configurationAndTarget.second);
        }
        compoundConfiguration.setConfigurationsWithTargets((Map<RunConfiguration, ? extends ExecutionTarget>)checked);
    }

    @NotNull
    protected JComponent createEditor() {
        final ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)this.myList);
        return decorator.disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                ArrayList<RunConfiguration> configurations = new ArrayList<RunConfiguration>();
                for (RunnerAndConfigurationSettings settings : CompoundRunConfigurationSettingsEditor.this.myRunManager.getAllSettings()) {
                    RunConfiguration configuration2 = settings.getConfiguration();
                    if (CompoundRunConfigurationSettingsEditor.this.mySnapshot.getConfigurationsWithTargets(CompoundRunConfigurationSettingsEditor.this.myRunManager).keySet().contains(configuration2) || !CompoundRunConfigurationSettingsEditor.this.canBeAdded(configuration2, CompoundRunConfigurationSettingsEditor.this.mySnapshot)) continue;
                    configurations.add(configuration2);
                }
                ConfigurationSelectionUtil.createPopup(CompoundRunConfigurationSettingsEditor.this.myProject, CompoundRunConfigurationSettingsEditor.this.myRunManager, configurations, (selectedConfigs, selectedTarget) -> {
                    for (RunConfiguration each : selectedConfigs) {
                        CompoundRunConfigurationSettingsEditor.this.myModel.add((Object)Pair.create((Object)each, (Object)selectedTarget));
                    }
                }).showUnderneathOf((Component)decorator.getActionsPanel());
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                int index = CompoundRunConfigurationSettingsEditor.this.myList.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                RunConfiguration configuration2 = (RunConfiguration)((Pair)((CompoundRunConfigurationSettingsEditor)CompoundRunConfigurationSettingsEditor.this).myModel.get((int)index)).first;
                RunConfigurationSelector selector = (RunConfigurationSelector)RunConfigurationSelector.KEY.getData(DataManager.getInstance().getDataContext((Component)button2.getContextComponent()));
                if (selector != null) {
                    selector.select(configuration2);
                }
            }
        }).setToolbarPosition(ActionToolbarPosition.TOP).createPanel();
    }
}

