/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.compound;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationSelectionUtil {
    @NotNull
    public static String getDisplayText(@NotNull RunConfiguration configuration2, @Nullable ExecutionTarget target2) {
        return configuration2.getType().getDisplayName() + " '" + configuration2.getName() + "'" + (target2 != null && target2 != DefaultExecutionTarget.INSTANCE && !target2.isExternallyManaged() ? " | " + target2.getDisplayName() : "");
    }

    public static ListPopup createPopup(final @NotNull Project project, final @NotNull RunManagerImpl runManager, final @NotNull List<? extends RunConfiguration> configurations, final @NotNull BiConsumer<? super List<RunConfiguration>, ? super ExecutionTarget> onSelected) {
        return JBPopupFactory.getInstance().createListPopup((ListPopupStep)new MultiSelectionListPopupStep<RunConfiguration>(null, configurations){

            @Nullable
            public ListSeparator getSeparatorAbove(RunConfiguration value) {
                int i = configurations.indexOf(value);
                if (i < 1) {
                    return null;
                }
                RunConfiguration previous = (RunConfiguration)configurations.get(i - 1);
                return value.getType() != previous.getType() ? new ListSeparator() : null;
            }

            public Icon getIconFor(RunConfiguration value) {
                return value.getType().getIcon();
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @NotNull
            public String getTextFor(RunConfiguration value) {
                return value.getName();
            }

            @Override
            public PopupStep<?> onChosen(final List<RunConfiguration> selectedConfigs, boolean finalChoice) {
                if (finalChoice) {
                    onSelected.accept(selectedConfigs, null);
                    return FINAL_CHOICE;
                }
                return new BaseListPopupStep<ExecutionTarget>(null, this.getTargets(selectedConfigs)){

                    public boolean isSpeedSearchEnabled() {
                        return true;
                    }

                    public Icon getIconFor(ExecutionTarget value) {
                        return value.getIcon();
                    }

                    @NotNull
                    public String getTextFor(ExecutionTarget value) {
                        return value.getDisplayName();
                    }

                    public PopupStep onChosen(ExecutionTarget selectedTarget, boolean finalChoice) {
                        onSelected.accept(selectedConfigs, selectedTarget);
                        return FINAL_CHOICE;
                    }
                };
            }

            @Override
            public boolean hasSubstep(List<RunConfiguration> selectedValues) {
                return !this.getTargets(selectedValues).isEmpty();
            }

            @NotNull
            public List<ExecutionTarget> getTargets(List<RunConfiguration> selectedValues) {
                LinkedHashSet intersection = new LinkedHashSet();
                for (int i = 0; i < selectedValues.size(); ++i) {
                    List targets2;
                    RunConfiguration config2 = selectedValues.get(i);
                    RunnerAndConfigurationSettingsImpl settings = runManager.getSettings(config2);
                    List list2 = targets2 = settings == null ? Collections.emptyList() : ExecutionTargetManager.getTargetsToChooseFor((Project)project, (RunConfiguration)settings.getConfiguration());
                    if (i == 0) {
                        intersection.addAll(targets2);
                        continue;
                    }
                    intersection.retainAll(targets2);
                }
                return new ArrayList<ExecutionTarget>(intersection);
            }
        });
    }
}

