/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.google.common.collect.ImmutableMap;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class EnvironmentVariablesData {
    public static final EnvironmentVariablesData DEFAULT = new EnvironmentVariablesData((Map<String, String>)ImmutableMap.of(), true);
    private static final String ENVS = "envs";
    private static final String PASS_PARENT_ENVS = "pass-parent-envs";
    private static final String ENV = "env";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private final ImmutableMap<String, String> myEnvs;
    private final boolean myPassParentEnvs;

    private EnvironmentVariablesData(@NotNull Map<String, String> envs, boolean passParentEnvs) {
        this.myEnvs = ImmutableMap.copyOf(envs);
        this.myPassParentEnvs = passParentEnvs;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        return this.myEnvs;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentVariablesData data = (EnvironmentVariablesData)o;
        return this.myPassParentEnvs == data.myPassParentEnvs && this.myEnvs.equals(data.myEnvs);
    }

    public int hashCode() {
        int result2 = this.myEnvs.hashCode();
        result2 = 31 * result2 + (this.myPassParentEnvs ? 1 : 0);
        return result2;
    }

    public String toString() {
        return "envs=" + this.myEnvs + ", passParentEnvs=" + this.myPassParentEnvs;
    }

    @NotNull
    public static EnvironmentVariablesData readExternal(@NotNull Element element) {
        Element envsElement = element.getChild(ENVS);
        if (envsElement == null) {
            return DEFAULT;
        }
        Object envs = ImmutableMap.of();
        String passParentEnvsStr = envsElement.getAttributeValue(PASS_PARENT_ENVS);
        boolean passParentEnvs = passParentEnvsStr == null || Boolean.parseBoolean(passParentEnvsStr);
        for (Element envElement : envsElement.getChildren(ENV)) {
            String envName = envElement.getAttributeValue(NAME);
            String envValue = envElement.getAttributeValue(VALUE);
            if (envName == null || envValue == null) continue;
            if (envs.isEmpty()) {
                envs = ContainerUtil.newLinkedHashMap();
            }
            envs.put(envName, envValue);
        }
        return EnvironmentVariablesData.create((Map<String, String>)envs, passParentEnvs);
    }

    public void writeExternal(@NotNull Element parent) {
        Element envsElement = new Element(ENVS);
        if (!this.myPassParentEnvs) {
            envsElement.setAttribute(PASS_PARENT_ENVS, Boolean.FALSE.toString());
        }
        for (Map.Entry entry : this.myEnvs.entrySet()) {
            envsElement.addContent(new Element(ENV).setAttribute(NAME, (String)entry.getKey()).setAttribute(VALUE, (String)entry.getValue()));
        }
        parent.addContent(envsElement);
    }

    public void configureCommandLine(@NotNull GeneralCommandLine commandLine, boolean consoleParentEnvs) {
        commandLine.withParentEnvironmentType(!this.myPassParentEnvs ? GeneralCommandLine.ParentEnvironmentType.NONE : (consoleParentEnvs ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.SYSTEM));
        commandLine.withEnvironment(this.myEnvs);
    }

    @NotNull
    public static EnvironmentVariablesData create(@NotNull Map<String, String> envs, boolean passParentEnvs) {
        return passParentEnvs && envs.isEmpty() ? DEFAULT : new EnvironmentVariablesData(envs, passParentEnvs);
    }
}

