/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleHistoryModel;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultConsoleHistoryModel
extends SimpleModificationTracker
implements ConsoleHistoryModel {
    private static final Map<String, DefaultConsoleHistoryModel> ourModels = ConcurrentFactoryMap.createMap(key -> new DefaultConsoleHistoryModel(null), ContainerUtil::createConcurrentWeakValueMap);
    private final Object myLock;
    private final LinkedList<String> myEntries;
    private int myIndex;
    private String myContent;

    public static DefaultConsoleHistoryModel createModel(String persistenceId) {
        return ourModels.get(persistenceId).copy();
    }

    DefaultConsoleHistoryModel(@Nullable DefaultConsoleHistoryModel masterModel) {
        LinkedList<String> linkedList;
        if (masterModel == null) {
            LinkedList<String> linkedList2;
            linkedList = linkedList2;
        } else {
            linkedList = masterModel.myEntries;
        }
        this.myEntries = linkedList;
        this.myLock = masterModel == null ? this : masterModel.myLock;
        this.resetIndex();
    }

    public DefaultConsoleHistoryModel copy() {
        return new DefaultConsoleHistoryModel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetEntries(@NotNull List<String> entries2) {
        Object object = this.myLock;
        synchronized (object) {
            this.myEntries.clear();
            this.myEntries.addAll(ContainerUtil.getFirstItems(entries2, (int)this.getMaxHistorySize()));
            this.incModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToHistory(@Nullable String statement) {
        if (StringUtil.isEmptyOrSpaces((String)statement)) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            int maxHistorySize = this.getMaxHistorySize();
            this.myEntries.remove(statement);
            int size = this.myEntries.size();
            if (size >= maxHistorySize && size > 0) {
                this.myEntries.removeFirst();
            }
            this.myEntries.addLast(statement);
            this.incModificationCount();
        }
    }

    public void incModificationCount() {
        this.resetIndex();
        super.incModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetIndex() {
        Object object = this.myLock;
        synchronized (object) {
            this.myIndex = this.myEntries.size();
        }
    }

    @Override
    public int getMaxHistorySize() {
        return UISettings.getInstance().getConsoleCommandHistoryLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromHistory(String statement) {
        Object object = this.myLock;
        synchronized (object) {
            this.myEntries.remove(statement);
            this.incModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<String> getEntries() {
        Object object = this.myLock;
        synchronized (object) {
            return ContainerUtil.newArrayList(this.myEntries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myEntries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHistorySize() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myEntries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ConsoleHistoryModel.Entry getHistoryNext() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIndex >= 0) {
                --this.myIndex;
            }
            return new ConsoleHistoryModel.Entry(this.getCurrentEntry(), -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ConsoleHistoryModel.Entry getHistoryPrev() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIndex <= this.myEntries.size() - 1) {
                ++this.myIndex;
            }
            return new ConsoleHistoryModel.Entry(this.getCurrentEntry(), -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasHistory() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myIndex <= this.myEntries.size() - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getCurrentEntry() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myIndex >= 0 && this.myIndex < this.myEntries.size() ? this.myEntries.get(this.myIndex) : (this.myIndex == this.myEntries.size() ? this.myContent : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentIndex() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myIndex;
        }
    }

    @Override
    public void setContent(@NotNull String userContent) {
        this.myContent = userContent;
    }
}

