/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.dashboard.RunDashboardGroup;
import com.intellij.execution.dashboard.RunDashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.dashboard.tree.RunConfigurationNode;
import com.intellij.execution.dashboard.tree.RunDashboardTreeCellRenderer;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.ide.DataManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationsServiceViewContributor
implements ServiceViewContributor<RunConfigurationNode, RunDashboardGroup, RunDashboardRunConfigurationStatus> {
    @NotNull
    public List<RunConfigurationNode> getNodes(@NotNull Project project) {
        RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)project);
        return ContainerUtil.map((Collection)runDashboardManager.getRunConfigurations(), value -> new RunConfigurationNode(project, (Pair<RunnerAndConfigurationSettings, RunContentDescriptor>)value, runDashboardManager.getContributor(((RunnerAndConfigurationSettings)value.first).getType())));
    }

    @NotNull
    public ServiceViewContributor.ViewDescriptor getNodeDescriptor(final @NotNull RunConfigurationNode node) {
        return new ServiceViewContributor.ViewDescriptor(){
            private boolean selected;

            public JComponent getContentComponent() {
                Content content = node.getContent();
                return content == null ? RunConfigurationsServiceViewContributor.createEmptyContent() : content.getManager().getComponent();
            }

            public ActionGroup getToolbarActions() {
                return RunConfigurationsServiceViewContributor.getToolbarActions(node.getDescriptor());
            }

            public ActionGroup getPopupActions() {
                return RunConfigurationsServiceViewContributor.getPopupActions();
            }

            public ItemPresentation getPresentation() {
                return node.getPresentation();
            }

            public DataProvider getDataProvider() {
                Content content = node.getContent();
                if (content == null) {
                    return null;
                }
                DataContext context = DataManager.getInstance().getDataContext((Component)content.getComponent());
                return arg_0 -> ((DataContext)context).getData(arg_0);
            }

            public void onNodeSelected() {
                ContentManager contentManager;
                this.selected = true;
                Content content = node.getContent();
                ContentManager contentManager2 = contentManager = content == null ? null : content.getManager();
                if (contentManager == null || content == contentManager.getSelectedContent()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    if (contentManager.isDisposed() || contentManager.getIndexOfContent(content) == -1 || !this.selected) {
                        return;
                    }
                    contentManager.setSelectedContent(content);
                });
            }

            public void onNodeUnselected() {
                ContentManager contentManager;
                this.selected = false;
                Content content = node.getContent();
                ContentManager contentManager2 = contentManager = content == null ? null : content.getManager();
                if (contentManager == null || content != contentManager.getSelectedContent()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    if (contentManager.isDisposed() || !contentManager.isSelected(content) || this.selected) {
                        return;
                    }
                    contentManager.removeFromSelection(content);
                });
            }

            public boolean handleDoubleClick(@NotNull MouseEvent event) {
                RunDashboardContributor contributor = node.getContributor();
                return contributor != null && contributor.handleDoubleClick(node.getConfigurationSettings().getConfiguration());
            }
        };
    }

    @Nullable
    public ServiceViewContributor.ViewDescriptorRenderer getViewDescriptorRenderer() {
        return new ServiceViewContributor.ViewDescriptorRenderer(){
            final RunDashboardTreeCellRenderer renderer = new RunDashboardTreeCellRenderer();

            @NotNull
            public Component getRendererComponent(JComponent parent, Object value, ServiceViewContributor.ViewDescriptor viewDescriptor, boolean selected, boolean hasFocus) {
                return this.renderer.getTreeCellRendererComponent((JTree)parent, value, selected, true, true, 0, hasFocus);
            }
        };
    }

    @NotNull
    public List<RunDashboardGroup> getGroups(@NotNull RunConfigurationNode node) {
        ArrayList<RunDashboardGroup> result2 = new ArrayList<RunDashboardGroup>();
        for (RunDashboardGroupingRule rule : RunDashboardGroupingRule.EP_NAME.getExtensionList()) {
            ContainerUtil.addIfNotNull(result2, (Object)rule.getGroup((AbstractTreeNode)node));
        }
        return result2;
    }

    @NotNull
    public ServiceViewContributor.ViewDescriptor getGroupDescriptor(@NotNull RunDashboardGroup group) {
        final PresentationData presentationData = new PresentationData();
        presentationData.setPresentableText(group.getName());
        presentationData.setIcon(group.getIcon());
        return new ServiceViewContributor.ViewDescriptor(){

            public JComponent getContentComponent() {
                return null;
            }

            public ActionGroup getToolbarActions() {
                return RunConfigurationsServiceViewContributor.getToolbarActions(null);
            }

            public ActionGroup getPopupActions() {
                return RunConfigurationsServiceViewContributor.getPopupActions();
            }

            public ItemPresentation getPresentation() {
                return presentationData;
            }

            public DataProvider getDataProvider() {
                return null;
            }
        };
    }

    @NotNull
    public RunDashboardRunConfigurationStatus getState(@NotNull RunConfigurationNode node) {
        return node.getStatus();
    }

    @NotNull
    public ServiceViewContributor.ViewDescriptor getStateDescriptor(@NotNull RunDashboardRunConfigurationStatus status) {
        final PresentationData presentationData = new PresentationData();
        presentationData.setPresentableText(status.getName());
        presentationData.setIcon(status.getIcon());
        return new ServiceViewContributor.ViewDescriptor(){

            public JComponent getContentComponent() {
                return null;
            }

            public ActionGroup getToolbarActions() {
                return null;
            }

            public ItemPresentation getPresentation() {
                return presentationData;
            }

            public DataProvider getDataProvider() {
                return null;
            }
        };
    }

    @NotNull
    private static JComponent createEmptyContent() {
        return new JBPanelWithEmptyText().withEmptyText(ExecutionBundle.message((String)"run.dashboard.not.started.configuration.message", (Object[])new Object[0]));
    }

    private static ActionGroup getToolbarActions(@Nullable RunContentDescriptor descriptor) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("RunDashboardContentToolbar"));
        RunnerLayoutUiImpl ui = RunDashboardManagerImpl.getRunnerLayoutUi(descriptor);
        if (ui == null) {
            return actionGroup;
        }
        List<AnAction> leftToolbarActions = ui.getActions();
        for (AnAction action : leftToolbarActions) {
            if (action instanceof StopAction || action instanceof FakeRerunAction) continue;
            actionGroup.add(action);
        }
        return actionGroup;
    }

    private static ActionGroup getPopupActions() {
        DefaultActionGroup actions = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        actions.add(actionManager.getAction("RunDashboardContentToolbar"));
        actions.addSeparator();
        actions.add(actionManager.getAction("RunDashboardTreeToolbar"));
        actions.add(actionManager.getAction("RunDashboardPopup"));
        return actions;
    }
}

