/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.PanelContentUI;
import com.intellij.execution.dashboard.RunConfigurationsServiceViewContributor;
import com.intellij.execution.dashboard.RunDashboardAnimator;
import com.intellij.execution.dashboard.RunDashboardContent;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.dashboard.RunDashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.tree.RunConfigurationNode;
import com.intellij.execution.dashboard.tree.RunDashboardGrouper;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="RunDashboard", storages={@Storage(value="$WORKSPACE_FILE$")})
public class RunDashboardManagerImpl
implements RunDashboardManager,
PersistentStateComponent<State> {
    private static final float DEFAULT_CONTENT_PROPORTION = 0.3f;
    @NonNls
    private static final String HELP_ID = "run-dashboard.reference";
    @NotNull
    private final Project myProject;
    @NotNull
    private final ContentManager myContentManager;
    @NotNull
    private final ContentManagerListener myContentManagerListener;
    @NotNull
    private State myState = new State();
    @NotNull
    private final List<RunDashboardGrouper> myGroupers;
    @NotNull
    private final Condition<Content> myReuseCondition;
    @NotNull
    private final AtomicBoolean myListenersInitialized = new AtomicBoolean();
    private boolean myShowConfigurations = true;
    private RunDashboardContent myDashboardContent;
    private Content myToolWindowContent;
    private ContentManager myToolWindowContentManager;
    private ContentManagerListener myToolWindowContentManagerListener;
    private final Map<Content, Content> myDashboardToToolWindowContents = new HashMap<Content, Content>();

    public RunDashboardManagerImpl(@NotNull Project project) {
        this.myProject = project;
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        this.myContentManager = contentFactory.createContentManager((ContentUI)new PanelContentUI(), false, project);
        this.myContentManagerListener = new DashboardContentManagerListener();
        this.myContentManager.addContentManagerListener(this.myContentManagerListener);
        this.myReuseCondition = this::canReuseContent;
        this.myGroupers = ContainerUtil.map((Object[])RunDashboardGroupingRule.EP_NAME.getExtensions(), RunDashboardGrouper::new);
    }

    private void initToolWindowContentListeners() {
        if (!this.myListenersInitialized.compareAndSet(false, true)) {
            return;
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){
            private volatile boolean myUpdateStarted;

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            @Override
            public void beginUpdate() {
                this.myUpdateStarted = true;
            }

            @Override
            public void endUpdate() {
                this.myUpdateStarted = false;
                RunDashboardManagerImpl.this.updateDashboard(true);
            }
        });
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                RunDashboardManagerImpl.this.updateToolWindowContent();
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2, int exitCode) {
                RunDashboardManagerImpl.this.updateToolWindowContent();
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }
        });
        connection.subscribe(RunDashboardManager.DASHBOARD_TOPIC, (Object)new RunDashboardListener(){

            public void contentChanged(boolean withStructure) {
                RunDashboardManagerImpl.this.updateDashboard(withStructure);
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                RunDashboardManagerImpl.this.updateDashboard(false);
            }
        });
        this.myContentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                RunnerLayoutUiImpl ui;
                boolean onAdd;
                boolean bl = onAdd = event.getOperation() == ContentManagerEvent.ContentOperation.add;
                if (onAdd && (ui = RunDashboardManagerImpl.getRunnerLayoutUi(RunContentManagerImpl.getRunContentDescriptorByContent(event.getContent()))) != null) {
                    ui.setLeftToolbarVisible(false);
                    ui.setContentToolbarBefore(false);
                }
                RunDashboardManagerImpl.this.updateToolWindowContent();
                RunDashboardManagerImpl.this.updateDashboard(true);
                if (Registry.is((String)"ide.service.view") && onAdd) {
                    RunContentDescriptor contentDescriptor = RunContentManagerImpl.getRunContentDescriptorByContent(event.getContent());
                    Set<RunnerAndConfigurationSettings> configurationsSettings = ExecutionManagerImpl.getInstance(RunDashboardManagerImpl.this.myProject).getConfigurations(contentDescriptor);
                    RunnerAndConfigurationSettings configurationSettings = (RunnerAndConfigurationSettings)ContainerUtil.getFirstItem(configurationsSettings);
                    if (configurationSettings != null) {
                        RunConfigurationNode node = new RunConfigurationNode(RunDashboardManagerImpl.this.myProject, (Pair<RunnerAndConfigurationSettings, RunContentDescriptor>)Pair.create((Object)configurationSettings, (Object)contentDescriptor), RunDashboardManagerImpl.this.getContributor(configurationSettings.getType()));
                        ServiceViewManager.getInstance((Project)RunDashboardManagerImpl.this.myProject).selectNode((Object)node);
                    }
                }
            }

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (RunDashboardManagerImpl.this.myContentManager.getContentCount() == 0 && !RunDashboardManagerImpl.this.isShowConfigurations()) {
                    RunDashboardManagerImpl.this.setShowConfigurations(true);
                }
            }
        });
    }

    public ContentManager getDashboardContentManager() {
        return this.myContentManager;
    }

    public String getToolWindowId() {
        return Registry.is((String)"ide.service.view") ? ToolWindowId.SERVICES : ToolWindowId.RUN_DASHBOARD;
    }

    public Icon getToolWindowIcon() {
        return AllIcons.Toolwindows.ToolWindowRun;
    }

    public String getToolWindowContextHelpId() {
        return HELP_ID;
    }

    public boolean isToolWindowAvailable() {
        return this.hasContent();
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        this.myDashboardContent = new RunDashboardContent(this.myProject, this.myContentManager, this.myGroupers);
        this.myToolWindowContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)this.myDashboardContent, null, false);
        this.myToolWindowContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        this.myToolWindowContent.setHelpId(this.getToolWindowContextHelpId());
        this.myToolWindowContent.setCloseable(false);
        Disposer.register((Disposable)this.myToolWindowContent, (Disposable)this.myDashboardContent);
        Disposer.register((Disposable)this.myToolWindowContent, () -> {
            this.myDashboardContent = null;
            this.myToolWindowContent = null;
            this.myToolWindowContentManager.removeContentManagerListener(this.myToolWindowContentManagerListener);
            this.myToolWindowContentManager = null;
            this.myToolWindowContentManagerListener = null;
            this.myDashboardToToolWindowContents.clear();
        });
        this.myToolWindowContentManager = toolWindow.getContentManager();
        this.myToolWindowContentManager.addContent(this.myToolWindowContent);
        this.myToolWindowContentManagerListener = new ToolWindowContentManagerListener();
        this.myToolWindowContentManager.addContentManagerListener(this.myToolWindowContentManagerListener);
    }

    public List<Pair<RunnerAndConfigurationSettings, RunContentDescriptor>> getRunConfigurations() {
        ArrayList<Pair<RunnerAndConfigurationSettings, RunContentDescriptor>> result2 = new ArrayList<Pair<RunnerAndConfigurationSettings, RunContentDescriptor>>();
        List configurations = ContainerUtil.filter((Collection)RunManager.getInstance((Project)this.myProject).getAllSettings(), settings -> this.myState.configurationTypes.contains(settings.getType().getId()));
        ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(this.myProject);
        configurations.forEach(configurationSettings -> {
            List<RunContentDescriptor> descriptors = this.filterByContent(executionManager.getDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)settings -> Comparing.equal((Object)settings.getConfiguration(), (Object)configurationSettings.getConfiguration()))));
            if (descriptors.isEmpty() && this.isShowInDashboard(configurationSettings.getConfiguration())) {
                result2.add(Pair.create((Object)configurationSettings, null));
            } else {
                descriptors.forEach(descriptor -> result2.add(Pair.create((Object)configurationSettings, (Object)descriptor)));
            }
        });
        List storedConfigurations = ContainerUtil.map((Collection)configurations, RunnerAndConfigurationSettings::getConfiguration);
        List<RunContentDescriptor> notStoredDescriptors = this.filterByContent(executionManager.getDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)settings -> !storedConfigurations.contains(settings.getConfiguration()))));
        notStoredDescriptors.forEach(descriptor -> {
            Set<RunnerAndConfigurationSettings> settings = executionManager.getConfigurations((RunContentDescriptor)descriptor);
            settings.forEach(setting -> result2.add(Pair.create((Object)setting, (Object)descriptor)));
        });
        return result2;
    }

    private List<RunContentDescriptor> filterByContent(List<RunContentDescriptor> descriptors) {
        return ContainerUtil.filter(descriptors, descriptor -> {
            Content content = descriptor.getAttachedContent();
            return content != null && content.getManager() == this.myContentManager;
        });
    }

    public boolean isShowConfigurations() {
        return this.myShowConfigurations;
    }

    public void setShowConfigurations(boolean value) {
        this.myShowConfigurations = value;
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (toolWindowManager == null) {
            return;
        }
        toolWindowManager.invokeLater(() -> {
            Content content;
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myToolWindowContentManager != null && (content = this.myToolWindowContentManager.getSelectedContent()) != null && content.equals(this.myToolWindowContent)) {
                this.myToolWindowContentManager.setSelectedContent(content, true);
            }
        });
        this.updateDashboard(false);
        this.updateToolWindowContent();
    }

    public float getContentProportion() {
        return this.myState.contentProportion;
    }

    public RunDashboardAnimator getAnimator() {
        if (this.myDashboardContent == null) {
            return null;
        }
        return this.myDashboardContent.getAnimator();
    }

    public boolean isShowInDashboard(@NotNull RunConfiguration runConfiguration) {
        if (this.myState.configurationTypes.contains(runConfiguration.getType().getId())) {
            RunDashboardContributor contributor = this.getContributor(runConfiguration.getType());
            return contributor == null || contributor.isShowInDashboard(runConfiguration);
        }
        return false;
    }

    @NotNull
    public Set<String> getTypes() {
        return Collections.unmodifiableSet(this.myState.configurationTypes);
    }

    public void setTypes(@NotNull Set<String> types) {
        this.myState.configurationTypes.clear();
        this.myState.configurationTypes.addAll(types);
        if (!this.myState.configurationTypes.isEmpty()) {
            this.initToolWindowContentListeners();
        }
        this.updateDashboard(true);
    }

    @Nullable
    public RunDashboardContributor getContributor(@NotNull ConfigurationType type) {
        for (RunDashboardContributor contributor : (RunDashboardContributor[])RunDashboardContributor.EP_NAME.getExtensions()) {
            if (!type.equals(contributor.getType())) continue;
            return contributor;
        }
        return null;
    }

    private void updateDashboardIfNeeded(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings != null && (this.getContributor(settings.getType()) != null || this.isShowInDashboard(settings.getConfiguration()))) {
            this.updateDashboard(true);
        }
    }

    @NotNull
    public Condition<Content> getReuseCondition() {
        return this.myReuseCondition;
    }

    private boolean canReuseContent(Content content) {
        RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
        if (descriptor == null) {
            return false;
        }
        ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(this.myProject);
        Set<RunnerAndConfigurationSettings> descriptorConfigurations = executionManager.getConfigurations(descriptor);
        if (descriptorConfigurations.isEmpty()) {
            return true;
        }
        HashSet storedConfigurations = new HashSet(RunManager.getInstance((Project)this.myProject).getAllConfigurationsList());
        return descriptorConfigurations.stream().noneMatch(descriptorConfiguration -> {
            RunConfiguration configuration2 = descriptorConfiguration.getConfiguration();
            return this.isShowInDashboard(configuration2) && storedConfigurations.contains(configuration2);
        });
    }

    public void updateDashboard(boolean withStructure) {
        ((ServiceViewContributor.ServiceListener)this.myProject.getMessageBus().syncPublisher(ServiceViewContributor.TOPIC)).handle(new ServiceViewContributor.ServiceEvent(RunConfigurationsServiceViewContributor.class));
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (toolWindowManager == null) {
            return;
        }
        toolWindowManager.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (withStructure) {
                boolean canCreate = !Registry.is((String)"ide.service.view");
                boolean available = this.hasContent() && canCreate;
                ToolWindow toolWindow = toolWindowManager.getToolWindow(this.getToolWindowId());
                if (toolWindow == null) {
                    if (canCreate && (!this.myState.configurationTypes.isEmpty() || available)) {
                        toolWindow = this.createToolWindow(toolWindowManager, available);
                    }
                    if (available) {
                        toolWindow.show(null);
                    }
                    return;
                }
                if (canCreate) {
                    boolean doShow = !toolWindow.isAvailable() && available;
                    toolWindow.setAvailable(available, null);
                    if (doShow) {
                        toolWindow.show(null);
                    }
                }
            }
            if (this.myDashboardContent != null) {
                this.myDashboardContent.updateContent(withStructure);
            }
        });
    }

    private ToolWindow createToolWindow(ToolWindowManager toolWindowManager, boolean available) {
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(this.getToolWindowId(), true, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject, true);
        toolWindow.setIcon(this.getToolWindowIcon());
        toolWindow.setAvailable(available, null);
        this.createToolWindowContent(toolWindow);
        return toolWindow;
    }

    private boolean hasContent() {
        return !this.getRunConfigurations().isEmpty();
    }

    private void updateToolWindowContent() {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (toolWindowManager == null) {
            return;
        }
        toolWindowManager.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myToolWindowContent == null || this.myToolWindowContentManager == null || this.myToolWindowContentManagerListener == null) {
                return;
            }
            boolean containsConfigurationsContent = false;
            for (Content content : this.myToolWindowContentManager.getContents()) {
                if (!this.myToolWindowContent.equals(content)) continue;
                containsConfigurationsContent = true;
                break;
            }
            if (this.myShowConfigurations) {
                if (!containsConfigurationsContent) {
                    this.myToolWindowContentManager.removeContentManagerListener(this.myToolWindowContentManagerListener);
                    this.myDashboardToToolWindowContents.clear();
                    this.myToolWindowContentManager.removeAllContents(true);
                    this.myToolWindowContentManager.addContent(this.myToolWindowContent);
                    this.myToolWindowContentManager.addContentManagerListener(this.myToolWindowContentManagerListener);
                }
                this.updateToolWindowContentTabHeader(this.myContentManager.getSelectedContent());
            } else if (containsConfigurationsContent) {
                Content contentToSelect;
                this.myToolWindowContentManager.removeContentManagerListener(this.myToolWindowContentManagerListener);
                this.myToolWindowContentManager.removeContent(this.myToolWindowContent, false);
                for (Content dashboardContent : this.myContentManager.getContents()) {
                    this.addToolWindowContent(dashboardContent);
                }
                Content dashboardSelectedContent = this.myContentManager.getSelectedContent();
                if (dashboardSelectedContent == null && this.myContentManager.getContentCount() > 0 && (dashboardSelectedContent = this.myContentManager.getContent(0)) != null) {
                    this.myContentManager.setSelectedContent(dashboardSelectedContent);
                }
                if ((contentToSelect = this.myDashboardToToolWindowContents.get(dashboardSelectedContent)) != null) {
                    this.myToolWindowContentManager.setSelectedContent(contentToSelect, true);
                }
                this.myToolWindowContentManager.addContentManagerListener(this.myToolWindowContentManagerListener);
            }
            ToolWindow toolWindow = toolWindowManager.getToolWindow(this.getToolWindowId());
            if (toolWindow instanceof ToolWindowImpl) {
                ToolWindowContentUi contentUi = ((ToolWindowImpl)toolWindow).getContentUI();
                contentUi.revalidate();
                contentUi.repaint();
            }
        });
    }

    private void addToolWindowContent(final Content dashboardContent) {
        if (this.myToolWindowContentManager == null) {
            return;
        }
        final Content toolWindowContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)this.myDashboardContent, dashboardContent.getDisplayName(), false);
        toolWindowContent.setIcon(dashboardContent.getIcon());
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if ("displayName".equals(property)) {
                    toolWindowContent.setDisplayName(dashboardContent.getDisplayName());
                } else if ("icon".equals(property)) {
                    toolWindowContent.setIcon(dashboardContent.getIcon());
                }
            }
        };
        Disposer.register((Disposable)toolWindowContent, () -> dashboardContent.removePropertyChangeListener(propertyChangeListener));
        dashboardContent.addPropertyChangeListener(propertyChangeListener);
        toolWindowContent.setShouldDisposeContent(false);
        toolWindowContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        toolWindowContent.setHelpId(this.getToolWindowContextHelpId());
        this.myToolWindowContentManager.addContent(toolWindowContent);
        this.myDashboardToToolWindowContents.put(dashboardContent, toolWindowContent);
    }

    private void updateToolWindowContentTabHeader(@Nullable Content content) {
        if (content != null) {
            this.myToolWindowContent.setDisplayName(content.getDisplayName());
            this.myToolWindowContent.setIcon(content.getIcon());
            this.myToolWindowContent.setCloseable(true);
        } else {
            this.myToolWindowContent.setDisplayName(null);
            this.myToolWindowContent.setIcon(null);
            this.myToolWindowContent.setCloseable(false);
        }
    }

    @Nullable
    static RunnerLayoutUiImpl getRunnerLayoutUi(@Nullable RunContentDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        RunnerLayoutUi layoutUi = descriptor.getRunnerLayoutUi();
        return layoutUi instanceof RunnerLayoutUiImpl ? (RunnerLayoutUiImpl)layoutUi : null;
    }

    @Nullable
    public State getState() {
        List<RuleState> ruleStates = this.myState.ruleStates;
        ruleStates.clear();
        for (RunDashboardGrouper grouper : this.myGroupers) {
            if (grouper.getRule().isAlwaysEnabled()) continue;
            ruleStates.add(new RuleState(grouper.getRule().getName(), grouper.isEnabled()));
        }
        if (this.myDashboardContent != null) {
            this.myState.contentProportion = this.myDashboardContent.getContentProportion();
        }
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
        if (!this.myState.configurationTypes.isEmpty()) {
            this.initToolWindowContentListeners();
        }
        block0: for (RuleState ruleState : state.ruleStates) {
            for (RunDashboardGrouper grouper : this.myGroupers) {
                if (!grouper.getRule().getName().equals(ruleState.name) || grouper.getRule().isAlwaysEnabled()) continue;
                grouper.setEnabled(ruleState.enabled);
                continue block0;
            }
        }
    }

    private class ToolWindowContentManagerListener
    extends ContentManagerAdapter {
        private ToolWindowContentManagerListener() {
        }

        public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
            if (event.getContent().equals(RunDashboardManagerImpl.this.myToolWindowContent)) {
                Content content = RunDashboardManagerImpl.this.myContentManager.getSelectedContent();
                if (content != null) {
                    RunDashboardManagerImpl.this.myContentManager.removeContent(content, true);
                }
                event.consume();
                return;
            }
            Content dashboardContent = this.getDashboardContent(event.getContent());
            if (dashboardContent == null || dashboardContent.getManager() == null) {
                return;
            }
            RunDashboardManagerImpl.this.myDashboardToToolWindowContents.remove(dashboardContent);
            if (!RunDashboardManagerImpl.this.myContentManager.removeContent(dashboardContent, true)) {
                event.consume();
                RunDashboardManagerImpl.this.myDashboardToToolWindowContents.put(dashboardContent, event.getContent());
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            if (event.getContent().equals(RunDashboardManagerImpl.this.myToolWindowContent)) {
                return;
            }
            if (event.getOperation() != ContentManagerEvent.ContentOperation.add) {
                return;
            }
            Content dashboardContent = this.getDashboardContent(event.getContent());
            if (dashboardContent == null || dashboardContent.getManager() == null || RunDashboardManagerImpl.this.myContentManager.isSelected(dashboardContent)) {
                return;
            }
            RunDashboardManagerImpl.this.myContentManager.removeContentManagerListener(RunDashboardManagerImpl.this.myContentManagerListener);
            RunDashboardManagerImpl.this.myContentManager.setSelectedContent(dashboardContent);
            RunDashboardManagerImpl.this.myContentManager.addContentManagerListener(RunDashboardManagerImpl.this.myContentManagerListener);
        }

        private Content getDashboardContent(Content content) {
            for (Map.Entry entry : RunDashboardManagerImpl.this.myDashboardToToolWindowContents.entrySet()) {
                if (!((Content)entry.getValue()).equals(content)) continue;
                return (Content)entry.getKey();
            }
            return null;
        }
    }

    private class DashboardContentManagerListener
    extends ContentManagerAdapter {
        private DashboardContentManagerListener() {
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            if (RunDashboardManagerImpl.this.myShowConfigurations || RunDashboardManagerImpl.this.myToolWindowContentManager == null) {
                return;
            }
            Content toolWindowContent = (Content)RunDashboardManagerImpl.this.myDashboardToToolWindowContents.get(event.getContent());
            if (toolWindowContent == null) {
                RunDashboardManagerImpl.this.addToolWindowContent(event.getContent());
            } else if (!RunDashboardManagerImpl.this.myToolWindowContentManager.isSelected(toolWindowContent)) {
                RunDashboardManagerImpl.this.myToolWindowContentManager.setSelectedContent(toolWindowContent);
            }
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            if (RunDashboardManagerImpl.this.myShowConfigurations || RunDashboardManagerImpl.this.myToolWindowContentManager == null) {
                return;
            }
            Content toolWindowContent = (Content)RunDashboardManagerImpl.this.myDashboardToToolWindowContents.remove(event.getContent());
            if (toolWindowContent != null && toolWindowContent.getManager() != null) {
                RunDashboardManagerImpl.this.myToolWindowContentManager.removeContentManagerListener(RunDashboardManagerImpl.this.myToolWindowContentManagerListener);
                RunDashboardManagerImpl.this.myToolWindowContentManager.removeContent(toolWindowContent, true);
                RunDashboardManagerImpl.this.myToolWindowContentManager.addContentManagerListener(RunDashboardManagerImpl.this.myToolWindowContentManagerListener);
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                this.contentAdded(event);
            }
            if (RunDashboardManagerImpl.this.myToolWindowContentManager == null || RunDashboardManagerImpl.this.myToolWindowContent == null || !RunDashboardManagerImpl.this.myShowConfigurations) {
                return;
            }
            Content content = event.getOperation() == ContentManagerEvent.ContentOperation.add ? event.getContent() : null;
            RunDashboardManagerImpl.this.updateToolWindowContentTabHeader(content);
        }
    }

    private static class RuleState {
        public String name;
        public boolean enabled = true;

        RuleState() {
        }

        RuleState(String name, boolean enabled) {
            this.name = name;
            this.enabled = enabled;
        }
    }

    static class State {
        public final Set<String> configurationTypes = new THashSet();
        public final List<RuleState> ruleStates = new ArrayList<RuleState>();
        public float contentProportion = 0.3f;

        State() {
        }
    }
}

