/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RunDashboardUsagesCollector
extends ProjectUsagesCollector {
    @Override
    @NotNull
    public String getGroupId() {
        return "run.dashboard";
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        HashSet<UsageDescriptor> usages = new HashSet<UsageDescriptor>();
        Set dashboardTypes = RunDashboardManager.getInstance((Project)project).getTypes();
        usages.add(StatisticsUtilKt.getBooleanUsage("run.dashboard", !dashboardTypes.isEmpty()));
        if (!dashboardTypes.isEmpty()) {
            List configurationTypes = ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList();
            for (String dashboardType : dashboardTypes) {
                ConfigurationType configurationType = (ConfigurationType)ContainerUtil.find((Iterable)configurationTypes, type -> type.getId().equals(dashboardType));
                if (configurationType == null) continue;
                String key = PluginInfoDetectorKt.getPluginInfo(configurationType.getClass()).isDevelopedByJetBrains() ? dashboardType : "third.party";
                usages.add(new UsageDescriptor(key));
            }
        }
        return usages;
    }
}

