/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.actions.RunDashboardActionUtils;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class CopyConfigurationAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        RunDashboardRunConfigurationNode node = project == null ? null : RunDashboardActionUtils.getTarget(e);
        boolean enabled = node != null && RunDashboardManager.getInstance((Project)project).isShowConfigurations() && RunManager.getInstance((Project)project).hasSettings(node.getConfigurationSettings());
        e.getPresentation().setEnabled(enabled);
        boolean popupPlace = ActionPlaces.isPopupPlace((String)e.getPlace());
        e.getPresentation().setVisible(enabled || !popupPlace);
        if (popupPlace) {
            e.getPresentation().setText(this.getTemplatePresentation().getText() + "...");
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        RunDashboardRunConfigurationNode node;
        Project project = e.getProject();
        RunDashboardRunConfigurationNode runDashboardRunConfigurationNode = node = project == null ? null : RunDashboardActionUtils.getTarget(e);
        if (node == null) {
            return;
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings settings = node.getConfigurationSettings();
        RunnerAndConfigurationSettingsImpl copiedSettings = ((RunnerAndConfigurationSettingsImpl)settings).clone();
        runManager.setUniqueNameIfNeed((RunnerAndConfigurationSettings)copiedSettings);
        copiedSettings.setFolderName(settings.getFolderName());
        copiedSettings.getConfiguration().setBeforeRunTasks(settings.getConfiguration().getBeforeRunTasks());
        ConfigurationFactory factory = settings.getFactory();
        RunConfiguration configuration2 = settings.getConfiguration();
        if (factory instanceof ConfigurationFactoryEx) {
            ((ConfigurationFactoryEx)factory).onConfigurationCopied(configuration2);
        }
        if (configuration2 instanceof RunConfigurationBase) {
            ((RunConfigurationBase)configuration2).onConfigurationCopied();
        }
        if (RunDialog.editConfiguration(project, copiedSettings, ExecutionBundle.message((String)"run.dashboard.edit.configuration.dialog.title", (Object[])new Object[0]))) {
            runManager.addConfiguration((RunnerAndConfigurationSettings)copiedSettings);
        }
    }
}

