/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.dashboard.RunDashboardContent;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ShowConfigurationsAction
extends ToggleAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        RunDashboardContent runDashboardContent = (RunDashboardContent)e.getData(RunDashboardContent.KEY);
        if (runDashboardContent == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean enabled = RunDashboardManager.getInstance((Project)project).getDashboardContentManager().getContentCount() > 0;
        e.getPresentation().setEnabled(enabled);
        if (!enabled && ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(false);
        }
        super.update(e);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return true;
        }
        return RunDashboardManager.getInstance((Project)project).isShowConfigurations();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        RunDashboardManager.getInstance((Project)project).setShowConfigurations(state);
    }
}

