/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.tree.FolderDashboardGroupingRule;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UngroupConfigurationsActions
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        JBIterable targets2 = ServiceViewActionUtils.getTargets((AnActionEvent)e, GroupingNode.class);
        boolean enabled = targets2.isNotEmpty() && targets2.filter(node -> !(node.getGroup() instanceof FolderDashboardGroupingRule.FolderDashboardGroup)).isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        for (GroupingNode node : ServiceViewActionUtils.getTargets((AnActionEvent)e, GroupingNode.class)) {
            UngroupConfigurationsActions.doActionPerformed(project, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doActionPerformed(Project project, GroupingNode node) {
        String groupName = node.getGroup().getName();
        List dashboardConfigurations = RunDashboardManager.getInstance((Project)project).getRunConfigurations();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
        runManager.fireBeginUpdate();
        try {
            for (Pair configuration2 : dashboardConfigurations) {
                if (!groupName.equals(((RunnerAndConfigurationSettings)configuration2.first).getFolderName())) continue;
                ((RunnerAndConfigurationSettings)configuration2.first).setFolderName(null);
            }
        }
        finally {
            runManager.fireEndUpdate();
        }
    }
}

