/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.tree;

import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationNode
extends AbstractTreeNode<Pair<RunnerAndConfigurationSettings, Content>>
implements RunDashboardRunConfigurationNode {
    @Nullable
    private final RunDashboardContributor myContributor;
    private final UserDataHolder myUserDataHolder = new UserDataHolderBase();

    public RunConfigurationNode(Project project, @NotNull Pair<RunnerAndConfigurationSettings, RunContentDescriptor> value, @Nullable RunDashboardContributor contributor) {
        super(project, (Object)Pair.create((Object)value.first, value.second == null ? null : ((RunContentDescriptor)value.second).getAttachedContent()));
        this.myContributor = contributor;
    }

    @NotNull
    public RunnerAndConfigurationSettings getConfigurationSettings() {
        return (RunnerAndConfigurationSettings)((Pair)this.getValue()).first;
    }

    @Nullable
    public RunContentDescriptor getDescriptor() {
        Content content = this.getContent();
        if (content == null) {
            return null;
        }
        return RunContentManagerImpl.getRunContentDescriptorByContent(content);
    }

    @Nullable
    public Content getContent() {
        return (Content)((Pair)this.getValue()).second;
    }

    protected void update(@NotNull PresentationData presentation) {
        RunnerAndConfigurationSettings configurationSettings = this.getConfigurationSettings();
        boolean isStored = RunManager.getInstance((Project)this.getProject()).hasSettings(configurationSettings);
        SimpleTextAttributes nameAttributes = isStored ? (this.getContent() != null ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES) : SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
        presentation.addText(configurationSettings.getName(), nameAttributes);
        Icon icon = null;
        RunDashboardRunConfigurationStatus status = this.getStatus();
        if (RunDashboardRunConfigurationStatus.STARTED.equals(status)) {
            icon = this.getExecutorIcon();
        } else if (RunDashboardRunConfigurationStatus.FAILED.equals(status)) {
            icon = status.getIcon();
        }
        if (icon == null) {
            icon = RunManagerEx.getInstanceEx(this.getProject()).getConfigurationIcon(configurationSettings);
        }
        presentation.setIcon(isStored ? icon : IconLoader.getDisabledIcon((Icon)icon));
        if (this.myContributor != null) {
            this.myContributor.updatePresentation(presentation, (RunDashboardNode)this);
        }
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        return Collections.emptyList();
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myUserDataHolder.putUserData(key, value);
    }

    @Nullable
    public RunDashboardContributor getContributor() {
        return this.myContributor;
    }

    @NotNull
    public RunDashboardRunConfigurationStatus getStatus() {
        return this.myContributor != null ? this.myContributor.getStatus((RunDashboardRunConfigurationNode)this) : RunDashboardRunConfigurationStatus.getStatus((RunDashboardRunConfigurationNode)this);
    }

    @Nullable
    private Icon getExecutorIcon() {
        Executor executor;
        Content content = this.getContent();
        if (content != null && !RunContentManagerImpl.isTerminated(content) && (executor = RunContentManagerImpl.getExecutorByContent(content)) != null) {
            return executor.getIcon();
        }
        return null;
    }

    public String toString() {
        return this.getConfigurationSettings().getName();
    }
}

