/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.tree;

import com.intellij.execution.dashboard.hyperlink.RunDashboardHyperlinkComponent;
import com.intellij.execution.dashboard.tree.RunDashboardLinkMouseListenerBase;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunDashboardTreeMouseListener
extends RunDashboardLinkMouseListenerBase {
    @NotNull
    private final Tree myTree;

    public RunDashboardTreeMouseListener(@NotNull Tree tree) {
        this.myTree = tree;
    }

    @Override
    protected Object getAimedObject(MouseEvent e) {
        return TreeUtil.getLastUserObject((TreePath)this.myTree.getPathForLocation(e.getX(), e.getY()));
    }

    @Override
    protected void repaintComponent(MouseEvent e) {
        ExpandableItemsHandler handler2 = this.myTree.getExpandableItemsHandler();
        if (handler2.isEnabled() && !handler2.getExpandedItems().isEmpty()) {
            this.myTree.dispatchEvent((AWTEvent)new MouseEvent((Component)e.getSource(), 504, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        }
        this.myTree.repaint();
    }

    @Override
    @Nullable
    protected RunDashboardHyperlinkComponent getTagAt(@NotNull MouseEvent e) {
        TreePath path = this.myTree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return null;
        }
        Rectangle rectangle = this.myTree.getPathBounds(path);
        if (rectangle == null) {
            return null;
        }
        int dx = e.getX() - rectangle.x;
        Object treeNode = path.getLastPathComponent();
        int row2 = this.myTree.getRowForLocation(e.getX(), e.getY());
        boolean isLeaf = this.myTree.getModel().isLeaf(treeNode);
        Object tag = null;
        Component component = this.myTree.getCellRenderer().getTreeCellRendererComponent((JTree)this.myTree, treeNode, true, false, isLeaf, row2, true);
        if (component instanceof ColoredTreeCellRenderer) {
            tag = ((ColoredTreeCellRenderer)component).getFragmentTagAt(dx);
        } else {
            component.setBounds(rectangle);
            component.doLayout();
            Point componentPoint = new Point(dx, 0);
            Component child2 = component.getComponentAt(componentPoint);
            if (child2 instanceof ColoredTreeCellRenderer) {
                Point childPoint = SwingUtilities.convertPoint(component, componentPoint, child2);
                tag = ((ColoredTreeCellRenderer)child2).getFragmentTagAt(childPoint.x);
            } else if (child2 instanceof JLabel) {
                tag = ((JLabel)child2).getIcon();
            }
        }
        if (tag instanceof RunDashboardHyperlinkComponent) {
            return (RunDashboardHyperlinkComponent)tag;
        }
        return null;
    }
}

