/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public abstract class AbstractFileHyperlinkFilter
implements Filter {
    private static final Logger LOG = Logger.getInstance(AbstractFileHyperlinkFilter.class);
    private final Project myProject;
    private final ProjectFileIndex myFileIndex;
    private final VirtualFile myBaseDir;

    public AbstractFileHyperlinkFilter(@NotNull Project project, @Nullable String baseDir) {
        this(project, AbstractFileHyperlinkFilter.findDir(baseDir));
    }

    public AbstractFileHyperlinkFilter(@NotNull Project project, @Nullable VirtualFile baseDir) {
        this.myProject = project;
        this.myFileIndex = ProjectFileIndex.getInstance((Project)project);
        this.myBaseDir = baseDir;
    }

    @Nullable
    protected static VirtualFile findDir(@Nullable String baseDir) {
        if (StringUtil.isEmpty((String)baseDir)) {
            return null;
        }
        return (VirtualFile)ReadAction.compute(() -> {
            VirtualFile dir = LocalFileFinder.findFile(baseDir);
            return dir != null && dir.isValid() && dir.isDirectory() ? dir : null;
        });
    }

    protected boolean supportVfsRefresh() {
        return false;
    }

    @Nullable
    public final Filter.Result applyFilter(@NotNull String line, int entireLength) {
        List<FileHyperlinkRawData> links;
        try {
            links = this.parse(line);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to parse '" + line + "' with " + this.getClass(), (Throwable)e);
            return null;
        }
        ArrayList items = ContainerUtil.newArrayList();
        for (FileHyperlinkRawData link2 : links) {
            File ioFile;
            String filePath = FileUtil.toSystemIndependentName((String)link2.getFilePath());
            if (StringUtil.isEmptyOrSpaces((String)filePath)) continue;
            VirtualFile file2 = this.findFile(filePath);
            Object info = null;
            boolean grayedHyperLink = false;
            if (file2 != null) {
                info = new OpenFileHyperlinkInfo(this.myProject, file2, link2.getDocumentLine(), link2.getDocumentColumn());
                grayedHyperLink = this.isGrayedHyperlink(file2);
            } else if (this.supportVfsRefresh() && (ioFile = this.findIoFile(filePath)) != null) {
                info = new MyFileHyperlinkInfo(ioFile, link2.getDocumentLine(), link2.getDocumentColumn());
            }
            if (info == null) continue;
            int offset = entireLength - line.length();
            items.add(new Filter.ResultItem(offset + link2.getHyperlinkStartInd(), offset + link2.getHyperlinkEndInd(), (HyperlinkInfo)info, grayedHyperLink));
        }
        return items.isEmpty() ? null : new Filter.Result((List)items);
    }

    @Nullable
    private File findIoFile(@NotNull String filePath) {
        File ioFile = new File(filePath);
        if (ioFile.isAbsolute() && ioFile.isFile()) {
            return ioFile;
        }
        if (this.myBaseDir != null && (ioFile = new File(this.myBaseDir.getPath(), filePath)).isFile()) {
            return ioFile;
        }
        return null;
    }

    private boolean isGrayedHyperlink(@NotNull VirtualFile file2) {
        return !this.myFileIndex.isInContent(file2) || this.myFileIndex.isInLibrary(file2);
    }

    @NotNull
    public abstract List<FileHyperlinkRawData> parse(@NotNull String var1);

    @Nullable
    public VirtualFile findFile(@NotNull String filePath) {
        VirtualFile file2 = LocalFileFinder.findFile(filePath);
        if (file2 == null && this.myBaseDir != null && this.myBaseDir.isValid()) {
            file2 = this.myBaseDir.findFileByRelativePath(filePath);
        }
        return file2;
    }

    private static class MyFileHyperlinkInfo
    implements HyperlinkInfo {
        private final File myIoFile;
        private final int myDocumentLine;
        private final int myDocumentColumn;
        private Ref<VirtualFile> myFileRef;

        MyFileHyperlinkInfo(@NotNull File ioFile, int documentLine, int documentColumn) {
            this.myIoFile = ioFile;
            this.myDocumentLine = documentLine;
            this.myDocumentColumn = documentColumn;
        }

        public void navigate(Project project) {
            Ref fileRef = this.myFileRef;
            if (fileRef == null) {
                VirtualFile file2 = (VirtualFile)WriteAction.compute(() -> VfsUtil.findFileByIoFile((File)this.myIoFile, (boolean)true));
                this.myFileRef = fileRef = Ref.create((Object)file2);
            }
            if (fileRef.get() != null) {
                OpenFileHyperlinkInfo linkInfo = new OpenFileHyperlinkInfo(project, (VirtualFile)fileRef.get(), this.myDocumentLine, this.myDocumentColumn);
                linkInfo.navigate(project);
            }
        }
    }
}

