/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.FileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternHyperlinkFormat;
import com.intellij.execution.filters.PatternHyperlinkPart;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternBasedFileHyperlinkRawDataFinder
implements FileHyperlinkRawDataFinder {
    private static final int UNKNOWN = -2;
    private final PatternHyperlinkFormat[] myLinkFormats;

    public PatternBasedFileHyperlinkRawDataFinder(@NotNull PatternHyperlinkFormat[] linkFormats) {
        this.myLinkFormats = linkFormats;
    }

    @Override
    @NotNull
    public List<FileHyperlinkRawData> find(@NotNull String line) {
        Pair<Matcher, PatternHyperlinkFormat> pair = this.findMatcher(line);
        if (pair == null) {
            return Collections.emptyList();
        }
        Matcher matcher = (Matcher)pair.first;
        PatternHyperlinkFormat format = (PatternHyperlinkFormat)pair.second;
        PatternHyperlinkPart[] linkParts = format.getLinkParts();
        int groupCount = matcher.groupCount();
        if (groupCount > linkParts.length) {
            return Collections.emptyList();
        }
        String path = null;
        int lineNumber = -1;
        int columnNumber = -1;
        int hyperlinkStartInd = -1;
        int hyperlinkEndInd = -1;
        boolean hyperlinkFreezed = false;
        for (int i = 1; i <= groupCount; ++i) {
            String value = matcher.group(i);
            if (value == null) continue;
            PatternHyperlinkPart part = linkParts[i - 1];
            if (part == PatternHyperlinkPart.HYPERLINK) {
                hyperlinkStartInd = matcher.start(i);
                hyperlinkEndInd = matcher.end(i);
                hyperlinkFreezed = true;
                continue;
            }
            if (part == PatternHyperlinkPart.PATH) {
                path = value;
                if (hyperlinkFreezed) continue;
                hyperlinkStartInd = matcher.start(i);
                hyperlinkEndInd = matcher.end(i);
                continue;
            }
            if (part == PatternHyperlinkPart.LINE) {
                value = StringUtil.trimStart((String)value, (String)":");
                lineNumber = StringUtil.parseInt((String)value, (int)-2);
                hyperlinkEndInd = PatternBasedFileHyperlinkRawDataFinder.tryExtendHyperlinkEnd(hyperlinkFreezed, hyperlinkEndInd, matcher.start(i), matcher.end(i));
                continue;
            }
            if (part != PatternHyperlinkPart.COLUMN || (columnNumber = StringUtil.parseInt((String)(value = StringUtil.trimStart((String)value, (String)":")), (int)-2)) == -2) continue;
            hyperlinkEndInd = PatternBasedFileHyperlinkRawDataFinder.tryExtendHyperlinkEnd(hyperlinkFreezed, hyperlinkEndInd, matcher.start(i), matcher.end(i));
        }
        if (path == null || lineNumber == -2 || columnNumber == -2 || hyperlinkStartInd == -1) {
            return Collections.emptyList();
        }
        if (!format.isZeroBasedLineNumbering()) {
            --lineNumber;
        }
        if (!format.isZeroBasedColumnNumbering()) {
            --columnNumber;
        }
        lineNumber = Math.max(lineNumber, -1);
        columnNumber = Math.max(columnNumber, -1);
        FileHyperlinkRawData data = new FileHyperlinkRawData(path, lineNumber, columnNumber, hyperlinkStartInd, hyperlinkEndInd);
        return Collections.singletonList(data);
    }

    private static int tryExtendHyperlinkEnd(boolean hyperlinkFreezed, int hyperlinkEndInd, int groupStartInd, int groupEndInd) {
        if (!(hyperlinkFreezed || hyperlinkEndInd != groupStartInd && hyperlinkEndInd + 1 != groupStartInd)) {
            return groupEndInd;
        }
        return hyperlinkEndInd;
    }

    @Nullable
    private Pair<Matcher, PatternHyperlinkFormat> findMatcher(@NotNull String line) {
        for (PatternHyperlinkFormat linkFormat : this.myLinkFormats) {
            Matcher matcher = linkFormat.getPattern().matcher(line);
            if (!matcher.find()) continue;
            return Pair.create((Object)matcher, (Object)linkFormat);
        }
        return null;
    }
}

