/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters.impl;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import javax.swing.JFrame;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultipleFilesHyperlinkInfo
extends HyperlinkInfoBase
implements FileHyperlinkInfo {
    private final List<? extends VirtualFile> myVirtualFiles;
    private final int myLineNumber;
    private final Project myProject;
    private final ToIntFunction<? super PsiFile> myColumnFinder;

    MultipleFilesHyperlinkInfo(@NotNull List<? extends VirtualFile> virtualFiles, int lineNumber, @NotNull Project project) {
        this(virtualFiles, lineNumber, project, null);
    }

    MultipleFilesHyperlinkInfo(@NotNull List<? extends VirtualFile> virtualFiles, int lineNumber, @NotNull Project project, @Nullable ToIntFunction<? super PsiFile> columnFinder) {
        this.myVirtualFiles = virtualFiles;
        this.myLineNumber = lineNumber;
        this.myProject = project;
        this.myColumnFinder = columnFinder == null ? f -> 0 : columnFinder;
    }

    public void navigate(@NotNull Project project, @Nullable RelativePoint hyperlinkLocationPoint) {
        ArrayList currentFiles = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            for (VirtualFile virtualFile : this.myVirtualFiles) {
                PsiFile psiFile;
                if (!virtualFile.isValid() || (psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) == null) continue;
                PsiElement navigationElement = psiFile.getNavigationElement();
                if (navigationElement instanceof PsiFile) {
                    currentFiles.add((PsiFile)navigationElement);
                    continue;
                }
                currentFiles.add(psiFile);
            }
        });
        if (currentFiles.isEmpty()) {
            return;
        }
        if (currentFiles.size() == 1) {
            PsiFile file2 = (PsiFile)currentFiles.get(0);
            new OpenFileHyperlinkInfo(this.myProject, file2.getVirtualFile(), this.myLineNumber, this.myColumnFinder.applyAsInt((PsiFile)file2)).navigate(project);
        } else {
            JFrame frame = WindowManager.getInstance().getFrame(project);
            int width = frame != null ? frame.getSize().width : 200;
            JBPopup popup2 = JBPopupFactory.getInstance().createPopupChooserBuilder(currentFiles).setRenderer((ListCellRenderer)new GotoFileCellRenderer(width)).setTitle("Choose Target File").setItemChosenCallback(selectedValue -> {
                VirtualFile file2 = selectedValue.getVirtualFile();
                new OpenFileHyperlinkInfo(this.myProject, file2, this.myLineNumber, this.myColumnFinder.applyAsInt((PsiFile)selectedValue)).navigate(project);
            }).createPopup();
            if (hyperlinkLocationPoint != null) {
                popup2.show(hyperlinkLocationPoint);
            } else {
                popup2.showInFocusCenter();
            }
        }
    }

    @Nullable
    public OpenFileDescriptor getDescriptor() {
        VirtualFile file2 = this.getPreferredFile();
        return file2 != null ? new OpenFileDescriptor(this.myProject, file2, this.myLineNumber, 0) : null;
    }

    @Nullable
    private VirtualFile getPreferredFile() {
        return (VirtualFile)ContainerUtil.getFirstItem(this.myVirtualFiles);
    }
}

