/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.impl.BeforeRunTaskAndProvider;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BeforeRunStepsPanel
extends JPanel {
    private final JCheckBox myShowSettingsBeforeRunCheckBox;
    private final JCheckBox myActivateToolWindowBeforeRunCheckBox;
    private final JBList<BeforeRunTask<?>> myList;
    private final CollectionListModel<BeforeRunTask<?>> myModel;
    private RunConfiguration myRunConfiguration;
    private final List<BeforeRunTask<?>> originalTasks = new SmartList();
    private final StepsBeforeRunListener myListener;
    private final JPanel myPanel;
    private final Set<BeforeRunTask<?>> clonedTasks = new THashSet();

    BeforeRunStepsPanel(@NotNull StepsBeforeRunListener listener2) {
        this.myListener = listener2;
        this.myModel = new CollectionListModel((Object[])new BeforeRunTask[0]);
        this.myList = new JBList(this.myModel);
        this.myList.getEmptyText().setText(ExecutionBundle.message((String)"before.launch.panel.empty", (Object[])new Object[0]));
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
        this.myList.setVisibleRowCount(4);
        this.myModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                BeforeRunStepsPanel.this.updateText();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                BeforeRunStepsPanel.this.updateText();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
        ToolbarDecorator myDecorator = ToolbarDecorator.createDecorator(this.myList);
        if (!SystemInfo.isMac) {
            myDecorator.setAsUsualTopToolbar();
        }
        myDecorator.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                BeforeRunTaskAndProvider selection = BeforeRunStepsPanel.this.getSelection();
                if (selection == null) {
                    return;
                }
                BeforeRunTask task2 = selection.getTask();
                if (!BeforeRunStepsPanel.this.clonedTasks.contains(task2)) {
                    task2 = task2.clone();
                    BeforeRunStepsPanel.this.clonedTasks.add(task2);
                    BeforeRunStepsPanel.this.myModel.setElementAt((Object)task2, selection.getIndex());
                }
                selection.getProvider().configureTask(button2.getDataContext(), BeforeRunStepsPanel.this.myRunConfiguration, task2).onSuccess(changed -> {
                    if (changed.booleanValue()) {
                        BeforeRunStepsPanel.this.updateText();
                    }
                });
            }
        });
        myDecorator.setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                BeforeRunTaskAndProvider selection = BeforeRunStepsPanel.this.getSelection();
                return selection != null && selection.getProvider().isConfigurable();
            }
        });
        myDecorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                BeforeRunStepsPanel.this.doAddAction(button2);
            }
        });
        myDecorator.setAddActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                return BeforeRunStepsPanel.this.checkBeforeRunTasksAbility(true);
            }
        });
        this.myShowSettingsBeforeRunCheckBox = new JCheckBox(ExecutionBundle.message((String)"configuration.edit.before.run", (Object[])new Object[0]));
        this.myShowSettingsBeforeRunCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeforeRunStepsPanel.this.updateText();
            }
        });
        this.myActivateToolWindowBeforeRunCheckBox = new JCheckBox(ExecutionBundle.message((String)"configuration.activate.toolwindow.before.run", (Object[])new Object[0]));
        this.myActivateToolWindowBeforeRunCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeforeRunStepsPanel.this.updateText();
            }
        });
        this.myPanel = myDecorator.createPanel();
        myDecorator.getActionsPanel().setCustomShortcuts(CommonActionsPanel.Buttons.EDIT, new ShortcutSet[]{CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.EDIT), CommonShortcuts.DOUBLE_CLICK_1});
        this.setLayout(new BorderLayout());
        this.add((Component)this.myPanel, "Center");
        JPanel checkboxPanel = new JPanel(new FlowLayout(3, JBUI.scale((int)5), JBUI.scale((int)5)));
        checkboxPanel.add(this.myShowSettingsBeforeRunCheckBox);
        checkboxPanel.add(this.myActivateToolWindowBeforeRunCheckBox);
        this.add((Component)checkboxPanel, "South");
    }

    @Nullable
    private BeforeRunTaskAndProvider getSelection() {
        int index = this.myList.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        BeforeRunTask task2 = (BeforeRunTask)this.myModel.getElementAt(index);
        BeforeRunTaskProvider provider = BeforeRunTaskProvider.getProvider((Project)this.myRunConfiguration.getProject(), (Key)task2.getProviderId());
        return provider == null ? null : new BeforeRunTaskAndProvider(task2, provider, index);
    }

    void doReset(@NotNull RunnerAndConfigurationSettings settings) {
        this.clonedTasks.clear();
        this.myRunConfiguration = settings.getConfiguration();
        this.originalTasks.clear();
        this.originalTasks.addAll(RunManagerImplKt.doGetBeforeRunTasks(this.myRunConfiguration));
        this.myModel.replaceAll(this.originalTasks);
        this.myShowSettingsBeforeRunCheckBox.setSelected(settings.isEditBeforeRun());
        this.myShowSettingsBeforeRunCheckBox.setEnabled(!this.isUnknown());
        this.myActivateToolWindowBeforeRunCheckBox.setSelected(settings.isActivateToolWindowBeforeRun());
        this.myActivateToolWindowBeforeRunCheckBox.setEnabled(!this.isUnknown());
        this.myPanel.setVisible(this.checkBeforeRunTasksAbility(false));
        this.updateText();
    }

    private void updateText() {
        List tasks;
        StringBuilder sb = new StringBuilder();
        if (this.myShowSettingsBeforeRunCheckBox.isSelected()) {
            sb.append(ExecutionBundle.message((String)"configuration.edit.before.run", (Object[])new Object[0]));
        }
        if (!(tasks = this.myModel.getItems()).isEmpty()) {
            BeforeRunTaskProvider provider;
            LinkedHashMap<BeforeRunTaskProvider, Integer> counter = new LinkedHashMap<BeforeRunTaskProvider, Integer>();
            for (BeforeRunTask beforeRunTask : tasks) {
                provider = BeforeRunTaskProvider.getProvider((Project)this.myRunConfiguration.getProject(), (Key)beforeRunTask.getProviderId());
                if (provider == null) continue;
                Integer count = (Integer)counter.get(provider);
                count = count == null ? Integer.valueOf(beforeRunTask.getItemsCount()) : Integer.valueOf(count + beforeRunTask.getItemsCount());
                counter.put(provider, count);
            }
            for (Map.Entry entry : counter.entrySet()) {
                provider = (BeforeRunTaskProvider)entry.getKey();
                String name = provider.getName();
                name = StringUtil.trimStart((String)name, (String)"Run ");
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(name);
                if ((Integer)entry.getValue() <= 1) continue;
                sb.append(" (").append((Integer)entry.getValue()).append(")");
            }
        }
        if (this.myActivateToolWindowBeforeRunCheckBox.isSelected()) {
            sb.append(sb.length() > 0 ? ", " : "").append(ExecutionBundle.message((String)"configuration.activate.toolwindow.before.run", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            sb.insert(0, ": ");
        }
        sb.insert(0, ExecutionBundle.message((String)"before.launch.panel.title", (Object[])new Object[0]));
        this.myListener.titleChanged(sb.toString());
    }

    @NotNull
    public List<BeforeRunTask<?>> getTasks() {
        List items = this.myModel.getItems();
        return items.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(items);
    }

    public boolean needEditBeforeRun() {
        return this.myShowSettingsBeforeRunCheckBox.isSelected();
    }

    public boolean needActivateToolWindowBeforeRun() {
        return this.myActivateToolWindowBeforeRunCheckBox.isSelected();
    }

    private boolean checkBeforeRunTasksAbility(boolean checkOnlyAddAction) {
        if (this.isUnknown()) {
            return false;
        }
        Set<Key> activeProviderKeys = this.getActiveProviderKeys();
        for (BeforeRunTaskProvider<BeforeRunTask> provider : this.getBeforeRunTaskProviders()) {
            if (provider.createTask(this.myRunConfiguration) == null) continue;
            if (!checkOnlyAddAction) {
                return true;
            }
            if (provider.isSingleton() && activeProviderKeys.contains(provider.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isUnknown() {
        return this.myRunConfiguration instanceof UnknownRunConfiguration;
    }

    private void doAddAction(final @NotNull AnActionButton button2) {
        if (this.isUnknown()) {
            return;
        }
        Set<Key> activeProviderKeys = this.getActiveProviderKeys();
        DefaultActionGroup actionGroup = new DefaultActionGroup(null, false);
        for (final BeforeRunTaskProvider<BeforeRunTask> provider : this.getBeforeRunTaskProviders()) {
            if (provider.createTask(this.myRunConfiguration) == null || activeProviderKeys.contains(provider.getId()) && provider.isSingleton()) continue;
            actionGroup.add(new AnAction(provider.getName(), null, provider.getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    BeforeRunTask task2 = provider.createTask(BeforeRunStepsPanel.this.myRunConfiguration);
                    if (task2 == null) {
                        return;
                    }
                    provider.configureTask(button2.getDataContext(), BeforeRunStepsPanel.this.myRunConfiguration, task2).onSuccess(changed -> {
                        if (!provider.canExecuteTask(BeforeRunStepsPanel.this.myRunConfiguration, task2)) {
                            return;
                        }
                        task2.setEnabled(true);
                        THashSet configurationSet = new THashSet();
                        BeforeRunStepsPanel.this.getAllRunBeforeRuns(task2, (Set)configurationSet);
                        if (configurationSet.contains(BeforeRunStepsPanel.this.myRunConfiguration)) {
                            JOptionPane.showMessageDialog(BeforeRunStepsPanel.this, ExecutionBundle.message((String)"before.launch.panel.cyclic_dependency_warning", (Object[])new Object[]{BeforeRunStepsPanel.this.myRunConfiguration.getName(), provider.getDescription(task2)}), ExecutionBundle.message((String)"warning.common.title", (Object[])new Object[0]), 2);
                            return;
                        }
                        BeforeRunStepsPanel.this.addTask(task2);
                        BeforeRunStepsPanel.this.myListener.fireStepsBeforeRunChanged();
                    });
                }
            });
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(ExecutionBundle.message((String)"add.new.run.configuration.action2.name", (Object[])new Object[0]), (ActionGroup)actionGroup, SimpleDataContext.getProjectContext(this.myRunConfiguration.getProject()), false, false, false, null, -1, Conditions.alwaysTrue());
        popup2.show(Objects.requireNonNull(button2.getPreferredPopupPoint()));
    }

    @NotNull
    private List<BeforeRunTaskProvider<BeforeRunTask>> getBeforeRunTaskProviders() {
        return BeforeRunTaskProvider.EXTENSION_POINT_NAME.getExtensionList((AreaInstance)this.myRunConfiguration.getProject());
    }

    public void addTask(@NotNull BeforeRunTask task2) {
        this.myModel.add((Object)task2);
    }

    @NotNull
    private Set<Key> getActiveProviderKeys() {
        THashSet result2 = new THashSet();
        for (BeforeRunTask task2 : this.myModel.getItems()) {
            result2.add(task2.getProviderId());
        }
        return result2;
    }

    private void getAllRunBeforeRuns(@NotNull BeforeRunTask task2, @NotNull Set<RunConfiguration> configurationSet) {
        if (task2 instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask) {
            RunConfiguration configuration2 = Objects.requireNonNull(((RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)task2).getSettings()).getConfiguration();
            for (BeforeRunTask<?> beforeRunTask : RunManagerImplKt.doGetBeforeRunTasks(configuration2)) {
                if (!(beforeRunTask instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask) || !configurationSet.add(Objects.requireNonNull(((RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)beforeRunTask).getSettings()).getConfiguration())) continue;
                this.getAllRunBeforeRuns(beforeRunTask, configurationSet);
            }
        }
    }

    private class MyListCellRenderer
    extends JBList.StripedListCellRenderer {
        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
            if (value instanceof BeforeRunTask) {
                BeforeRunTask task2 = (BeforeRunTask)value;
                BeforeRunTaskProvider provider = BeforeRunTaskProvider.getProvider((Project)BeforeRunStepsPanel.this.myRunConfiguration.getProject(), (Key)task2.getProviderId());
                if (provider != null) {
                    Icon icon = provider.getTaskIcon(task2);
                    this.setIcon(icon != null ? icon : provider.getIcon());
                    this.setText(provider.getDescription(task2));
                }
            }
            return this;
        }
    }

    static interface StepsBeforeRunListener {
        public void fireStepsBeforeRunChanged();

        public void titleChanged(@NotNull String var1);
    }
}

