/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.impl.CheckableRunConfigurationEditor;
import com.intellij.execution.impl.RunConfigurationSettingsEditor;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.AdjustingTabSettingsEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.CompositeSettingsBuilder;
import com.intellij.openapi.options.CompositeSettingsEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.GroupSettingsBuilder;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.options.SettingsEditorWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationSettingsEditor
extends CompositeSettingsEditor<RunnerAndConfigurationSettings> {
    private final ArrayList<SettingsEditor<RunnerAndConfigurationSettings>> myRunnerEditors = new ArrayList();
    private final Map<ProgramRunner, List<SettingsEditor>> myRunner2UnwrappedEditors = new HashMap<ProgramRunner, List<SettingsEditor>>();
    private RunnersEditorComponent myRunnersComponent;
    private final RunConfiguration myConfiguration;
    private final SettingsEditor<RunConfiguration> myConfigurationEditor;
    private SettingsEditorGroup<RunnerAndConfigurationSettings> myCompound;
    private static final String RUNNERS_TAB_NAME = ExecutionBundle.message((String)"run.configuration.startup.connection.rab.title", (Object[])new Object[0]);
    private GroupSettingsBuilder<RunnerAndConfigurationSettings> myGroupSettingsBuilder;

    public CompositeSettingsBuilder<RunnerAndConfigurationSettings> getBuilder() {
        this.init();
        this.myGroupSettingsBuilder = new GroupSettingsBuilder(this.myCompound);
        return this.myGroupSettingsBuilder;
    }

    private void init() {
        if (this.myCompound == null) {
            this.myCompound = new SettingsEditorGroup();
            Disposer.register((Disposable)this, this.myCompound);
            if (this.myConfigurationEditor instanceof SettingsEditorGroup) {
                SettingsEditorGroup group = (SettingsEditorGroup)this.myConfigurationEditor;
                List editors = group.getEditors();
                for (Pair pair : editors) {
                    this.myCompound.addEditor((String)pair.getFirst(), (SettingsEditor)new ConfigToSettingsWrapper((SettingsEditor<RunConfiguration>)((SettingsEditor)pair.getSecond())));
                }
            } else {
                this.myCompound.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new ConfigToSettingsWrapper(this.myConfigurationEditor));
            }
            this.myRunnersComponent = new RunnersEditorComponent();
            for (Executor executor : ExecutorRegistry.getInstance().getRegisteredExecutors()) {
                JComponent perRunnerSettings;
                ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)this.myConfiguration);
                if (runner == null || (perRunnerSettings = this.createCompositePerRunnerSettings(executor, (ProgramRunner<RunnerSettings>)runner)) == null) continue;
                this.myRunnersComponent.addExecutorComponent(executor, perRunnerSettings);
            }
            if (this.myRunnerEditors.size() > 0) {
                this.myCompound.addEditor(RUNNERS_TAB_NAME, (SettingsEditor)new CompositeSettingsEditor<RunnerAndConfigurationSettings>(this.getFactory()){

                    public CompositeSettingsBuilder<RunnerAndConfigurationSettings> getBuilder() {
                        return new CompositeSettingsBuilder<RunnerAndConfigurationSettings>(){

                            public Collection<SettingsEditor<RunnerAndConfigurationSettings>> getEditors() {
                                return ConfigurationSettingsEditor.this.myRunnerEditors;
                            }

                            public JComponent createCompoundEditor() {
                                return ConfigurationSettingsEditor.this.myRunnersComponent.getComponent();
                            }
                        };
                    }
                });
            }
        }
    }

    @Nullable
    private JComponent createCompositePerRunnerSettings(@NotNull Executor executor, @NotNull ProgramRunner<RunnerSettings> runner) {
        SettingsEditor runnerEditor;
        SettingsEditor configEditor = this.myConfiguration.getRunnerSettingsEditor(runner);
        try {
            runnerEditor = runner.getSettingsEditor(executor, this.myConfiguration);
        }
        catch (AbstractMethodError error) {
            runnerEditor = null;
        }
        if (configEditor == null && runnerEditor == null) {
            return null;
        }
        SettingsEditor<RunnerAndConfigurationSettings> wrappedConfigEditor = null;
        SettingsEditor<RunnerAndConfigurationSettings> wrappedRunEditor = null;
        if (configEditor != null) {
            wrappedConfigEditor = this.wrapEditor(configEditor, configurationSettings -> configurationSettings.getConfigurationSettings(runner), runner);
        }
        if (runnerEditor != null) {
            wrappedRunEditor = this.wrapEditor(runnerEditor, configurationSettings -> configurationSettings.getRunnerSettings(runner), runner);
        }
        if (wrappedRunEditor != null && wrappedConfigEditor != null) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)wrappedConfigEditor.getComponent(), "Center");
            JComponent wrappedRunEditorComponent = wrappedRunEditor.getComponent();
            wrappedRunEditorComponent.setBorder((Border)JBUI.Borders.emptyTop((int)3));
            panel2.add((Component)wrappedRunEditorComponent, "South");
            return panel2;
        }
        return wrappedRunEditor == null ? Objects.requireNonNull(wrappedConfigEditor).getComponent() : wrappedRunEditor.getComponent();
    }

    private <T> SettingsEditor<RunnerAndConfigurationSettings> wrapEditor(SettingsEditor<T> editor, Convertor<RunnerAndConfigurationSettings, T> convertor, ProgramRunner runner) {
        SettingsEditorWrapper wrappedEditor = new SettingsEditorWrapper(editor, convertor);
        List<SettingsEditor> unwrappedEditors = this.myRunner2UnwrappedEditors.get(runner);
        if (unwrappedEditors == null) {
            unwrappedEditors = new ArrayList<SettingsEditor>();
            this.myRunner2UnwrappedEditors.put(runner, unwrappedEditors);
        }
        unwrappedEditors.add(editor);
        this.myRunnerEditors.add((SettingsEditor<RunnerAndConfigurationSettings>)wrappedEditor);
        Disposer.register((Disposable)this, (Disposable)wrappedEditor);
        return wrappedEditor;
    }

    public <T extends SettingsEditor> T selectExecutorAndGetEditor(ProgramRunner runner, Class<T> editorClass) {
        this.myGroupSettingsBuilder.selectEditor(RUNNERS_TAB_NAME);
        Executor executor = (Executor)ContainerUtil.find(this.myRunnersComponent.getExecutors(), executor1 -> runner.equals(ProgramRunner.getRunner((String)executor1.getId(), (RunProfile)this.myConfiguration)));
        if (executor == null) {
            return null;
        }
        this.myRunnersComponent.selectExecutor(executor);
        return (T)((SettingsEditor)ContainerUtil.findInstance((Iterable)this.myRunner2UnwrappedEditors.get(runner), editorClass));
    }

    public <T extends SettingsEditor> T selectTabAndGetEditor(Class<T> editorClass) {
        for (Pair name2editor : this.myCompound.getEditors()) {
            SettingsEditor<RunConfiguration> configEditor;
            SettingsEditor editor = (SettingsEditor)name2editor.getSecond();
            if (!(editor instanceof ConfigToSettingsWrapper) || !editorClass.isInstance(configEditor = ((ConfigToSettingsWrapper)editor).getConfigEditor())) continue;
            this.myGroupSettingsBuilder.selectEditor((String)name2editor.getFirst());
            return (T)((SettingsEditor)editorClass.cast(configEditor));
        }
        return null;
    }

    public ConfigurationSettingsEditor(@NotNull RunnerAndConfigurationSettings settings) {
        super(settings.createFactory());
        this.myConfigurationEditor = settings.getConfiguration().getConfigurationEditor();
        Disposer.register((Disposable)this, this.myConfigurationEditor);
        this.myConfiguration = settings.getConfiguration();
    }

    @NotNull
    public RunnerAndConfigurationSettings getSnapshot() throws ConfigurationException {
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)this.getFactory().create();
        settings.setName(this.myConfiguration.getName());
        if (this.myConfigurationEditor instanceof CheckableRunConfigurationEditor) {
            ((CheckableRunConfigurationEditor)this.myConfigurationEditor).checkEditorData((Object)settings.getConfiguration());
        } else {
            this.applyTo(settings);
        }
        return settings;
    }

    private class ConfigToSettingsWrapper
    extends SettingsEditor<RunnerAndConfigurationSettings> {
        private final SettingsEditor<RunConfiguration> myConfigEditor;

        ConfigToSettingsWrapper(SettingsEditor<RunConfiguration> configEditor) {
            this.myConfigEditor = configEditor;
            if (configEditor instanceof RunConfigurationSettingsEditor) {
                ((RunConfigurationSettingsEditor)configEditor).setOwner((SettingsEditor<RunnerAndConfigurationSettings>)ConfigurationSettingsEditor.this);
            }
        }

        public SettingsEditor<RunConfiguration> getConfigEditor() {
            return this.myConfigEditor;
        }

        public void resetEditorFrom(@NotNull RunnerAndConfigurationSettings configurationSettings) {
            this.myConfigEditor.resetFrom((Object)configurationSettings.getConfiguration());
        }

        public void applyEditorTo(@NotNull RunnerAndConfigurationSettings configurationSettings) throws ConfigurationException {
            this.myConfigEditor.applyTo((Object)configurationSettings.getConfiguration());
        }

        @NotNull
        public JComponent createEditor() {
            final JComponent component = this.myConfigEditor.getComponent();
            if (this.myConfigEditor instanceof AdjustingTabSettingsEditor) {
                final JPanel panel2 = new JPanel(new BorderLayout());
                UiNotifyConnector connector = new UiNotifyConnector((Component)panel2, new Activatable(){
                    private boolean myIsEmpty = true;

                    public void showNotify() {
                        if (this.myIsEmpty) {
                            panel2.add((Component)component, "Center");
                            panel2.revalidate();
                            panel2.repaint();
                            this.myIsEmpty = false;
                        }
                    }

                    public void hideNotify() {
                        if (!this.myIsEmpty) {
                            panel2.removeAll();
                            panel2.revalidate();
                            panel2.repaint();
                            this.myIsEmpty = true;
                        }
                    }
                });
                Disposer.register((Disposable)this, (Disposable)connector);
                return panel2;
            }
            return component;
        }

        public void disposeEditor() {
            Disposer.dispose(this.myConfigEditor);
        }
    }

    private static final class RunnersEditorComponent {
        @NonNls
        private static final String NO_RUNNER_COMPONENT = "<NO RUNNER LABEL>";
        private JList<Executor> myRunnersList;
        private JPanel myRunnerPanel;
        private final CardLayout myLayout;
        private final DefaultListModel<Executor> myListModel;
        private final JLabel myNoRunner;
        private JPanel myRunnersPanel;
        private JBScrollPane myScrollPane;

        RunnersEditorComponent() {
            this.$$$setupUI$$$();
            this.myLayout = new CardLayout();
            this.myListModel = new DefaultListModel();
            this.myNoRunner = new JLabel(ExecutionBundle.message((String)"run.configuration.norunner.selected.label", (Object[])new Object[0]));
            this.myRunnerPanel.setLayout(this.myLayout);
            this.myRunnerPanel.add((Component)this.myNoRunner, NO_RUNNER_COMPONENT);
            this.myRunnersList.setModel(this.myListModel);
            this.myRunnersList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    this.updateRunnerComponent();
                }
            });
            this.updateRunnerComponent();
            this.myRunnersList.setCellRenderer((ListCellRenderer<Executor>)new ColoredListCellRenderer<Executor>(){

                protected void customizeCellRenderer(@NotNull JList<? extends Executor> list2, Executor value, int index, boolean selected, boolean hasFocus) {
                    this.setIcon(value.getIcon());
                    this.append(value.getId(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            });
            this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
            this.myScrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        }

        private void updateRunnerComponent() {
            Executor executor = this.myRunnersList.getSelectedValue();
            this.myLayout.show(this.myRunnerPanel, executor != null ? executor.getId() : NO_RUNNER_COMPONENT);
            this.myRunnersPanel.revalidate();
        }

        public void addExecutorComponent(Executor executor, JComponent component) {
            this.myRunnerPanel.add((Component)component, executor.getId());
            this.myListModel.addElement(executor);
            ScrollingUtil.ensureSelectionExists(this.myRunnersList);
        }

        public List<Executor> getExecutors() {
            return Collections.list(this.myListModel.elements());
        }

        public void selectExecutor(Executor executor) {
            this.myRunnersList.setSelectedValue(executor, true);
        }

        public JComponent getComponent() {
            return this.myRunnersPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            JBList jBList;
            JBScrollPane jBScrollPane;
            JPanel jPanel2;
            this.myRunnersPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myScrollPane = jBScrollPane = new JBScrollPane();
            jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 50), null, 1));
            this.myRunnersList = jBList = new JBList();
            jBList.setSelectionMode(0);
            jBScrollPane.setViewportView((Component)jBList);
            this.myRunnerPanel = jPanel = new JPanel();
            jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myRunnersPanel;
        }
    }
}

