/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.execution.impl.RunConfigurableKt;
import com.intellij.execution.impl.RunDialogBase;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditConfigurationsDialog
extends SingleConfigurableEditor
implements RunDialogBase {
    protected Executor myExecutor;

    public EditConfigurationsDialog(@NotNull Project project) {
        this(project, (ConfigurationFactory)null);
    }

    public EditConfigurationsDialog(@NotNull Project project, @Nullable ConfigurationFactory factory) {
        super(project, (Configurable)RunConfigurableKt.createRunConfigurationConfigurable(project).selectConfigurableOnShow(factory == null), "#com.intellij.execution.impl.EditConfigurationsDialog", DialogWrapper.IdeModalityType.IDE);
        ((RunConfigurable)this.getConfigurable()).setRunDialog(this);
        this.setTitle(ExecutionBundle.message((String)"run.debug.dialog.title", (Object[])new Object[0]));
        this.setHorizontalStretch(1.3f);
        if (factory != null) {
            this.addRunConfiguration(factory);
        }
    }

    private void addRunConfiguration(@NotNull ConfigurationFactory factory) {
        final RunConfigurable configurable = (RunConfigurable)this.getConfigurable();
        final SingleConfigurationConfigurable<RunConfiguration> configuration2 = configurable.createNewConfiguration(factory);
        if (!this.isVisible()) {
            this.getContentPanel().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    configurable.updateRightPanel((Configurable)configuration2);
                    EditConfigurationsDialog.this.getContentPanel().removeComponentListener(this);
                }
            });
        }
    }

    @Override
    protected void doOKAction() {
        RunConfigurable configurable = (RunConfigurable)this.getConfigurable();
        super.doOKAction();
        if (this.isOK()) {
            configurable.updateActiveConfigurationFromSelected();
        }
    }

    @Override
    @Nullable
    public Executor getExecutor() {
        return this.myExecutor;
    }
}

