/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.CommonBundle;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.CompatibilityAwareRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExecutionManagerImpl
extends ExecutionManager
implements Disposable {
    public static final Key<Object> EXECUTION_SESSION_ID_KEY = Key.create((String)"EXECUTION_SESSION_ID_KEY");
    public static final Key<Boolean> EXECUTION_SKIP_RUN = Key.create((String)"EXECUTION_SKIP_RUN");
    protected static final Logger LOG = Logger.getInstance(ExecutionManagerImpl.class);
    private static final ProcessHandler[] EMPTY_PROCESS_HANDLERS = new ProcessHandler[0];
    private final Project myProject;
    private final Alarm myAwaitingTerminationAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final Map<RunProfile, ExecutionEnvironment> myAwaitingRunProfiles = ContainerUtil.newHashMap();
    protected final List<Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor>> myRunningConfigurations = ContainerUtil.createLockFreeCopyOnWriteList();

    @NotNull
    public static ExecutionManagerImpl getInstance(@NotNull Project project) {
        return (ExecutionManagerImpl)((Object)ServiceManager.getService((Project)project, ExecutionManager.class));
    }

    protected ExecutionManagerImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    private static ExecutionEnvironmentBuilder createEnvironmentBuilder(@NotNull Project project, @NotNull Executor executor, @Nullable RunnerAndConfigurationSettings configuration2) {
        ExecutionEnvironmentBuilder builder2 = new ExecutionEnvironmentBuilder(project, executor);
        ProgramRunner runner = ProgramRunnerUtil.getRunner(executor.getId(), configuration2);
        if (runner == null && configuration2 != null) {
            LOG.error("Cannot find runner for " + configuration2.getName());
        } else if (runner != null) {
            builder2.runnerAndSettings(runner, configuration2);
        }
        return builder2;
    }

    public static boolean isProcessRunning(@Nullable RunContentDescriptor descriptor) {
        ProcessHandler processHandler2 = descriptor == null ? null : descriptor.getProcessHandler();
        return processHandler2 != null && !processHandler2.isProcessTerminated();
    }

    private static void restart(@NotNull ExecutionEnvironment environment) {
        if (environment.getProject().isDisposed()) {
            return;
        }
        RunnerAndConfigurationSettings settings = environment.getRunnerAndConfigurationSettings();
        ProgramRunnerUtil.executeConfiguration(environment, settings != null && settings.isEditBeforeRun(), true);
    }

    private static boolean userApprovesStopForSameTypeConfigurations(@NotNull Project project, String configName, int instancesCount) {
        final RunManagerConfig config2 = RunManagerImpl.getInstanceImpl(project).getConfig();
        if (!config2.isRestartRequiresConfirmation()) {
            return true;
        }
        DialogWrapper.DoNotAskOption option2 = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return config2.isRestartRequiresConfirmation();
            }

            public void setToBeShown(boolean value, int exitCode) {
                config2.setRestartRequiresConfirmation(value);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                return CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
            }
        };
        return Messages.showOkCancelDialog((Project)project, (String)ExecutionBundle.message((String)"rerun.singleton.confirmation.message", (Object[])new Object[]{configName, instancesCount}), (String)ExecutionBundle.message((String)"process.is.running.dialog.title", (Object[])new Object[]{configName}), (String)ExecutionBundle.message((String)"rerun.confirmation.button.text", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)option2) == 0;
    }

    private static boolean userApprovesStopForIncompatibleConfigurations(Project project, String configName, List<RunContentDescriptor> runningIncompatibleDescriptors) {
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
        final RunManagerConfig config2 = runManager.getConfig();
        if (!config2.isStopIncompatibleRequiresConfirmation()) {
            return true;
        }
        DialogWrapper.DoNotAskOption option2 = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return config2.isStopIncompatibleRequiresConfirmation();
            }

            public void setToBeShown(boolean value, int exitCode) {
                config2.setStopIncompatibleRequiresConfirmation(value);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                return CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
            }
        };
        StringBuilder names = new StringBuilder();
        for (RunContentDescriptor descriptor : runningIncompatibleDescriptors) {
            String name = descriptor.getDisplayName();
            if (names.length() > 0) {
                names.append(", ");
            }
            names.append(StringUtil.isEmpty((String)name) ? ExecutionBundle.message((String)"run.configuration.no.name", (Object[])new Object[0]) : String.format("'%s'", name));
        }
        return Messages.showOkCancelDialog((Project)project, (String)ExecutionBundle.message((String)"stop.incompatible.confirmation.message", (Object[])new Object[]{configName, names.toString(), runningIncompatibleDescriptors.size()}), (String)ExecutionBundle.message((String)"incompatible.configuration.is.running.dialog.title", (Object[])new Object[]{runningIncompatibleDescriptors.size()}), (String)ExecutionBundle.message((String)"stop.incompatible.confirmation.button.text", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)option2) == 0;
    }

    public static void stopProcess(@Nullable RunContentDescriptor descriptor) {
        ExecutionManagerImpl.stopProcess(descriptor != null ? descriptor.getProcessHandler() : null);
    }

    public static void stopProcess(@Nullable ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            return;
        }
        processHandler2.putUserData(ProcessHandler.TERMINATION_REQUESTED, (Object)Boolean.TRUE);
        if (processHandler2 instanceof KillableProcess && processHandler2.isProcessTerminating()) {
            ((KillableProcess)processHandler2).killProcess();
            return;
        }
        if (!processHandler2.isProcessTerminated()) {
            if (processHandler2.detachIsDefault()) {
                processHandler2.detachProcess();
            } else {
                processHandler2.destroyProcess();
            }
        }
    }

    public void dispose() {
        for (Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor> trinity : this.myRunningConfigurations) {
            Disposer.dispose((Disposable)((Disposable)trinity.first));
        }
        this.myRunningConfigurations.clear();
    }

    @NotNull
    public RunContentManager getContentManager() {
        return RunContentManager.getInstance((Project)this.myProject);
    }

    @NotNull
    public static List<RunContentDescriptor> getAllDescriptors(@NotNull Project project) {
        RunContentManager contentManager = (RunContentManager)ServiceManager.getServiceIfCreated((Project)project, RunContentManager.class);
        return contentManager == null ? Collections.emptyList() : contentManager.getAllDescriptors();
    }

    @NotNull
    public ProcessHandler[] getRunningProcesses() {
        List handlers = null;
        for (RunContentDescriptor descriptor : ExecutionManagerImpl.getAllDescriptors(this.myProject)) {
            ProcessHandler processHandler2 = descriptor.getProcessHandler();
            if (processHandler2 == null) continue;
            if (handlers == null) {
                handlers = new SmartList();
            }
            handlers.add(processHandler2);
        }
        return handlers == null ? EMPTY_PROCESS_HANDLERS : handlers.toArray(new ProcessHandler[0]);
    }

    public void compileAndRun(@NotNull Runnable startRunnable2, @NotNull ExecutionEnvironment environment, @Nullable RunProfileState state, @Nullable Runnable onCancelRunnable) {
        RunProfile profile2;
        long id = environment.getExecutionId();
        if (id == 0L) {
            id = environment.assignNewExecutionId();
        }
        if (!((profile2 = environment.getRunProfile()) instanceof RunConfiguration)) {
            startRunnable2.run();
            return;
        }
        RunConfiguration runConfiguration = (RunConfiguration)profile2;
        List<BeforeRunTask<?>> beforeRunTasks = RunManagerImplKt.doGetBeforeRunTasks(runConfiguration);
        if (beforeRunTasks.isEmpty()) {
            startRunnable2.run();
        } else {
            DataContext context = environment.getDataContext();
            DataContext projectContext = context != null ? context : SimpleDataContext.getProjectContext(this.myProject);
            long finalId = id;
            Long executionSessionId = new Long(id);
            Map<BeforeRunTask<?>, Executor> runBeforeRunExecutorMap = Collections.synchronizedMap(new LinkedHashMap());
            for (BeforeRunTask<?> task2 : beforeRunTasks) {
                RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask runBeforeRun;
                RunnerAndConfigurationSettings settings;
                BeforeRunTaskProvider provider = BeforeRunTaskProvider.getProvider((Project)this.myProject, (Key)task2.getProviderId());
                if (provider == null || !(task2 instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask) || (settings = (runBeforeRun = (RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)task2).getSettings()) == null) continue;
                Executor executor = environment.getExecutor();
                if (!RunManagerImpl.canRunConfiguration(settings, executor) && !RunManagerImpl.canRunConfiguration(settings, executor = DefaultRunExecutor.getRunExecutorInstance())) {
                    if (onCancelRunnable != null) {
                        onCancelRunnable.run();
                    }
                    ExecutionUtil.handleExecutionError((ExecutionEnvironment)environment, (ExecutionException)new ExecutionException("cannot start before run task '" + settings + "'."));
                    return;
                }
                runBeforeRunExecutorMap.put(task2, executor);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                for (BeforeRunTask task2 : beforeRunTasks) {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    BeforeRunTaskProvider provider = BeforeRunTaskProvider.getProvider((Project)this.myProject, (Key)task2.getProviderId());
                    if (provider == null) {
                        LOG.warn("Cannot find BeforeRunTaskProvider for id='" + task2.getProviderId() + "'");
                        continue;
                    }
                    ExecutionEnvironmentBuilder builder2 = new ExecutionEnvironmentBuilder(environment).contentToReuse(null);
                    Executor executor = (Executor)runBeforeRunExecutorMap.get(task2);
                    if (executor != null) {
                        builder2.executor(executor);
                    }
                    ExecutionEnvironment taskEnvironment = builder2.build();
                    taskEnvironment.setExecutionId(finalId);
                    EXECUTION_SESSION_ID_KEY.set((UserDataHolder)taskEnvironment, (Object)executionSessionId);
                    if (provider.executeTask(projectContext, runConfiguration, taskEnvironment, task2)) continue;
                    if (onCancelRunnable != null) {
                        SwingUtilities.invokeLater(onCancelRunnable);
                    }
                    return;
                }
                this.doRun(environment, startRunnable2);
            });
        }
    }

    protected void doRun(@NotNull ExecutionEnvironment environment, @NotNull Runnable startRunnable2) {
        Boolean allowSkipRun = (Boolean)environment.getUserData(EXECUTION_SKIP_RUN);
        if (allowSkipRun != null && allowSkipRun.booleanValue()) {
            ((ExecutionListener)environment.getProject().getMessageBus().syncPublisher(EXECUTION_TOPIC)).processNotStarted(environment.getExecutor().getId(), environment);
        } else {
            SwingUtilities.invokeLater(() -> {
                if (!this.myProject.isDisposed()) {
                    RunnerAndConfigurationSettings settings = environment.getRunnerAndConfigurationSettings();
                    if (settings != null && !settings.getType().isDumbAware() && DumbService.isDumb((Project)this.myProject)) {
                        DumbService.getInstance((Project)this.myProject).runWhenSmart(startRunnable2);
                    } else {
                        try {
                            startRunnable2.run();
                        }
                        catch (IndexNotReadyException ignored) {
                            ExecutionUtil.handleExecutionError((ExecutionEnvironment)environment, (ExecutionException)new ExecutionException("cannot start while indexing is in progress."));
                        }
                    }
                }
            });
        }
    }

    public void restartRunProfile(@NotNull Project project, @NotNull Executor executor, @NotNull ExecutionTarget target2, @Nullable RunnerAndConfigurationSettings configuration2, @Nullable ProcessHandler processHandler2) {
        ExecutionEnvironmentBuilder builder2 = ExecutionManagerImpl.createEnvironmentBuilder(project, executor, configuration2);
        if (processHandler2 != null) {
            for (RunContentDescriptor descriptor : ExecutionManagerImpl.getAllDescriptors(project)) {
                if (descriptor.getProcessHandler() != processHandler2) continue;
                builder2.contentToReuse(descriptor);
                break;
            }
        }
        this.restartRunProfile(builder2.target(target2).build());
    }

    public void restartRunProfile(final @NotNull ExecutionEnvironment environment) {
        final RunnerAndConfigurationSettings configuration2 = environment.getRunnerAndConfigurationSettings();
        List<Object> runningIncompatible = configuration2 == null ? Collections.emptyList() : this.getIncompatibleRunningDescriptors(configuration2);
        RunContentDescriptor contentToReuse = environment.getContentToReuse();
        List<Object> runningOfTheSameType = Collections.emptyList();
        if (configuration2 != null && !configuration2.getConfiguration().isAllowRunningInParallel()) {
            runningOfTheSameType = this.getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)it -> configuration2 == it));
        } else if (ExecutionManagerImpl.isProcessRunning(contentToReuse)) {
            runningOfTheSameType = Collections.singletonList(contentToReuse);
        }
        List runningToStop = ContainerUtil.concat(runningOfTheSameType, runningIncompatible);
        if (!runningToStop.isEmpty()) {
            if (configuration2 != null) {
                if (!(runningOfTheSameType.isEmpty() || runningOfTheSameType.size() <= 1 && contentToReuse != null && runningOfTheSameType.get(0) == contentToReuse)) {
                    RunConfiguration.RestartSingletonResult result2 = configuration2.getConfiguration().restartSingleton(environment);
                    if (result2 == RunConfiguration.RestartSingletonResult.NO_FURTHER_ACTION) {
                        return;
                    }
                    if (result2 == RunConfiguration.RestartSingletonResult.ASK_AND_RESTART && !ExecutionManagerImpl.userApprovesStopForSameTypeConfigurations(environment.getProject(), configuration2.getName(), runningOfTheSameType.size())) {
                        return;
                    }
                }
                if (!runningIncompatible.isEmpty() && !ExecutionManagerImpl.userApprovesStopForIncompatibleConfigurations(this.myProject, configuration2.getName(), runningIncompatible)) {
                    return;
                }
            }
            for (RunContentDescriptor descriptor : runningToStop) {
                ExecutionManagerImpl.stopProcess(descriptor);
            }
        }
        if (this.myAwaitingRunProfiles.get(environment.getRunProfile()) == environment) {
            return;
        }
        this.myAwaitingRunProfiles.put(environment.getRunProfile(), environment);
        final List<Object> finalRunningOfTheSameType = runningOfTheSameType;
        this.awaitTermination(new Runnable(){

            @Override
            public void run() {
                if (ExecutionManagerImpl.this.myAwaitingRunProfiles.get(environment.getRunProfile()) != environment) {
                    return;
                }
                if (DumbService.getInstance((Project)ExecutionManagerImpl.this.myProject).isDumb() && configuration2 != null && !configuration2.getType().isDumbAware() || ExecutorRegistry.getInstance().isStarting(environment)) {
                    ExecutionManagerImpl.this.awaitTermination(this, 100L);
                    return;
                }
                for (RunContentDescriptor descriptor : finalRunningOfTheSameType) {
                    ProcessHandler processHandler2 = descriptor.getProcessHandler();
                    if (processHandler2 == null || processHandler2.isProcessTerminated()) continue;
                    ExecutionManagerImpl.this.awaitTermination(this, 100L);
                    return;
                }
                ExecutionManagerImpl.this.myAwaitingRunProfiles.remove(environment.getRunProfile());
                ExecutionManagerImpl.restart(environment);
            }
        }, 50L);
    }

    private void awaitTermination(@NotNull Runnable request, long delayMillis) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater(request, ModalityState.any());
        } else {
            this.myAwaitingTerminationAlarm.addRequest(request, delayMillis);
        }
    }

    @NotNull
    private List<RunContentDescriptor> getIncompatibleRunningDescriptors(@NotNull RunnerAndConfigurationSettings configurationAndSettings) {
        RunConfiguration configurationToCheckCompatibility = configurationAndSettings.getConfiguration();
        return this.getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)runningConfigurationAndSettings -> {
            RunConfiguration runningConfiguration;
            RunConfiguration runConfiguration = runningConfiguration = runningConfigurationAndSettings == null ? null : runningConfigurationAndSettings.getConfiguration();
            if (!(runningConfiguration instanceof CompatibilityAwareRunProfile)) {
                return false;
            }
            return ((CompatibilityAwareRunProfile)runningConfiguration).mustBeStoppedToRun(configurationToCheckCompatibility);
        }));
    }

    @NotNull
    public List<RunContentDescriptor> getRunningDescriptors(@NotNull Condition<RunnerAndConfigurationSettings> condition) {
        SmartList result2 = new SmartList();
        for (Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor> trinity : this.myRunningConfigurations) {
            ProcessHandler processHandler2;
            if (trinity.getSecond() == null || !condition.value(trinity.getSecond()) || (processHandler2 = ((RunContentDescriptor)trinity.getFirst()).getProcessHandler()) == null || processHandler2.isProcessTerminated()) continue;
            result2.add(trinity.getFirst());
        }
        return result2;
    }

    @NotNull
    public List<RunContentDescriptor> getDescriptors(@NotNull Condition<RunnerAndConfigurationSettings> condition) {
        SmartList result2 = new SmartList();
        for (Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor> trinity : this.myRunningConfigurations) {
            if (trinity.getSecond() == null || !condition.value(trinity.getSecond())) continue;
            result2.add(trinity.getFirst());
        }
        return result2;
    }

    @NotNull
    public Set<Executor> getExecutors(RunContentDescriptor descriptor) {
        HashSet<Executor> result2 = new HashSet<Executor>();
        for (Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor> trinity : this.myRunningConfigurations) {
            if (descriptor != trinity.first) continue;
            result2.add((Executor)trinity.third);
        }
        return result2;
    }

    @NotNull
    public Set<RunnerAndConfigurationSettings> getConfigurations(RunContentDescriptor descriptor) {
        HashSet<RunnerAndConfigurationSettings> result2 = new HashSet<RunnerAndConfigurationSettings>();
        for (Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor> trinity : this.myRunningConfigurations) {
            if (descriptor != trinity.first || trinity.second == null) continue;
            result2.add((RunnerAndConfigurationSettings)trinity.second);
        }
        return result2;
    }
}

