/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.ExecutionTargetManagerImpl;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.ConfigurationSelectionUtil;
import com.intellij.execution.compound.TypeNameTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunConfigurationBeforeRunProviderDelegate;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class RunConfigurationBeforeRunProvider
extends BeforeRunTaskProvider<RunConfigurableBeforeRunTask> {
    public static final Key<RunConfigurableBeforeRunTask> ID = Key.create((String)"RunConfigurationTask");
    private static final Logger LOG = Logger.getInstance(RunConfigurationBeforeRunProvider.class);
    private final Project myProject;

    public RunConfigurationBeforeRunProvider(Project project) {
        this.myProject = project;
    }

    public Key<RunConfigurableBeforeRunTask> getId() {
        return ID;
    }

    public Icon getIcon() {
        return AllIcons.Actions.Execute;
    }

    public Icon getTaskIcon(RunConfigurableBeforeRunTask task2) {
        if (task2.getSettings() == null) {
            return null;
        }
        return ProgramRunnerUtil.getConfigurationIcon(task2.getSettings(), false);
    }

    public String getName() {
        return ExecutionBundle.message((String)"before.launch.run.another.configuration", (Object[])new Object[0]);
    }

    public String getDescription(RunConfigurableBeforeRunTask task2) {
        Pair<RunnerAndConfigurationSettings, ExecutionTarget> settingsWithTarget = task2.getSettingsWithTarget();
        if (settingsWithTarget == null) {
            return ExecutionBundle.message((String)"before.launch.run.another.configuration", (Object[])new Object[0]);
        }
        String text = ConfigurationSelectionUtil.getDisplayText(((RunnerAndConfigurationSettings)settingsWithTarget.first).getConfiguration(), (ExecutionTarget)settingsWithTarget.second);
        return ExecutionBundle.message((String)"before.launch.run.certain.configuration", (Object[])new Object[]{text});
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public RunConfigurableBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        return new RunConfigurableBeforeRunTask();
    }

    public Promise<Boolean> configureTask(@NotNull DataContext context, @NotNull RunConfiguration configuration2, @NotNull RunConfigurableBeforeRunTask task2) {
        Project project = configuration2.getProject();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
        List configurations = ContainerUtil.map(RunConfigurationBeforeRunProvider.getAvailableConfigurations(configuration2), it -> it.getConfiguration());
        AsyncPromise result2 = new AsyncPromise();
        ConfigurationSelectionUtil.createPopup(project, runManager, configurations, (selectedConfigs, selectedTarget) -> {
            RunnerAndConfigurationSettingsImpl selectedSettings;
            RunConfiguration selectedConfig = (RunConfiguration)ContainerUtil.getFirstItem((List)selectedConfigs);
            RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl = selectedSettings = selectedConfig == null ? null : runManager.getSettings(selectedConfig);
            if (selectedSettings != null) {
                task2.setSettingsWithTarget(selectedSettings, (ExecutionTarget)selectedTarget);
                result2.setResult((Object)true);
            } else {
                result2.setResult((Object)false);
            }
        }).showInBestPositionFor(context);
        return result2;
    }

    @NotNull
    private static List<RunnerAndConfigurationSettings> getAvailableConfigurations(@NotNull RunConfiguration runConfiguration) {
        Project project = runConfiguration.getProject();
        if (project == null || !project.isInitialized()) {
            return Collections.emptyList();
        }
        ArrayList<RunnerAndConfigurationSettings> configurations = new ArrayList<RunnerAndConfigurationSettings>(RunManagerImpl.getInstanceImpl(project).getAllSettings());
        String executorId = DefaultRunExecutor.getRunExecutorInstance().getId();
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)iterator.next();
            ProgramRunner runner = ProgramRunnerUtil.getRunner(executorId, settings);
            if (runner != null && settings.getConfiguration() != runConfiguration) continue;
            iterator.remove();
        }
        return configurations;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration2, @NotNull RunConfigurableBeforeRunTask task2) {
        RunnerAndConfigurationSettings settings = task2.getSettings();
        if (settings == null) {
            return false;
        }
        String executorId = DefaultRunExecutor.getRunExecutorInstance().getId();
        ProgramRunner runner = ProgramRunnerUtil.getRunner(executorId, settings);
        return runner != null && runner.canRun(executorId, (RunProfile)settings.getConfiguration());
    }

    public boolean executeTask(@NotNull DataContext dataContext, @NotNull RunConfiguration configuration2, @NotNull ExecutionEnvironment env, @NotNull RunConfigurableBeforeRunTask task2) {
        Pair<RunnerAndConfigurationSettings, ExecutionTarget> settings = task2.getSettingsWithTarget();
        if (settings == null) {
            return true;
        }
        return RunConfigurationBeforeRunProvider.doExecuteTask(env, (RunnerAndConfigurationSettings)settings.first, (ExecutionTarget)settings.second);
    }

    public static boolean doExecuteTask(@NotNull ExecutionEnvironment env, @NotNull RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget target2) {
        Executor executor = env.getExecutor();
        String executorId = executor.getId();
        ExecutionEnvironmentBuilder builder2 = ExecutionEnvironmentBuilder.createOrNull((Executor)executor, (RunnerAndConfigurationSettings)settings);
        if (builder2 == null) {
            return false;
        }
        ExecutionTarget effectiveTarget = target2;
        if (effectiveTarget == null && ExecutionTargetManager.canRun((RunConfiguration)settings.getConfiguration(), (ExecutionTarget)env.getExecutionTarget())) {
            effectiveTarget = env.getExecutionTarget();
        }
        List allTargets = ExecutionTargetManager.getInstance((Project)env.getProject()).getTargetsFor(settings.getConfiguration());
        if (effectiveTarget == null) {
            effectiveTarget = (ExecutionTarget)ContainerUtil.find((Iterable)allTargets, it -> it.isReady());
        }
        if (effectiveTarget == null) {
            effectiveTarget = (ExecutionTarget)ContainerUtil.getFirstItem((List)allTargets);
        }
        if (effectiveTarget == null) {
            return false;
        }
        ExecutionEnvironment environment = builder2.target(effectiveTarget).build();
        environment.setExecutionId(env.getExecutionId());
        if (!environment.getRunner().canRun(executorId, environment.getRunProfile())) {
            return false;
        }
        RunConfigurationBeforeRunProvider.beforeRun(environment);
        return RunConfigurationBeforeRunProvider.doRunTask(executorId, environment, environment.getRunner());
    }

    public static boolean doRunTask(final String executorId, final ExecutionEnvironment environment, ProgramRunner<?> runner) {
        final Semaphore targetDone = new Semaphore();
        final Ref result2 = new Ref((Object)false);
        Disposable disposable = Disposer.newDisposable();
        environment.getProject().getMessageBus().connect(disposable).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStartScheduled(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                    targetDone.down();
                }
            }

            public void processNotStarted(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                    Boolean skipRun = (Boolean)environment.getUserData(ExecutionManagerImpl.EXECUTION_SKIP_RUN);
                    if (skipRun != null && skipRun.booleanValue()) {
                        result2.set((Object)true);
                    }
                    targetDone.up();
                }
            }

            public void processTerminated(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal, @NotNull ProcessHandler handler2, int exitCode) {
                if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                    result2.set((Object)(exitCode == 0 ? 1 : 0));
                    targetDone.up();
                }
            }
        });
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                try {
                    runner.execute(environment);
                }
                catch (ExecutionException e) {
                    targetDone.up();
                    LOG.error((Throwable)e);
                }
            }, ModalityState.NON_MODAL);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            Disposer.dispose((Disposable)disposable);
            return false;
        }
        targetDone.waitFor();
        Disposer.dispose((Disposable)disposable);
        return (Boolean)result2.get();
    }

    private static void beforeRun(@NotNull ExecutionEnvironment environment) {
        for (RunConfigurationBeforeRunProviderDelegate delegate : RunConfigurationBeforeRunProviderDelegate.EP_NAME.getExtensionList()) {
            delegate.beforeRun(environment);
        }
    }

    public class RunConfigurableBeforeRunTask
    extends BeforeRunTask<RunConfigurableBeforeRunTask> {
        @Nullable
        private TypeNameTarget myTypeNameTarget;
        @Nullable
        private Pair<RunnerAndConfigurationSettings, ExecutionTarget> mySettingsWithTarget;

        RunConfigurableBeforeRunTask() {
            super(ID);
        }

        public void writeExternal(@NotNull Element element) {
            super.writeExternal(element);
            if (this.myTypeNameTarget != null) {
                element.setAttribute("run_configuration_name", this.myTypeNameTarget.getName());
                element.setAttribute("run_configuration_type", this.myTypeNameTarget.getType());
                if (this.myTypeNameTarget.getTargetId() != null) {
                    element.setAttribute("run_configuration_target", this.myTypeNameTarget.getTargetId());
                }
            }
        }

        public void readExternal(@NotNull Element element) {
            super.readExternal(element);
            String name = element.getAttributeValue("run_configuration_name");
            String type = element.getAttributeValue("run_configuration_type");
            String targetId = element.getAttributeValue("run_configuration_target");
            if (name != null && type != null) {
                this.myTypeNameTarget = new TypeNameTarget(type, name, targetId);
            }
            this.mySettingsWithTarget = null;
        }

        boolean isMySettings(@NotNull RunnerAndConfigurationSettings settings) {
            if (this.mySettingsWithTarget != null) {
                return this.mySettingsWithTarget.first == settings;
            }
            return this.myTypeNameTarget != null && settings.getType().getId().equals(this.myTypeNameTarget.getType()) && settings.getName().equals(this.myTypeNameTarget.getName());
        }

        void init() {
            if (this.mySettingsWithTarget != null) {
                return;
            }
            if (this.myTypeNameTarget != null) {
                RunnerAndConfigurationSettings settings = RunManagerImpl.getInstanceImpl(RunConfigurationBeforeRunProvider.this.myProject).findConfigurationByTypeAndName(this.myTypeNameTarget.getType(), this.myTypeNameTarget.getName());
                ExecutionTarget target2 = ((ExecutionTargetManagerImpl)ExecutionTargetManager.getInstance((Project)RunConfigurationBeforeRunProvider.this.myProject)).findTargetByIdFor(settings != null ? settings.getConfiguration() : null, this.myTypeNameTarget.getTargetId());
                this.setSettingsWithTarget(settings, target2);
            }
        }

        public void setSettingsWithTarget(@Nullable RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget target2) {
            Pair<RunnerAndConfigurationSettings, ExecutionTarget> pair = this.mySettingsWithTarget = settings == null ? null : Pair.create((Object)settings, (Object)target2);
            this.myTypeNameTarget = settings == null ? null : new TypeNameTarget(settings.getType().getId(), settings.getName(), target2 == null ? null : target2.getId());
        }

        @Nullable
        public RunnerAndConfigurationSettings getSettings() {
            return (RunnerAndConfigurationSettings)Pair.getFirst(this.getSettingsWithTarget());
        }

        @Nullable
        public Pair<RunnerAndConfigurationSettings, ExecutionTarget> getSettingsWithTarget() {
            this.init();
            return this.mySettingsWithTarget;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RunConfigurableBeforeRunTask that = (RunConfigurableBeforeRunTask)((Object)o);
            return Comparing.equal((Object)((Object)this.myTypeNameTarget), (Object)((Object)that.myTypeNameTarget));
        }

        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + (this.myTypeNameTarget != null ? this.myTypeNameTarget.hashCode() : 0);
            return result2;
        }
    }
}

