/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.openapi.util.text.NaturalComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u001e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a6\u0010\u000b\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\n0\t2!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\f0\u000eH\u0080\b\u00a8\u0006\u0012"}, d2={"compareTypesForUi", "", "type1", "Lcom/intellij/execution/configurations/ConfigurationType;", "type2", "getSortedFolderNames", "", "", "list", "", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "forEachManaged", "", "handler", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "settings", "intellij.platform.lang.impl"})
public final class RunConfigurationListManagerHelperKt {
    private static final List<String> getSortedFolderNames(Collection<? extends RunnerAndConfigurationSettings> list2) {
        ArrayList<String> result2 = new ArrayList<String>();
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : list2) {
            String folderName = runnerAndConfigurationSettings.getFolderName();
            if (folderName == null || result2.contains(folderName)) continue;
            result2.add(folderName);
        }
        CollectionsKt.sortWith((List)result2, (Comparator)NaturalComparator.INSTANCE);
        result2.add(null);
        return result2;
    }

    public static final void forEachManaged(@NotNull Collection<? extends RunnerAndConfigurationSettings> $receiver, @NotNull Function1<? super RunnerAndConfigurationSettings, Unit> handler2) {
        int $i$f$forEachManaged = 0;
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : $receiver) {
            if (!runnerAndConfigurationSettings.getType().isManaged()) continue;
            handler2.invoke((Object)runnerAndConfigurationSettings);
        }
    }

    public static final int compareTypesForUi(@NotNull ConfigurationType type1, @NotNull ConfigurationType type2) {
        return type1 == type2 ? 0 : (type1 == UnknownConfigurationType.getInstance() ? 1 : (type2 == UnknownConfigurationType.getInstance() ? -1 : NaturalComparator.INSTANCE.compare(type1.getDisplayName(), type2.getDisplayName())));
    }

    public static final /* synthetic */ List access$getSortedFolderNames(Collection list2) {
        return RunConfigurationListManagerHelperKt.getSortedFolderNames(list2);
    }
}

