/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.diagnostic.PluginException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.PersistentAwareRunConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleConfigurationType;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.impl.RunConfigurationLevel;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImplKt;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.ProjectPathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringKt;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f*\u0002\u0013 \u0018\u0000 [2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u00032\u00020\u0005:\u0003[\\]B'\b\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rB/\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\b\u0010(\u001a\u00020\u0000H\u0016J\u0011\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0004H\u0096\u0002J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020-H\u0016J\u001b\u0010.\u001a\u0004\u0018\u00010/2\u000e\b\u0004\u00100\u001a\b\u0012\u0004\u0012\u00020%01H\u0082\bJ\b\u00102\u001a\u00020\tH\u0016J\u0016\u00103\u001a\u0004\u0018\u0001042\n\u00105\u001a\u0006\u0012\u0002\b\u000306H\u0016J\b\u00107\u001a\u000208H\u0016J\n\u00109\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010:\u001a\u00020\u0016H\u0016J\u0016\u0010;\u001a\u0004\u0018\u00010<2\n\u00105\u001a\u0006\u0012\u0002\b\u000306H\u0016J\n\u0010=\u001a\u0004\u0018\u00010>H\u0016J\b\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u00020\u0016H\u0016J2\u0010B\u001a\u00020%\"\u0004\b\u0000\u0010C2\u0010\u0010D\u001a\f\u0012\u0004\u0012\u0002HC0ER\u00020\u00002\u0010\u0010F\u001a\f\u0012\u0004\u0012\u0002HC0ER\u00020\u0000H\u0002J\u0015\u0010G\u001a\u00020%2\u0006\u0010H\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\bIJ\b\u0010\u0017\u001a\u00020\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010J\u001a\u00020\u000bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010K\u001a\u00020\u000bH\u0016J\u0006\u0010L\u001a\u00020\u000bJ\u0016\u0010M\u001a\u00020%2\u0006\u0010N\u001a\u00020O2\u0006\u0010J\u001a\u00020\u000bJ\u0010\u0010P\u001a\u00020%2\u0006\u0010Q\u001a\u00020\u000bH\u0016J\u0010\u0010R\u001a\u00020%2\u0006\u0010Q\u001a\u00020\u000bH\u0016J\u0012\u0010S\u001a\u00020%2\b\u0010Q\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010T\u001a\u00020%2\u0006\u0010U\u001a\u00020\u0016H\u0016J\u0010\u0010V\u001a\u00020%2\u0006\u0010Q\u001a\u00020\u000bH\u0016J\u0010\u0010W\u001a\u00020%2\u0006\u0010Q\u001a\u00020\u000bH\u0016J\b\u0010X\u001a\u00020\u0016H\u0016J\u000e\u0010Y\u001a\u00020%2\u0006\u0010N\u001a\u00020OJ\b\u0010Z\u001a\u00020OH\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;", "", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "", "", "Lcom/intellij/configurationStore/SerializableScheme;", "manager", "Lcom/intellij/execution/impl/RunManagerImpl;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "isTemplate", "", "isSingleton", "(Lcom/intellij/execution/impl/RunManagerImpl;Lcom/intellij/execution/configurations/RunConfiguration;ZZ)V", "_configuration", "level", "Lcom/intellij/execution/impl/RunConfigurationLevel;", "(Lcom/intellij/execution/impl/RunManagerImpl;Lcom/intellij/execution/configurations/RunConfiguration;ZLcom/intellij/execution/impl/RunConfigurationLevel;)V", "configurationPerRunnerSettings", "com/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$configurationPerRunnerSettings$1", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$configurationPerRunnerSettings$1;", "folderName", "", "isActivateToolWindowBeforeRun", "isEditBeforeRun", "getLevel", "()Lcom/intellij/execution/impl/RunConfigurationLevel;", "setLevel", "(Lcom/intellij/execution/impl/RunConfigurationLevel;)V", "getManager", "()Lcom/intellij/execution/impl/RunManagerImpl;", "runnerSettings", "com/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$runnerSettings$1", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$runnerSettings$1;", "uniqueId", "wasSingletonSpecifiedExplicitly", "checkSettings", "", "executor", "Lcom/intellij/execution/Executor;", "clone", "compareTo", "", "other", "createFactory", "Lcom/intellij/openapi/util/Factory;", "doCheck", "Lcom/intellij/execution/configurations/RuntimeConfigurationWarning;", "check", "Lkotlin/Function0;", "getConfiguration", "getConfigurationSettings", "Lcom/intellij/execution/configurations/ConfigurationPerRunnerSettings;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "getFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getFolderName", "getName", "getRunnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "getSchemeState", "Lcom/intellij/openapi/options/SchemeState;", "getType", "Lcom/intellij/execution/configurations/ConfigurationType;", "getUniqueID", "importFromTemplate", "T", "templateItem", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$RunnerItem;", "item", "importRunnerAndConfigurationSettings", "template", "importRunnerAndConfigurationSettings$intellij_platform_lang_impl", "isShared", "isTemporary", "needsToBeMigrated", "readExternal", "element", "Lorg/jdom/Element;", "setActivateToolWindowBeforeRun", "value", "setEditBeforeRun", "setFolderName", "setName", "name", "setShared", "setTemporary", "toString", "writeExternal", "writeScheme", "Companion", "InfoProvider", "RunnerItem", "intellij.platform.lang.impl"})
public final class RunnerAndConfigurationSettingsImpl
implements Cloneable,
RunnerAndConfigurationSettings,
Comparable<Object>,
SerializableScheme {
    private final runnerSettings.1 runnerSettings;
    private final configurationPerRunnerSettings.1 configurationPerRunnerSettings;
    private boolean isEditBeforeRun;
    private boolean isActivateToolWindowBeforeRun;
    private boolean wasSingletonSpecifiedExplicitly;
    private String folderName;
    private String uniqueId;
    @NotNull
    private final RunManagerImpl manager;
    private RunConfiguration _configuration;
    private boolean isTemplate;
    @NotNull
    private RunConfigurationLevel level;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ConfigurationFactory getFactory() {
        RunConfiguration runConfiguration = this._configuration;
        if (runConfiguration == null || (runConfiguration = runConfiguration.getFactory()) == null) {
            runConfiguration = (ConfigurationFactory)UnknownConfigurationType.getInstance();
        }
        return runConfiguration;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public boolean isTemporary() {
        return this.level == RunConfigurationLevel.TEMPORARY;
    }

    public void setTemporary(boolean value) {
        this.level = value ? RunConfigurationLevel.TEMPORARY : RunConfigurationLevel.WORKSPACE;
    }

    public boolean isShared() {
        return this.level == RunConfigurationLevel.PROJECT;
    }

    public void setShared(boolean value) {
        if (value) {
            this.level = RunConfigurationLevel.PROJECT;
        } else if (this.level == RunConfigurationLevel.PROJECT) {
            this.level = RunConfigurationLevel.WORKSPACE;
        }
    }

    @NotNull
    public RunConfiguration getConfiguration() {
        RunConfiguration runConfiguration = this._configuration;
        if (runConfiguration == null) {
            runConfiguration = UnknownConfigurationType.getInstance().createTemplateConfiguration(this.manager.getProject());
        }
        return runConfiguration;
    }

    @NotNull
    public Factory<RunnerAndConfigurationSettings> createFactory() {
        return (Factory)new Factory<RunnerAndConfigurationSettings>(this){
            final /* synthetic */ RunnerAndConfigurationSettingsImpl this$0;

            @NotNull
            public final RunnerAndConfigurationSettingsImpl create() {
                RunConfiguration configuration2 = this.this$0.getConfiguration();
                RunManagerImpl runManagerImpl = this.this$0.getManager();
                ConfigurationFactory configurationFactory = configuration2.getFactory();
                if (configurationFactory == null) {
                    Intrinsics.throwNpe();
                }
                return new RunnerAndConfigurationSettingsImpl(runManagerImpl, configurationFactory.createConfiguration(ExecutionBundle.message((String)"default.run.configuration.name", (Object[])new Object[0]), configuration2), false, null, 12, null);
            }
            {
                this.this$0 = runnerAndConfigurationSettingsImpl;
            }
        };
    }

    public void setName(@NotNull String name) {
        this.uniqueId = null;
        this.getConfiguration().setName(name);
    }

    @NotNull
    public String getName() {
        RunConfiguration configuration2 = this.getConfiguration();
        if (this.isTemplate) {
            return "<template> of " + this.getFactory().getId();
        }
        return configuration2.getName();
    }

    @NotNull
    public String getUniqueID() {
        String result2 = this.uniqueId;
        if (result2 == null || !StringsKt.contains$default((CharSequence)result2, (CharSequence)this.getConfiguration().getName(), (boolean)false, (int)2, null)) {
            RunConfiguration configuration2 = this.getConfiguration();
            this.uniqueId = result2 = Companion.getUniqueIdFor(configuration2);
        }
        return result2;
    }

    public void setEditBeforeRun(boolean value) {
        this.isEditBeforeRun = value;
    }

    public boolean isEditBeforeRun() {
        return this.isEditBeforeRun;
    }

    public void setActivateToolWindowBeforeRun(boolean value) {
        this.isActivateToolWindowBeforeRun = value;
    }

    public boolean isActivateToolWindowBeforeRun() {
        return this.isActivateToolWindowBeforeRun;
    }

    public void setFolderName(@Nullable String value) {
        this.folderName = value;
    }

    @Nullable
    public String getFolderName() {
        return this.folderName;
    }

    /*
     * Unable to fully structure code
     */
    public final void readExternal(@NotNull Element element, boolean isShared) {
        this.isTemplate = JdomKt.getAttributeBooleanValue((Element)element, (String)"default");
        this.level = isShared != false ? RunConfigurationLevel.PROJECT : (JdomKt.getAttributeBooleanValue((Element)element, (String)"temporary") != false || Intrinsics.areEqual((Object)"tempConfiguration", (Object)element.getName()) != false ? RunConfigurationLevel.TEMPORARY : RunConfigurationLevel.WORKSPACE);
        this.isEditBeforeRun = JdomKt.getAttributeBooleanValue((Element)element, (String)"editBeforeRun");
        value = element.getAttributeValue("activateToolWindowBeforeRun");
        v0 = this;
        if (value == null) ** GOTO lbl-1000
        var4_4 = value;
        var10_5 = v0;
        var11_6 = Boolean.parseBoolean(var4_4);
        v0 = var10_5;
        if (var11_6) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        v0.isActivateToolWindowBeforeRun = v1;
        this.folderName = element.getAttributeValue("folderName");
        v2 = this.manager.getFactory(element.getAttributeValue("type"), element.getAttributeValue("factoryName"), this.isTemplate == false);
        if (v2 == null) {
            return;
        }
        factory = v2;
        configuration = factory.createTemplateConfiguration(this.manager.getProject(), (RunManager)this.manager);
        if (!this.isTemplate) {
            v3 = element.getAttributeValue("name");
            if (v3 == null) {
                return;
            }
            configuration.setName(v3);
        }
        this._configuration = configuration;
        this.uniqueId = null;
        PathMacroManager.getInstance((ComponentManager)configuration.getProject()).expandPaths(element);
        if (configuration instanceof ModuleBasedConfiguration && ((ModuleBasedConfiguration)configuration).isModuleDirMacroSupported()) {
            v4 = element.getChild("module");
            v5 = moduleName = v4 != null ? v4.getAttributeValue("name") : null;
            if (moduleName != null) {
                v6 = ((ModuleBasedConfiguration)configuration).getConfigurationModule().findModule(moduleName);
                if (v6 != null) {
                    it = var7_9 = v6;
                    $i$a$-let-RunnerAndConfigurationSettingsImpl$readExternal$1 = false;
                    PathMacroManager.getInstance((ComponentManager)it).expandPaths(element);
                }
            }
        }
        RunnerAndConfigurationSettingsImplKt.deserializeConfigurationFrom(configuration, element, this.isTemplate);
        this.wasSingletonSpecifiedExplicitly = false;
        singletonStr = element.getAttributeValue("singleton");
        var7_9 = singletonStr;
        if (var7_9 == null || var7_9.length() == 0) {
            configuration.setAllowRunningInParallel(factory.getSingletonPolicy().isAllowRunningInParallel());
        } else {
            this.wasSingletonSpecifiedExplicitly = true;
            var7_9 = singletonStr;
            var10_5 = configuration;
            var11_6 = Boolean.parseBoolean((String)var7_9);
            var10_5.setAllowRunningInParallel(var11_6 == false);
        }
        this.runnerSettings.loadState(element);
        this.configurationPerRunnerSettings.loadState(element);
        this.manager.readBeforeRunTasks$intellij_platform_lang_impl(element.getChild("method"), this, configuration);
    }

    public final void writeExternal(@NotNull Element element) {
        String string;
        CharSequence charSequence;
        ConfigurationFactory factory;
        String it;
        RunConfiguration configuration2 = this.getConfiguration();
        if (configuration2.getType().isManaged()) {
            if (this.isTemplate) {
                element.setAttribute("default", "true");
            } else {
                if (!RunnerAndConfigurationSettingsImplKt.access$isNewSerializationAllowed$p(this)) {
                    element.setAttribute("default", "false");
                }
                String string2 = StringKt.nullize$default((String)configuration2.getName(), (boolean)false, (int)1, null);
                if (string2 != null) {
                    String string3;
                    it = string3 = string2;
                    boolean bl = false;
                    element.setAttribute("name", it);
                }
            }
            factory = this.getFactory();
            element.setAttribute("type", factory.getType().getId());
            if (!(factory.getType() instanceof SimpleConfigurationType)) {
                element.setAttribute("factoryName", factory.getId());
            }
            if (this.folderName != null) {
                String string4 = this.folderName;
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                element.setAttribute("folderName", string4);
            }
            if (this.isEditBeforeRun) {
                element.setAttribute("editBeforeRun", "true");
            }
            if (!this.isActivateToolWindowBeforeRun) {
                element.setAttribute("activateToolWindowBeforeRun", "false");
            }
            if (this.wasSingletonSpecifiedExplicitly || configuration2.isAllowRunningInParallel() != factory.getSingletonPolicy().isAllowRunningInParallel()) {
                element.setAttribute("singleton", String.valueOf(!configuration2.isAllowRunningInParallel()));
            }
            if (this.isTemporary()) {
                element.setAttribute("temporary", "true");
            }
        }
        RunnerAndConfigurationSettingsImplKt.serializeConfigurationInto(configuration2, element);
        if (configuration2.getType().isManaged()) {
            this.runnerSettings.getState(element);
            this.configurationPerRunnerSettings.getState(element);
        }
        if (configuration2.getType().isManaged()) {
            Element element2 = this.manager.writeBeforeRunTasks$intellij_platform_lang_impl(configuration2);
            if (element2 != null) {
                factory = element2;
                it = factory;
                boolean bl = false;
                element.addContent((Element)it);
            }
        }
        if (configuration2 instanceof ModuleBasedConfiguration && ((ModuleBasedConfiguration)configuration2).isModuleDirMacroSupported()) {
            Module module = ((ModuleBasedConfiguration)configuration2).getConfigurationModule().getModule();
            if (module != null) {
                factory = module;
                it = factory;
                boolean bl = false;
                PathMacroManager.getInstance((ComponentManager)it).collapsePathsRecursively(element);
            }
        }
        Project project = configuration2.getProject();
        PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)project);
        String string5 = project.getBasePath();
        if (string5 != null) {
            charSequence = string5;
            String it2 = charSequence;
            boolean bl = false;
            string = PathUtilRt.getParentPath((String)it2);
        } else {
            string = null;
        }
        String projectParentPath = string;
        charSequence = projectParentPath;
        if (!(charSequence == null || charSequence.length() == 0)) {
            ReplacePathToMacroMap replacePathMap;
            PathMacroManager pathMacroManager = macroManager;
            if (!(pathMacroManager instanceof ProjectPathMacroManager)) {
                pathMacroManager = null;
            }
            ProjectPathMacroManager projectPathMacroManager = (ProjectPathMacroManager)pathMacroManager;
            ReplacePathToMacroMap replacePathToMacroMap = replacePathMap = projectPathMacroManager != null ? projectPathMacroManager.getReplacePathMap() : null;
            if (replacePathMap != null) {
                char c = '$';
                String string6 = "PROJECT_DIR";
                StringBuilder stringBuilder = new StringBuilder();
                String string7 = projectParentPath;
                ReplacePathToMacroMap replacePathToMacroMap2 = replacePathMap;
                String string8 = String.valueOf(c) + string6;
                replacePathToMacroMap2.addReplacement(string7, stringBuilder.append(string8).append("$/..").toString(), true);
                PathMacroManager.collapsePaths(element, true, replacePathMap);
                return;
            }
        }
        PathMacroManager.getInstance((ComponentManager)project).collapsePathsRecursively(element);
    }

    @Override
    @NotNull
    public Element writeScheme() {
        Element element = new Element("configuration");
        this.writeExternal(element);
        return element;
    }

    public void checkSettings(@Nullable Executor executor) {
        RuntimeConfigurationWarning runtimeConfigurationWarning;
        RunConfiguration configuration2 = this.getConfiguration();
        RuntimeConfigurationWarning warning = null;
        RunnerAndConfigurationSettingsImpl this_$iv = this;
        boolean $i$f$doCheck = false;
        try {
            boolean bl = false;
            configuration2.checkConfiguration();
            runtimeConfigurationWarning = null;
        }
        catch (RuntimeConfigurationWarning ex$iv) {
            runtimeConfigurationWarning = warning = ex$iv;
        }
        if (!(configuration2 instanceof RunConfigurationBase)) {
            if (warning != null) {
                throw (Throwable)warning;
            }
            return;
        }
        THashSet runners = new THashSet();
        runners.addAll((Collection)this.runnerSettings.getSettings().keySet());
        runners.addAll((Collection)this.configurationPerRunnerSettings.getSettings().keySet());
        for (ProgramRunner runner : runners) {
            RuntimeConfigurationWarning runnerWarning;
            RuntimeConfigurationWarning runtimeConfigurationWarning2;
            if (executor != null && !runner.canRun(executor.getId(), (RunProfile)configuration2)) continue;
            RunnerAndConfigurationSettingsImpl this_$iv2 = this;
            boolean $i$f$doCheck2 = false;
            try {
                boolean bl = false;
                ((RunConfigurationBase)configuration2).checkRunnerSettings(runner, (RunnerSettings)this.runnerSettings.getSettings().get((Object)runner), (ConfigurationPerRunnerSettings)this.configurationPerRunnerSettings.getSettings().get((Object)runner));
                runtimeConfigurationWarning2 = null;
            }
            catch (RuntimeConfigurationWarning ex$iv) {
                runtimeConfigurationWarning2 = runnerWarning = ex$iv;
            }
            if (warning != null || runnerWarning == null) continue;
            warning = runnerWarning;
        }
        if (executor != null) {
            RuntimeConfigurationWarning beforeRunWarning;
            RuntimeConfigurationWarning runtimeConfigurationWarning3;
            RunnerAndConfigurationSettingsImpl this_$iv3 = this;
            boolean $i$f$doCheck3 = false;
            try {
                boolean bl = false;
                ((RunConfigurationBase)configuration2).checkSettingsBeforeRun();
                runtimeConfigurationWarning3 = null;
            }
            catch (RuntimeConfigurationWarning ex$iv) {
                runtimeConfigurationWarning3 = beforeRunWarning = ex$iv;
            }
            if (warning == null && beforeRunWarning != null) {
                warning = beforeRunWarning;
            }
        }
        if (warning != null) {
            throw (Throwable)warning;
        }
    }

    private final RuntimeConfigurationWarning doCheck(Function0<Unit> check) {
        int $i$f$doCheck = 0;
        try {
            check.invoke();
            return null;
        }
        catch (RuntimeConfigurationWarning ex) {
            return ex;
        }
    }

    @Nullable
    public RunnerSettings getRunnerSettings(@NotNull ProgramRunner<?> runner) {
        return (RunnerSettings)this.runnerSettings.getOrCreateSettings(runner);
    }

    @Nullable
    public ConfigurationPerRunnerSettings getConfigurationSettings(@NotNull ProgramRunner<?> runner) {
        return (ConfigurationPerRunnerSettings)this.configurationPerRunnerSettings.getOrCreateSettings(runner);
    }

    @NotNull
    public ConfigurationType getType() {
        return this.getFactory().getType();
    }

    @NotNull
    public RunnerAndConfigurationSettingsImpl clone() {
        RunConfiguration runConfiguration = this._configuration;
        if (runConfiguration == null) {
            Intrinsics.throwNpe();
        }
        RunnerAndConfigurationSettingsImpl copy = new RunnerAndConfigurationSettingsImpl(this.manager, runConfiguration.clone(), false, null, 12, null);
        copy.importRunnerAndConfigurationSettings$intellij_platform_lang_impl(this);
        return copy;
    }

    public final void importRunnerAndConfigurationSettings$intellij_platform_lang_impl(@NotNull RunnerAndConfigurationSettingsImpl template) {
        this.importFromTemplate(template.runnerSettings, this.runnerSettings);
        this.importFromTemplate(template.configurationPerRunnerSettings, this.configurationPerRunnerSettings);
        this.isEditBeforeRun = template.isEditBeforeRun;
        this.isActivateToolWindowBeforeRun = template.isActivateToolWindowBeforeRun;
        this.level = template.level;
    }

    private final <T> void importFromTemplate(RunnerItem<T> templateItem, RunnerItem<T> item) {
        for (ProgramRunner runner : templateItem.getSettings().keySet()) {
            T data = item.createSettings(runner);
            item.getSettings().put((Object)runner, data);
            if (data == null) continue;
            Element temp = new Element("dummy");
            if (templateItem.getSettings().get((Object)runner) == null) {
                continue;
            }
            try {
                Object templateSettings;
                Object object = templateSettings;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.JDOMExternalizable");
                }
                ((JDOMExternalizable)object).writeExternal(temp);
                ((JDOMExternalizable)data).readExternal(temp);
            }
            catch (WriteExternalException e) {
                RunManagerImpl.Companion.getLOG$intellij_platform_lang_impl().error((Throwable)e);
            }
            catch (InvalidDataException e) {
                RunManagerImpl.Companion.getLOG$intellij_platform_lang_impl().error((Throwable)e);
            }
        }
    }

    @Override
    public int compareTo(@NotNull Object other) {
        return other instanceof RunnerAndConfigurationSettings ? this.getName().compareTo(((RunnerAndConfigurationSettings)other).getName()) : 0;
    }

    @NotNull
    public String toString() {
        return this.getType().getDisplayName() + ": " + (this.isTemplate ? "<template>" : this.getName()) + " (level: " + (Object)((Object)this.level) + ')';
    }

    @Override
    @Nullable
    public SchemeState getSchemeState() {
        RunConfiguration configuration2 = this._configuration;
        return configuration2 == null ? SchemeState.UNCHANGED : (configuration2 instanceof UnknownRunConfiguration ? (((UnknownRunConfiguration)configuration2).isDoNotStore() ? SchemeState.NON_PERSISTENT : SchemeState.UNCHANGED) : (!configuration2.getType().isManaged() ? SchemeState.NON_PERSISTENT : null));
    }

    public final boolean needsToBeMigrated() {
        RunConfiguration runConfiguration = this._configuration;
        if (!(runConfiguration instanceof PersistentAwareRunConfiguration)) {
            runConfiguration = null;
        }
        PersistentAwareRunConfiguration persistentAwareRunConfiguration = (PersistentAwareRunConfiguration)runConfiguration;
        return persistentAwareRunConfiguration != null ? persistentAwareRunConfiguration.needsToBeMigrated() : false;
    }

    @NotNull
    public final RunManagerImpl getManager() {
        return this.manager;
    }

    @NotNull
    public final RunConfigurationLevel getLevel() {
        return this.level;
    }

    public final void setLevel(@NotNull RunConfigurationLevel runConfigurationLevel) {
        this.level = runConfigurationLevel;
    }

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager, @Nullable RunConfiguration _configuration, boolean isTemplate, @NotNull RunConfigurationLevel level) {
        this.manager = manager;
        this._configuration = _configuration;
        this.isTemplate = isTemplate;
        this.level = level;
        RunConfiguration runConfiguration = this._configuration;
        if (!(runConfiguration instanceof PersistentAwareRunConfiguration)) {
            runConfiguration = null;
        }
        PersistentAwareRunConfiguration persistentAwareRunConfiguration = (PersistentAwareRunConfiguration)runConfiguration;
        if (persistentAwareRunConfiguration != null) {
            persistentAwareRunConfiguration.setTemplate(this.isTemplate);
        }
        this.runnerSettings = new RunnerItem<RunnerSettings>(this, "RunnerSettings"){
            final /* synthetic */ RunnerAndConfigurationSettingsImpl this$0;

            @Nullable
            public RunnerSettings createSettings(@NotNull ProgramRunner<?> runner) {
                return runner.createConfigurationData((ConfigurationInfoProvider)this.this$0.new InfoProvider(runner));
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        this.configurationPerRunnerSettings = new RunnerItem<ConfigurationPerRunnerSettings>(this, "ConfigurationWrapper"){
            final /* synthetic */ RunnerAndConfigurationSettingsImpl this$0;

            @Nullable
            public ConfigurationPerRunnerSettings createSettings(@NotNull ProgramRunner<?> runner) {
                return this.this$0.getConfiguration().createRunnerSettings((ConfigurationInfoProvider)this.this$0.new InfoProvider(runner));
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        this.isActivateToolWindowBeforeRun = true;
    }

    @JvmOverloads
    public /* synthetic */ RunnerAndConfigurationSettingsImpl(RunManagerImpl runManagerImpl, RunConfiguration runConfiguration, boolean bl, RunConfigurationLevel runConfigurationLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            runConfiguration = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            runConfigurationLevel = RunConfigurationLevel.WORKSPACE;
        }
        this(runManagerImpl, runConfiguration, bl, runConfigurationLevel);
    }

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager, @Nullable RunConfiguration _configuration, boolean isTemplate) {
        this(manager, _configuration, isTemplate, null, 8, null);
    }

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager, @Nullable RunConfiguration _configuration) {
        this(manager, _configuration, false, null, 12, null);
    }

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager) {
        this(manager, null, false, null, 14, null);
    }

    @Deprecated(message="isSingleton parameter removed", level=DeprecationLevel.ERROR)
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager, @NotNull RunConfiguration configuration2, boolean isTemplate, boolean isSingleton) {
        this(manager, configuration2, isTemplate, null, 8, null);
    }

    @JvmStatic
    @NotNull
    public static final String getUniqueIdFor(@NotNull RunConfiguration configuration2) {
        return Companion.getUniqueIdFor(configuration2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$InfoProvider;", "Lcom/intellij/execution/configurations/ConfigurationInfoProvider;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "(Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;Lcom/intellij/execution/runners/ProgramRunner;)V", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "getConfiguration", "()Lcom/intellij/execution/configurations/RunConfiguration;", "configurationSettings", "Lcom/intellij/execution/configurations/ConfigurationPerRunnerSettings;", "getConfigurationSettings", "()Lcom/intellij/execution/configurations/ConfigurationPerRunnerSettings;", "getRunner", "()Lcom/intellij/execution/runners/ProgramRunner;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "getRunnerSettings", "()Lcom/intellij/execution/configurations/RunnerSettings;", "intellij.platform.lang.impl"})
    private final class InfoProvider
    implements ConfigurationInfoProvider {
        @NotNull
        private final ProgramRunner<?> runner;

        @NotNull
        public RunConfiguration getConfiguration() {
            return RunnerAndConfigurationSettingsImpl.this.getConfiguration();
        }

        @Nullable
        public RunnerSettings getRunnerSettings() {
            return RunnerAndConfigurationSettingsImpl.this.getRunnerSettings(this.getRunner());
        }

        @Nullable
        public ConfigurationPerRunnerSettings getConfigurationSettings() {
            return RunnerAndConfigurationSettingsImpl.this.getConfigurationSettings(this.getRunner());
        }

        @NotNull
        public ProgramRunner<?> getRunner() {
            return this.runner;
        }

        public InfoProvider(ProgramRunner<?> runner) {
            this.runner = runner;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\b\u00a2\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J-\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\b\u0010\u0014\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0016\u001a\u0004\u0018\u00018\u00002\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\nH&\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0019\u0010\u001a\u001a\u0004\u0018\u00018\u00002\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u000fJ\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$RunnerItem;", "T", "", "childTagName", "", "(Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;Ljava/lang/String;)V", "loadedIds", "Lgnu/trove/THashSet;", "settings", "Lgnu/trove/THashMap;", "Lcom/intellij/execution/runners/ProgramRunner;", "getSettings", "()Lgnu/trove/THashMap;", "unloadedSettings", "", "Lorg/jdom/Element;", "add", "", "state", "runner", "data", "(Lorg/jdom/Element;Lcom/intellij/execution/runners/ProgramRunner;Ljava/lang/Object;)V", "createSettings", "(Lcom/intellij/execution/runners/ProgramRunner;)Ljava/lang/Object;", "findRunner", "runnerId", "getOrCreateSettings", "getState", "element", "loadState", "intellij.platform.lang.impl"})
    private abstract class RunnerItem<T> {
        @NotNull
        private final THashMap<ProgramRunner<?>, T> settings;
        private List<Element> unloadedSettings;
        private final THashSet<String> loadedIds;
        private final String childTagName;

        @NotNull
        public final THashMap<ProgramRunner<?>, T> getSettings() {
            return this.settings;
        }

        public final void loadState(@NotNull Element element) {
            this.settings.clear();
            if (this.unloadedSettings != null) {
                List<Element> list2 = this.unloadedSettings;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                list2.clear();
            }
            this.loadedIds.clear();
            Iterator iterator = element.getChildren(this.childTagName).iterator();
            while (iterator.hasNext()) {
                Element state = (Element)iterator.next();
                ProgramRunner<?> runner = this.findRunner(state.getAttributeValue("RunnerId"));
                if (runner == null) {
                    iterator.remove();
                }
                this.add(state, runner, runner == null ? null : (T)this.createSettings(runner));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final ProgramRunner<?> findRunner(String runnerId) {
            ProgramRunner programRunner;
            Object it;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)ProgramRunner.PROGRAM_RUNNER_EP.getExtensionList();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (ProgramRunner)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)runnerId, (Object)it.getRunnerId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List runnersById = (List)destination$iv$iv;
            if (runnersById.isEmpty()) {
                programRunner = null;
            } else if (runnersById.size() == 1) {
                programRunner = (ProgramRunner)CollectionsKt.firstOrNull((List)runnersById);
            } else {
                RunManagerImpl.Companion.getLOG$intellij_platform_lang_impl().error("More than one runner found for ID: " + runnerId);
                for (Executor executor : ExecutorRegistry.getInstance().getRegisteredExecutors()) {
                    Object v1;
                    block7: {
                        Iterable $receiver$iv2 = runnersById;
                        for (Object element$iv : $receiver$iv2) {
                            ProgramRunner it2 = (ProgramRunner)element$iv;
                            boolean bl = false;
                            if (!it2.canRun(executor.getId(), (RunProfile)RunnerAndConfigurationSettingsImpl.this.getConfiguration())) continue;
                            v1 = element$iv;
                            break block7;
                        }
                        v1 = null;
                    }
                    ProgramRunner programRunner2 = v1;
                    if (programRunner2 == null) continue;
                    ProgramRunner programRunner3 = programRunner2;
                    it = programRunner3;
                    boolean bl = false;
                    return it;
                }
                programRunner = null;
            }
            return programRunner;
        }

        /*
         * WARNING - void declaration
         */
        public final void getState(@NotNull Element element) {
            SmartList runnerSettings2 = new SmartList();
            for (ProgramRunner runner : this.settings.keySet()) {
                Object settings = this.settings.get((Object)runner);
                boolean wasLoaded = this.loadedIds.contains((Object)runner.getRunnerId());
                if (settings == null && !wasLoaded) continue;
                Element state = new Element(this.childTagName);
                if (settings != null) {
                    ((JDOMExternalizable)settings).writeExternal(state);
                }
                if (!wasLoaded && JDOMUtil.isEmpty((Element)state)) continue;
                state.setAttribute("RunnerId", runner.getRunnerId());
                runnerSettings2.add((Object)state);
            }
            List<Element> list2 = this.unloadedSettings;
            if (list2 != null) {
                Iterable $receiver$iv = list2;
                for (Object item$iv : $receiver$iv) {
                    void it;
                    Element wasLoaded = (Element)item$iv;
                    Collection collection = (Collection)runnerSettings2;
                    boolean bl = false;
                    Element element2 = it.clone();
                    collection.add(element2);
                }
                SmartList cfr_ignored_0 = (SmartList)((Collection)runnerSettings2);
            }
            CollectionsKt.sortWith((List)((List)runnerSettings2), (Comparator)getState.2.INSTANCE);
            for (Element runnerSetting : runnerSettings2) {
                element.addContent(runnerSetting);
            }
        }

        @Nullable
        public abstract T createSettings(@NotNull ProgramRunner<?> var1);

        private final void add(Element state, ProgramRunner<?> runner, T data) {
            if (runner == null) {
                if (this.unloadedSettings == null) {
                    this.unloadedSettings = (List)new SmartList();
                }
                List<Element> list2 = this.unloadedSettings;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                list2.add(JDOMUtil.internElement((Element)state));
                return;
            }
            if (data != null) {
                ((JDOMExternalizable)data).readExternal(state);
            }
            this.settings.put(runner, data);
            this.loadedIds.add((Object)runner.getRunnerId());
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final T getOrCreateSettings(@NotNull ProgramRunner<?> runner) {
            try {
                T t;
                Map $receiver$iv = (Map)this.settings;
                Object value$iv = $receiver$iv.get(runner);
                if (value$iv == null) {
                    boolean bl = false;
                    T answer$iv = this.createSettings(runner);
                    $receiver$iv.put(runner, answer$iv);
                    t = answer$iv;
                } else {
                    void var3_4;
                    t = var3_4;
                }
                return t;
            }
            catch (AbstractMethodError e) {
                PluginException.logPluginError((Logger)RunManagerImpl.Companion.getLOG$intellij_platform_lang_impl(), (String)("Update failed for: " + RunnerAndConfigurationSettingsImpl.this.getConfiguration().getType().getDisplayName() + ", runner: " + runner.getRunnerId()), (Throwable)e, runner.getClass());
                return null;
            }
        }

        public RunnerItem(String childTagName) {
            this.childTagName = childTagName;
            this.settings = new THashMap();
            this.loadedIds = new THashSet();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$Companion;", "", "()V", "getUniqueIdFor", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final String getUniqueIdFor(@NotNull RunConfiguration configuration2) {
            ConfigurationType type = configuration2.getType();
            if (!type.isManaged()) {
                String string = configuration2.getId();
                if (string != null) {
                    String string2;
                    String it = string2 = string;
                    boolean bl = false;
                    return it;
                }
            }
            StringBuilder stringBuilder = new StringBuilder().append(configuration2.getType().getDisplayName()).append('.').append(configuration2.getName());
            RunConfiguration runConfiguration = configuration2;
            if (!(runConfiguration instanceof UnknownRunConfiguration)) {
                runConfiguration = null;
            }
            UnknownRunConfiguration unknownRunConfiguration = (UnknownRunConfiguration)runConfiguration;
            return stringBuilder.append(unknownRunConfiguration != null ? Integer.valueOf(unknownRunConfiguration.getUniqueID()) : "").toString();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

