/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl.statistics;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRunConfigurationTypeUsagesCollector
extends ProjectUsagesCollector {
    private static final String DEFAULT_ID = "third.party";

    protected abstract boolean isApplicable(@NotNull RunManager var1, @NotNull RunnerAndConfigurationSettings var2);

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        TObjectIntHashMap templates = new TObjectIntHashMap();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project.isDisposed()) {
                return;
            }
            RunManager runManager = RunManager.getInstance((Project)project);
            for (RunnerAndConfigurationSettings settings : runManager.getAllSettings()) {
                FeatureUsageData data;
                String key;
                ConfigurationFactory configurationFactory;
                RunConfiguration runConfiguration = settings.getConfiguration();
                if (!this.isApplicable(runManager, settings) || (configurationFactory = runConfiguration.getFactory()) == null || !StringUtil.isNotEmpty((String)(key = AbstractRunConfigurationTypeUsagesCollector.toReportedId(configurationFactory, data = new FeatureUsageData())))) continue;
                Template template = new Template(key, AbstractRunConfigurationTypeUsagesCollector.addContext(data, settings, runConfiguration));
                if (templates.containsKey((Object)template)) {
                    templates.increment((Object)template);
                    continue;
                }
                templates.put((Object)template, 1);
            }
        });
        HashSet<UsageDescriptor> result2 = new HashSet<UsageDescriptor>();
        templates.forEachEntry((template, value) -> result2.add(((Template)template).createUsageDescriptor(value)));
        return result2;
    }

    @Nullable
    public static String toReportedId(@NotNull ConfigurationFactory factory, @NotNull FeatureUsageData data) {
        ConfigurationType configurationType = factory.getType();
        if (configurationType instanceof UnknownConfigurationType) {
            return null;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(configurationType.getClass());
        data.addPluginInfo(info);
        if (!info.isDevelopedByJetBrains()) {
            return DEFAULT_ID;
        }
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(configurationType.getId());
        if (configurationType.getConfigurationFactories().length > 1) {
            keyBuilder.append(".").append(factory.getId());
        }
        return keyBuilder.toString();
    }

    private static FeatureUsageData addContext(@NotNull FeatureUsageData data, @NotNull RunnerAndConfigurationSettings settings, @NotNull RunConfiguration runConfiguration) {
        return data.addData("shared", settings.isShared()).addData("edit_before_run", settings.isEditBeforeRun()).addData("activate_before_run", settings.isActivateToolWindowBeforeRun()).addData("parallel", runConfiguration.isAllowRunningInParallel());
    }

    private static class Template {
        private final String myKey;
        private final FeatureUsageData myData;

        private Template(String key, FeatureUsageData data) {
            this.myKey = key;
            this.myData = data;
        }

        private UsageDescriptor createUsageDescriptor(int count) {
            return new UsageDescriptor(this.myKey, count, this.myData);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template template = (Template)o;
            return Objects.equals(this.myKey, template.myKey) && Objects.equals(this.myData, template.myData);
        }

        public int hashCode() {
            return Objects.hash(this.myKey, this.myData);
        }
    }
}

