/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jna.Platform;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerMediator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.process.RunnerMediator");
    private static final char IAC = '\u0005';
    private static final char BRK = '\u0003';
    private static final char C = '\u0005';
    private static final String RUNNERW = "runnerw.exe";
    private static final String RUNNERW_64 = "runnerw64.exe";
    private static final String IDEA_RUNNERW = "IDEA_RUNNERW";

    public static RunnerMediator getInstance() {
        return new RunnerMediator();
    }

    private static void sendCtrlEventThroughStream(@NotNull Process process2, char event) {
        OutputStream os = process2.getOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.print('\u0005');
        pw.print(event);
        pw.flush();
    }

    public ProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        return this.createProcess(commandLine, false);
    }

    public ProcessHandler createProcess(@NotNull GeneralCommandLine commandLine, boolean useSoftKill) throws ExecutionException {
        if (SystemInfo.isWindows) {
            RunnerMediator.injectRunnerCommand(commandLine, false);
        }
        return new CustomDestroyProcessHandler(commandLine, useSoftKill);
    }

    @Nullable
    private static String getRunnerPath() {
        String[] names;
        String[] stringArray;
        if (!SystemInfo.isWindows) {
            throw new IllegalStateException("There is no need of runner under unix based OS");
        }
        String path = System.getenv(IDEA_RUNNERW);
        if (path != null) {
            if (new File(path).exists()) {
                return path;
            }
            LOG.warn("Cannot locate runnerw.exe by IDEA_RUNNERW=" + path);
        }
        if (Platform.is64Bit()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = RUNNERW_64;
            stringArray = stringArray2;
            stringArray2[1] = RUNNERW;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = RUNNERW;
        }
        for (String name : names = stringArray) {
            File runnerw = PathManager.findBinFile((String)name);
            if (runnerw == null || !runnerw.exists()) continue;
            return runnerw.getPath();
        }
        LOG.warn("Cannot locate runnerw.exe in " + PathManager.getBinPath());
        return null;
    }

    static boolean injectRunnerCommand(@NotNull GeneralCommandLine commandLine, boolean showConsole) {
        String path = RunnerMediator.getRunnerPath();
        if (path != null) {
            commandLine.getParametersList().addAt(0, commandLine.getExePath());
            if (showConsole) {
                commandLine.getParametersList().addAt(0, "/C");
            }
            commandLine.setExePath(path);
            return true;
        }
        return false;
    }

    public static boolean destroyProcess(@NotNull Process process2) {
        return RunnerMediator.destroyProcess(process2, false);
    }

    static boolean destroyProcess(@NotNull Process process2, boolean softKill) {
        try {
            if (SystemInfo.isWindows) {
                RunnerMediator.sendCtrlEventThroughStream(process2, softKill ? (char)'\u0005' : '\u0003');
                return true;
            }
            if (SystemInfo.isUnix) {
                if (softKill) {
                    return UnixProcessManager.sendSigIntToProcessTree((Process)process2);
                }
                return UnixProcessManager.sendSigKillToProcessTree((Process)process2);
            }
            return false;
        }
        catch (Exception e) {
            LOG.error("Couldn't terminate the process", (Throwable)e);
            return false;
        }
    }

    public static class CustomDestroyProcessHandler
    extends ColoredProcessHandler {
        private final boolean mySoftKill;

        @Deprecated
        public CustomDestroyProcessHandler(@NotNull Process process2, @NotNull GeneralCommandLine commandLine) {
            super(process2, commandLine.getCommandLineString());
            this.mySoftKill = false;
        }

        public CustomDestroyProcessHandler(@NotNull GeneralCommandLine commandLine, boolean softKill) throws ExecutionException {
            super(commandLine);
            this.mySoftKill = softKill;
        }

        protected boolean shouldDestroyProcessRecursively() {
            return true;
        }

        @Override
        protected void destroyProcessImpl() {
            if (!RunnerMediator.destroyProcess(this.getProcess(), this.mySoftKill)) {
                super.destroyProcessImpl();
            }
        }
    }
}

