/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.startup.ProjectStartupTaskManager;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ProjectStartupRunner
implements StartupActivity,
DumbAware {
    public static final int DELAY_MILLIS = 200;

    public void runActivity(@NotNull Project project) {
        final ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(project);
        if (projectStartupTaskManager.isEmpty()) {
            return;
        }
        project.getMessageBus().connect().subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                projectStartupTaskManager.delete(settings.getUniqueID());
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings, String existingId) {
                if (existingId != null) {
                    projectStartupTaskManager.rename(existingId, settings);
                }
                projectStartupTaskManager.checkOnChange(settings);
            }

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                projectStartupTaskManager.checkOnChange(settings);
            }
        });
        ProjectStartupRunner.scheduleRunActivities(project);
    }

    private static void scheduleRunActivities(@NotNull Project project) {
        JobScheduler.getScheduler().schedule(() -> {
            if (!((StartupManagerEx)StartupManager.getInstance((Project)project)).postStartupActivityPassed()) {
                ProjectStartupRunner.scheduleRunActivities(project);
            } else {
                ProjectStartupRunner.runActivities(project);
            }
        }, 200L, TimeUnit.MILLISECONDS);
    }

    private static void runActivities(Project project) {
        ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(project);
        ArrayList<RunnerAndConfigurationSettings> configurations = new ArrayList<RunnerAndConfigurationSettings>(projectStartupTaskManager.getLocalConfigurations());
        configurations.addAll(projectStartupTaskManager.getSharedConfigurations());
        ApplicationManager.getApplication().invokeLater(() -> {
            long pause = 0L;
            Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
            Executor executor = DefaultRunExecutor.getRunExecutorInstance();
            for (RunnerAndConfigurationSettings configuration2 : configurations) {
                if (!ProjectStartupRunner.canBeRun(configuration2)) {
                    ProjectStartupRunner.showNotification(project, "Run Configuration '" + configuration2.getName() + "' can not be started with 'Run' action.", MessageType.ERROR);
                    return;
                }
                try {
                    alarm.addRequest((Runnable)new MyExecutor(executor, configuration2, alarm), pause);
                }
                catch (ExecutionException e) {
                    ProjectStartupRunner.showNotification(project, e.getMessage(), MessageType.ERROR);
                }
                pause = 300L;
            }
        }, project.getDisposed());
    }

    private static void showNotification(Project project, String text, MessageType type) {
        ProjectStartupTaskManager.NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  " + text, type).notify(project);
    }

    public static boolean canBeRun(@NotNull RunnerAndConfigurationSettings configuration2) {
        return ProgramRunner.getRunner((String)DefaultRunExecutor.EXECUTOR_ID, (RunProfile)configuration2.getConfiguration()) != null;
    }

    private static class MyExecutor
    implements Runnable {
        public static final int ATTEMPTS = 10;
        private final ExecutionEnvironment myEnvironment;
        @NotNull
        private final Alarm myAlarm;
        private final Project myProject;
        private int myCnt = 10;
        private static final long PAUSE = 300L;
        private final String myName;

        MyExecutor(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings configuration2, @NotNull Alarm alarm) throws ExecutionException {
            this.myName = configuration2.getName();
            this.myProject = configuration2.getConfiguration().getProject();
            this.myAlarm = alarm;
            this.myEnvironment = ExecutionEnvironmentBuilder.create((Executor)executor, (RunnerAndConfigurationSettings)configuration2).contentToReuse(null).dataContext(null).activeTarget().build();
        }

        @Override
        public void run() {
            if (ExecutorRegistry.getInstance().isStarting(this.myEnvironment)) {
                if (this.myCnt <= 0) {
                    ProjectStartupRunner.showNotification(this.myProject, "'" + this.myName + "' not started after " + 10 + " attempts.", MessageType.ERROR);
                    return;
                }
                --this.myCnt;
                this.myAlarm.addRequest((Runnable)this, 300L);
            }
            ProjectStartupTaskManager.NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  starting '" + this.myName + "'", MessageType.INFO).notify(this.myProject);
            ProgramRunnerUtil.executeConfiguration(this.myEnvironment, true, true);
            if (this.myAlarm.isEmpty()) {
                Disposer.dispose((Disposable)this.myAlarm);
            }
        }
    }
}

