/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public interface Printer {
    public void print(String var1, ConsoleViewContentType var2);

    public void onNewAvailable(@NotNull Printable var1);

    public void printHyperlink(String var1, HyperlinkInfo var2);

    public void mark();

    default public void printWithAnsiColoring(@NotNull String text, @NotNull Key processOutputType) {
        if (processOutputType != ProcessOutputTypes.STDERR && processOutputType != ProcessOutputTypes.STDOUT && processOutputType != ProcessOutputTypes.SYSTEM) {
            this.print(text, ConsoleViewContentType.getConsoleViewType((Key)processOutputType));
            return;
        }
        new AnsiEscapeDecoder().escapeText(text, processOutputType, (text1, attributes) -> this.print(text1, ConsoleViewContentType.getConsoleViewType((Key)attributes)));
    }
}

