/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDiffRequestProcessor
extends DiffRequestProcessor {
    @NotNull
    private final List<? extends DiffHyperlink> myRequests;
    private int myIndex;

    public TestDiffRequestProcessor(@Nullable Project project, @NotNull List<? extends DiffHyperlink> requests, int index) {
        super(project, "TestsFiledAssertions");
        this.myRequests = requests;
        this.myIndex = index;
        this.putContextUserData(DiffUserDataKeys.DO_NOT_IGNORE_WHITESPACES, true);
    }

    @Override
    public void updateRequest(boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        this.applyRequest(this.loadRequest(), force, scrollToChangePolicy);
    }

    @NotNull
    private DiffRequest loadRequest() {
        if (this.myIndex < 0 || this.myIndex >= this.myRequests.size()) {
            return NoDiffRequest.INSTANCE;
        }
        DiffHyperlink hyperlink = this.myRequests.get(this.myIndex);
        try {
            String windowTitle = hyperlink.getDiffTitle();
            String text1 = hyperlink.getLeft();
            String text2 = hyperlink.getRight();
            VirtualFile file1 = TestDiffRequestProcessor.findFile(hyperlink.getFilePath());
            VirtualFile file2 = TestDiffRequestProcessor.findFile(hyperlink.getActualFilePath());
            DiffContent content1 = TestDiffRequestProcessor.createContentWithTitle(this.getProject(), text1, file1, file2);
            DiffContent content2 = TestDiffRequestProcessor.createContentWithTitle(this.getProject(), text2, file2, file1);
            String title1 = TestDiffRequestProcessor.getContentTitle("diff.content.expected.title", file1);
            String title2 = TestDiffRequestProcessor.getContentTitle("diff.content.actual.title", file2);
            return new SimpleDiffRequest(windowTitle, content1, content2, title1, title2);
        }
        catch (Exception e) {
            return new ErrorDiffRequest((Throwable)e);
        }
    }

    @Nullable
    private static VirtualFile findFile(@Nullable String path) {
        return path != null ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    @NotNull
    private static DiffContent createContentWithTitle(@Nullable Project project, @NotNull String content, @Nullable VirtualFile contentFile, @Nullable VirtualFile highlightFile) {
        if (contentFile != null) {
            return DiffContentFactory.getInstance().create(project, contentFile);
        }
        return DiffContentFactory.getInstance().create(project, content, highlightFile);
    }

    @NotNull
    private static String getContentTitle(@NotNull String titleKey, @Nullable VirtualFile file2) {
        String title = ExecutionBundle.message((String)titleKey, (Object[])new Object[0]);
        if (file2 != null) {
            title = title + " (" + file2.getPresentableUrl() + ")";
        }
        return title;
    }

    @Override
    protected boolean hasNextChange() {
        return this.myIndex + 1 < this.myRequests.size();
    }

    @Override
    protected boolean hasPrevChange() {
        return this.myIndex > 0;
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        ++this.myIndex;
        if (this.myIndex >= this.myRequests.size()) {
            this.myIndex = 0;
        }
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        --this.myIndex;
        if (this.myIndex < 0) {
            this.myIndex = this.myRequests.size() - 1;
        }
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return this.myRequests.size() > 1;
    }
}

