/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.impl.DiffWindowBase;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.TestTreeViewAction;
import com.intellij.execution.testframework.actions.TestDiffRequestProcessor;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewAssertEqualsDiffAction
extends AnAction
implements TestTreeViewAction,
DumbAware {
    @NonNls
    public static final String ACTION_ID = "openAssertEqualsDiff";

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (!e.getPresentation().isVisible()) {
            return;
        }
        if (!ViewAssertEqualsDiffAction.openDiff(e.getDataContext(), null)) {
            Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
            Messages.showInfoMessage((Component)component, (String)"Comparison error was not found", (String)"No Comparison Data Found");
        }
    }

    public static boolean openDiff(DataContext context, @Nullable DiffHyperlink currentHyperlink) {
        AbstractTestProxy testProxy = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (testProxy != null && currentHyperlink == null) {
            ViewAssertEqualsDiffAction.showDiff(testProxy, (TestFrameworkRunningModel)TestTreeView.MODEL_DATA_KEY.getData(context), (providers, index) -> new MyDiffWindow(project, (List<DiffHyperlink>)providers, (int)index).show());
            return true;
        }
        if (currentHyperlink != null) {
            new MyDiffWindow(project, currentHyperlink).show();
            return true;
        }
        return false;
    }

    public static void showDiff(AbstractTestProxy testProxy, TestFrameworkRunningModel model, BiConsumer<? super List<DiffHyperlink>, ? super Integer> showFunction) {
        List<DiffHyperlink> providers = ViewAssertEqualsDiffAction.collectAvailableProviders(model);
        DiffHyperlink diffViewerProvider = testProxy.getLeafDiffViewerProvider();
        int index = diffViewerProvider != null ? providers.indexOf(diffViewerProvider) : -1;
        showFunction.accept(providers, (Integer)Math.max(0, index));
    }

    private static List<DiffHyperlink> collectAvailableProviders(TestFrameworkRunningModel model) {
        ArrayList<DiffHyperlink> providers = new ArrayList<DiffHyperlink>();
        if (model != null) {
            AbstractTestProxy root = model.getRoot();
            List<? extends AbstractTestProxy> allTests = root.getAllTests();
            for (AbstractTestProxy abstractTestProxy : allTests) {
                providers.addAll(abstractTestProxy.getDiffViewerProviders());
            }
        }
        return providers;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (e.getProject() == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        DataContext context = e.getDataContext();
        AbstractTestProxy test = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(context);
        TestFrameworkRunningModel model = (TestFrameworkRunningModel)TestTreeView.MODEL_DATA_KEY.getData(context);
        boolean visible = test != null && model != null && test.getLeafDiffViewerProvider() != null;
        presentation.setEnabled(test != null);
        presentation.setVisible(visible);
    }

    private static class MyDiffWindow
    extends DiffWindowBase {
        @NotNull
        private final List<DiffHyperlink> myRequests;
        private final int myIndex;

        MyDiffWindow(@Nullable Project project, @NotNull DiffHyperlink request) {
            this(project, Collections.singletonList(request), 0);
        }

        MyDiffWindow(@Nullable Project project, @NotNull List<DiffHyperlink> requests, int index) {
            super(project, DiffDialogHints.DEFAULT);
            this.myRequests = requests;
            this.myIndex = index;
        }

        @Override
        @NotNull
        protected DiffRequestProcessor createProcessor() {
            return new MyTestDiffRequestProcessor(this.myProject, this.myRequests, this.myIndex);
        }

        private class MyTestDiffRequestProcessor
        extends TestDiffRequestProcessor {
            MyTestDiffRequestProcessor(@NotNull Project project, List<DiffHyperlink> requests, int index) {
                super(project, requests, index);
                this.putContextUserData(DiffUserDataKeys.DIALOG_GROUP_KEY, "#com.intellij.execution.junit2.states.ComparisonFailureState$DiffDialog");
            }

            @Override
            protected void setWindowTitle(@NotNull String title) {
                MyDiffWindow.this.getWrapper().setTitle(title);
            }

            @Override
            protected void onAfterNavigate() {
                DiffUtil.closeWindow(MyDiffWindow.this.getWrapper().getWindow(), true, true);
            }
        }
    }
}

