/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.testframework.autotest.AutoTestWatcher;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAutoTestManager
implements PersistentStateComponent<State> {
    protected static final String AUTO_TEST_MANAGER_DELAY = "auto.test.manager.delay";
    protected static final int AUTO_TEST_MANAGER_DELAY_DEFAULT = 3000;
    private static final Key<ProcessListener> ON_TERMINATION_RESTARTER_KEY = Key.create((String)"auto.test.manager.on.termination.restarter");
    private final Project myProject;
    private final Set<RunProfile> myEnabledRunProfiles = ContainerUtil.newHashSet();
    protected int myDelayMillis;
    private AutoTestWatcher myWatcher;

    public AbstractAutoTestManager(@NotNull Project project) {
        this.myProject = project;
        this.myDelayMillis = PropertiesComponent.getInstance((Project)project).getInt(AUTO_TEST_MANAGER_DELAY, 3000);
        this.myWatcher = this.createWatcher(project);
    }

    @Nullable
    private static ExecutionEnvironment getCurrentEnvironment(@NotNull Content content) {
        JComponent component = content.getComponent();
        if (component == null) {
            return null;
        }
        return (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext((Component)component));
    }

    private static void clearRestarterListener(@NotNull ProcessHandler processHandler2) {
        ProcessListener restarterListener = (ProcessListener)ON_TERMINATION_RESTARTER_KEY.get((UserDataHolder)processHandler2, null);
        if (restarterListener != null) {
            processHandler2.removeProcessListener(restarterListener);
            ON_TERMINATION_RESTARTER_KEY.set((UserDataHolder)processHandler2, null);
        }
    }

    private static void restart(@NotNull RunContentDescriptor descriptor) {
        descriptor.setActivateToolWindowWhenAdded(false);
        descriptor.setReuseToolWindowActivation(true);
        ExecutionUtil.restart((RunContentDescriptor)descriptor);
    }

    public static void saveConfigurationState(State state, RunProfile profile2) {
        RunConfiguration runConfiguration = (RunConfiguration)ObjectUtils.tryCast((Object)profile2, RunConfiguration.class);
        if (runConfiguration != null) {
            RunConfigurationDescriptor descriptor = new RunConfigurationDescriptor();
            descriptor.myType = runConfiguration.getType().getId();
            descriptor.myName = runConfiguration.getName();
            state.myEnabledRunConfigurations.add(descriptor);
        }
    }

    public static List<RunConfiguration> loadConfigurations(State state, Project project) {
        ArrayList configurations = ContainerUtil.newArrayList();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
        List descriptors = ContainerUtil.notNullize(state.myEnabledRunConfigurations);
        for (RunConfigurationDescriptor descriptor : descriptors) {
            RunnerAndConfigurationSettings settings;
            RunConfiguration configuration2;
            if (descriptor.myType == null || descriptor.myName == null || (configuration2 = (settings = runManager.findConfigurationByTypeAndName(descriptor.myType, descriptor.myName)) != null ? settings.getConfiguration() : null) == null) continue;
            configurations.add(configuration2);
        }
        return configurations;
    }

    @NotNull
    protected abstract AutoTestWatcher createWatcher(Project var1);

    public void setAutoTestEnabled(@NotNull RunContentDescriptor descriptor, @NotNull ExecutionEnvironment environment, boolean enabled) {
        Content content = descriptor.getAttachedContent();
        if (content != null) {
            if (enabled) {
                this.myEnabledRunProfiles.add(environment.getRunProfile());
                this.myWatcher.activate();
            } else {
                ProcessHandler processHandler2;
                this.myEnabledRunProfiles.remove(environment.getRunProfile());
                if (!this.hasEnabledAutoTests()) {
                    this.myWatcher.deactivate();
                }
                if ((processHandler2 = descriptor.getProcessHandler()) != null) {
                    AbstractAutoTestManager.clearRestarterListener(processHandler2);
                }
            }
        }
    }

    private boolean hasEnabledAutoTests() {
        RunContentManager contentManager = ExecutionManager.getInstance((Project)this.myProject).getContentManager();
        for (RunContentDescriptor descriptor : contentManager.getAllDescriptors()) {
            if (!this.isAutoTestEnabledForDescriptor(descriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean isAutoTestEnabled(@NotNull RunContentDescriptor descriptor) {
        return this.isAutoTestEnabledForDescriptor(descriptor);
    }

    private boolean isAutoTestEnabledForDescriptor(@NotNull RunContentDescriptor descriptor) {
        Content content = descriptor.getAttachedContent();
        if (content != null) {
            ExecutionEnvironment environment = AbstractAutoTestManager.getCurrentEnvironment(content);
            return environment != null && this.myEnabledRunProfiles.contains(environment.getRunProfile());
        }
        return false;
    }

    protected void restartAllAutoTests(int modificationStamp) {
        RunContentManager contentManager = ExecutionManager.getInstance((Project)this.myProject).getContentManager();
        boolean active = false;
        for (RunContentDescriptor descriptor : contentManager.getAllDescriptors()) {
            if (!this.isAutoTestEnabledForDescriptor(descriptor)) continue;
            this.restartAutoTest(descriptor, modificationStamp, this.myWatcher);
            active = true;
        }
        if (!active) {
            this.myWatcher.deactivate();
        }
    }

    private void restartAutoTest(@NotNull RunContentDescriptor descriptor, int modificationStamp, @NotNull AutoTestWatcher documentWatcher) {
        ProcessHandler processHandler2 = descriptor.getProcessHandler();
        if (processHandler2 != null && !processHandler2.isProcessTerminated()) {
            this.scheduleRestartOnTermination(descriptor, processHandler2, modificationStamp, documentWatcher);
        } else {
            AbstractAutoTestManager.restart(descriptor);
        }
    }

    private void scheduleRestartOnTermination(final @NotNull RunContentDescriptor descriptor, final @NotNull ProcessHandler processHandler2, final int modificationStamp, final @NotNull AutoTestWatcher watcher) {
        Object restarterListener = (ProcessListener)ON_TERMINATION_RESTARTER_KEY.get((UserDataHolder)processHandler2);
        if (restarterListener != null) {
            AbstractAutoTestManager.clearRestarterListener(processHandler2);
        }
        restarterListener = new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                AbstractAutoTestManager.clearRestarterListener(processHandler2);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (AbstractAutoTestManager.this.isAutoTestEnabledForDescriptor(descriptor) && watcher.isUpToDate(modificationStamp)) {
                        AbstractAutoTestManager.restart(descriptor);
                    }
                }, ModalityState.any());
            }
        };
        ON_TERMINATION_RESTARTER_KEY.set((UserDataHolder)processHandler2, restarterListener);
        processHandler2.addProcessListener(restarterListener);
    }

    int getDelay() {
        return this.myDelayMillis;
    }

    void setDelay(int delay) {
        this.myDelayMillis = delay;
        this.myWatcher.deactivate();
        this.myWatcher = this.createWatcher(this.myProject);
        if (this.hasEnabledAutoTests()) {
            this.myWatcher.activate();
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValue(AUTO_TEST_MANAGER_DELAY, this.myDelayMillis, 3000);
    }

    @Nullable
    public State getState() {
        State state = new State();
        for (RunProfile profile2 : this.myEnabledRunProfiles) {
            AbstractAutoTestManager.saveConfigurationState(state, profile2);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        List<RunConfiguration> configurations = AbstractAutoTestManager.loadConfigurations(state, this.myProject);
        this.myEnabledRunProfiles.clear();
        this.myEnabledRunProfiles.addAll(configurations);
        if (!configurations.isEmpty()) {
            this.myWatcher.activate();
        }
    }

    @Tag(value="run-configuration")
    static class RunConfigurationDescriptor {
        @Attribute(value="type")
        String myType;
        @Attribute(value="name")
        String myName;

        RunConfigurationDescriptor() {
        }
    }

    public static class State {
        @Tag(value="enabled-run-configurations")
        @XCollection
        List<RunConfigurationDescriptor> myEnabledRunConfigurations = ContainerUtil.newArrayList();
    }
}

