/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.execution.testframework.autotest.AbstractAutoTestManager;
import com.intellij.execution.testframework.autotest.AutoTestWatcher;
import com.intellij.execution.testframework.autotest.DelayedDocumentWatcher;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;

@State(name="AutoTestManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class AutoTestManager
extends AbstractAutoTestManager {
    @NotNull
    public static AutoTestManager getInstance(Project project) {
        return (AutoTestManager)ServiceManager.getService((Project)project, AutoTestManager.class);
    }

    public AutoTestManager(@NotNull Project project) {
        super(project);
    }

    @Override
    @NotNull
    protected AutoTestWatcher createWatcher(Project project) {
        return new DelayedDocumentWatcher(project, this.myDelayMillis, (Consumer<? super Integer>)((Consumer)this::restartAllAutoTests), (Condition<? super VirtualFile>)((Condition)file2 -> {
            if (ScratchFileService.getInstance().getRootType(file2) != null) {
                return false;
            }
            return FileEditorManager.getInstance((Project)project).isFileOpen(file2);
        }));
    }
}

