/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.StringTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestsLocationProviderUtil {
    private static final int MIN_PROXIMITY_THRESHOLD = 1;

    private TestsLocationProviderUtil() {
    }

    public static List<VirtualFile> findSuitableFilesFor(String filePath, Project project) {
        VirtualFile file2 = TestsLocationProviderUtil.getByFullPath(filePath);
        if (file2 != null) {
            return Collections.singletonList(file2);
        }
        LinkedList<String> folders = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(filePath, "/", false);
        String fileName2 = null;
        while (st.hasMoreTokens()) {
            String pathComponent = st.nextToken();
            if (st.hasMoreTokens()) {
                folders.addFirst(pathComponent);
                continue;
            }
            fileName2 = pathComponent;
        }
        if (fileName2 == null) {
            return Collections.emptyList();
        }
        List<VirtualFile> target2 = TestsLocationProviderUtil.findFilesClosestToTarget(folders, TestsLocationProviderUtil.collectCandidates(project, fileName2, true), 1);
        return target2.isEmpty() && file2 != null ? Collections.singletonList(file2) : target2;
    }

    public static List<VirtualFile> findFilesClosestToTarget(@NotNull List<String> targetParentFolders, List<? extends FileInfo> candidates, int minProximityThreshold) {
        if (candidates.isEmpty()) {
            return Collections.emptyList();
        }
        for (String string : targetParentFolders) {
            for (FileInfo fileInfo : candidates) {
                fileInfo.processRelativePathComponent(string);
            }
        }
        int maxProximity = 0;
        for (FileInfo fileInfo : candidates) {
            int n = fileInfo.getProximity();
            if (n <= maxProximity) continue;
            maxProximity = n;
        }
        if (maxProximity >= minProximityThreshold) {
            ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
            for (FileInfo fileInfo : candidates) {
                if (fileInfo.getProximity() != maxProximity) continue;
                arrayList.add(fileInfo.getFile());
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static List<FileInfo> collectCandidates(Project project, String fileName2, boolean includeNonProjectItems) {
        ArrayList<FileInfo> filesInfo = new ArrayList<FileInfo>();
        for (ChooseByNameContributor contributor : ChooseByNameContributor.FILE_EP_NAME.getExtensionList()) {
            NavigationItem[] navigationItems;
            for (NavigationItem navigationItem : navigationItems = contributor.getItemsByName(fileName2, fileName2, project, includeNonProjectItems)) {
                if (!(navigationItem instanceof PsiFile)) continue;
                VirtualFile itemFile = ((PsiFile)navigationItem).getVirtualFile();
                assert (itemFile != null);
                filesInfo.add(new FileInfo(itemFile));
            }
        }
        return filesInfo;
    }

    @Nullable
    private static VirtualFile getByFullPath(String filePath) {
        VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (fileByPath != null) {
            return fileByPath;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return TempFileSystem.getInstance().findFileByPath(filePath);
        }
        return null;
    }

    public static class FileInfo {
        private final VirtualFile myFile;
        private VirtualFile myCurrentFolder;
        private int myProximity = 0;

        public FileInfo(VirtualFile file2) {
            this.myFile = file2;
            this.myCurrentFolder = this.myFile.getParent();
        }

        public void processRelativePathComponent(String folderName) {
            if (this.myCurrentFolder == null) {
                return;
            }
            if (!folderName.equals(this.myCurrentFolder.getName())) {
                this.myCurrentFolder = null;
                return;
            }
            ++this.myProximity;
            this.myCurrentFolder = this.myCurrentFolder.getParent();
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public int getProximity() {
            return this.myProximity;
        }
    }
}

