/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.BaseStartedNodeEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralIdBasedToSMTRunnerEventsConvertor
extends GeneralTestEventsProcessor {
    private static final Logger LOG = Logger.getInstance(GeneralIdBasedToSMTRunnerEventsConvertor.class);
    private final Map<String, Node> myNodeByIdMap = ContainerUtil.newConcurrentMap();
    private final Set<Node> myRunningTestNodes = ContainerUtil.newConcurrentSet();
    private final Set<Node> myRunningSuiteNodes = ContainerUtil.newConcurrentSet();
    private final Node myTestsRootNode;
    private boolean myIsTestingFinished = false;
    private TestProxyPrinterProvider myTestProxyPrinterProvider = null;

    public GeneralIdBasedToSMTRunnerEventsConvertor(Project project, @NotNull SMTestProxy.SMRootTestProxy testsRootProxy, @NotNull String testFrameworkName) {
        super(project, testFrameworkName, testsRootProxy);
        this.myTestsRootNode = new Node("0", null, testsRootProxy);
        this.myNodeByIdMap.put(this.myTestsRootNode.getId(), this.myTestsRootNode);
    }

    @Override
    public void onStartTesting() {
        LOG.debug("onStartTesting");
        this.myTestsRootNode.setState(State.RUNNING, this);
        this.myTestsRootProxy.setStarted();
        this.fireOnTestingStarted(this.myTestsRootProxy);
    }

    @Override
    public void onTestsReporterAttached() {
        GeneralIdBasedToSMTRunnerEventsConvertor.fireOnTestsReporterAttached(this.myTestsRootProxy);
    }

    @Override
    public void onFinishTesting() {
        this.fireOnBeforeTestingFinished(this.myTestsRootProxy);
        LOG.debug("onFinishTesting");
        LOG.debug("onFinishTesting: invoked");
        if (this.myIsTestingFinished) {
            LOG.debug("has already been invoked");
            return;
        }
        this.myIsTestingFinished = true;
        boolean completeTree = GeneralIdBasedToSMTRunnerEventsConvertor.isTreeComplete(this.myRunningTestNodes, this.myTestsRootProxy);
        if (LOG.isDebugEnabled()) {
            LOG.debug("completeTree:" + completeTree);
        }
        if (completeTree) {
            this.myTestsRootProxy.setFinished();
        } else {
            this.myTestsRootProxy.setTerminated();
        }
        if (!this.myRunningTestNodes.isEmpty()) {
            this.logProblem("Unexpected running nodes: " + this.myRunningTestNodes);
        }
        this.myNodeByIdMap.clear();
        this.myRunningTestNodes.clear();
        this.myRunningSuiteNodes.clear();
        this.fireOnTestingFinished(this.myTestsRootProxy);
        super.onFinishTesting();
    }

    @Override
    public void setPrinterProvider(@NotNull TestProxyPrinterProvider printerProvider) {
        this.myTestProxyPrinterProvider = printerProvider;
    }

    @Override
    public void onTestStarted(@NotNull TestStartedEvent testStartedEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onTestStarted " + testStartedEvent.getId());
        }
        this.doStartNode(testStartedEvent, false);
    }

    @Override
    public void onSuiteStarted(@NotNull TestSuiteStartedEvent suiteStartedEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onSuiteStarted " + suiteStartedEvent.getId());
        }
        this.doStartNode(suiteStartedEvent, true);
    }

    private void doStartNode(@NotNull BaseStartedNodeEvent startedNodeEvent, boolean suite) {
        Node node;
        if (LOG.isDebugEnabled()) {
            LOG.debug("doStartNode " + startedNodeEvent.getId());
        }
        if ((node = this.findNode(startedNodeEvent)) != null) {
            if (node.getState() == State.NOT_RUNNING && startedNodeEvent.isRunning()) {
                this.setNodeAndAncestorsRunning(node);
            } else {
                this.logProblem(startedNodeEvent + " has been already started: " + node + "!");
            }
            return;
        }
        node = this.createNode(startedNodeEvent, suite);
        if (node == null) {
            return;
        }
        if (startedNodeEvent.isRunning()) {
            this.setNodeAndAncestorsRunning(node);
        }
    }

    private Node createNode(@NotNull BaseStartedNodeEvent startedNodeEvent, boolean suite) {
        Printer printer;
        Node parentNode = this.findValidParentNode(startedNodeEvent);
        if (parentNode == null) {
            return null;
        }
        String nodeId = this.validateAndGetNodeId(startedNodeEvent);
        if (nodeId == null) {
            return null;
        }
        String nodeName = startedNodeEvent.getName();
        SMTestProxy childProxy = new SMTestProxy(nodeName, suite, startedNodeEvent.getLocationUrl(), startedNodeEvent.getMetainfo(), true);
        childProxy.putUserData(SMTestProxy.NODE_ID, startedNodeEvent.getId());
        childProxy.setTreeBuildBeforeStart();
        TestProxyPrinterProvider printerProvider = this.myTestProxyPrinterProvider;
        String nodeType = startedNodeEvent.getNodeType();
        if (printerProvider != null && nodeType != null && nodeName != null && (printer = printerProvider.getPrinterByType(nodeType, nodeName, startedNodeEvent.getNodeArgs())) != null) {
            childProxy.setPreferredPrinter(printer);
        }
        Node node = new Node(nodeId, parentNode, childProxy);
        this.myNodeByIdMap.put(startedNodeEvent.getId(), node);
        if (this.myLocator != null) {
            childProxy.setLocator(this.myLocator);
        }
        parentNode.getProxy().addChild(childProxy);
        return node;
    }

    @Override
    protected SMTestProxy createSuite(String suiteName, String locationHint, String metaInfo, String id, String parentNodeId) {
        Node node = this.createNode(new TestSuiteStartedEvent(suiteName, id, parentNodeId, locationHint, metaInfo, null, null, false), true);
        return node.getProxy();
    }

    @Override
    protected SMTestProxy createProxy(String testName, String locationHint, String metaInfo, String id, String parentNodeId) {
        Node node = this.createNode(new TestStartedEvent(testName, id, parentNodeId, locationHint, metaInfo, null, null, false), false);
        return node.getProxy();
    }

    @Nullable
    private Node findValidParentNode(@NotNull BaseStartedNodeEvent startedNodeEvent) {
        String parentId = startedNodeEvent.getParentId();
        if (parentId == null) {
            this.logProblem("Parent node id should be defined: " + startedNodeEvent + ".", true);
            return null;
        }
        Node parentNode = this.myNodeByIdMap.get(parentId);
        if (parentNode == null) {
            this.logProblem("Parent node is undefined for " + startedNodeEvent + ".", true);
            return null;
        }
        if (parentNode.getState() != State.NOT_RUNNING && parentNode.getState() != State.RUNNING) {
            this.logProblem("Parent node should be registered or running: " + parentNode + ", " + startedNodeEvent);
            return null;
        }
        return parentNode;
    }

    @Override
    public void onTestFinished(@NotNull TestFinishedEvent testFinishedEvent) {
        LOG.debug("onTestFinished");
        Node node = this.findNodeToTerminate(testFinishedEvent);
        if (node != null) {
            SMTestProxy testProxy = node.getProxy();
            Long duration = testFinishedEvent.getDuration();
            if (duration != null) {
                testProxy.setDuration(duration);
            }
            testProxy.setFrameworkOutputFile(testFinishedEvent.getOutputFile());
            testProxy.setFinished();
            this.fireOnTestFinishedIfNeeded(testProxy, node);
            this.terminateNode(node, State.FINISHED);
        }
    }

    private void fireOnTestFinishedIfNeeded(@NotNull SMTestProxy testProxy, @NotNull Node node) {
        if (node.getState() != State.FINISHED && node.getState() != State.FAILED && node.getState() != State.IGNORED) {
            LOG.debug("onTestFinished: state != FINISHED && state != FAILED && state != IGNORED");
            this.fireOnTestFinished(testProxy);
        }
    }

    @Override
    public void onSuiteFinished(@NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        Node node;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onSuiteFinished " + suiteFinishedEvent.getId());
        }
        if ((node = this.findNodeToTerminate(suiteFinishedEvent)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("finished:" + node.myId);
            }
            SMTestProxy suiteProxy = node.getProxy();
            suiteProxy.setFinished();
            this.fireOnSuiteFinished(suiteProxy);
            this.terminateNode(node, State.FINISHED);
        }
    }

    @Nullable
    private Node findNodeToTerminate(@NotNull TreeNodeEvent treeNodeEvent) {
        Node node = this.findNode(treeNodeEvent);
        if (node == null) {
            this.logProblem("Trying to finish nonexistent node: " + treeNodeEvent);
            return null;
        }
        return node;
    }

    @Override
    public void onUncapturedOutput(@NotNull String text, Key outputType) {
        LOG.debug("onUncapturedOutput " + text);
        Node activeNode = this.findActiveNode();
        SMTestProxy activeProxy = activeNode.getProxy();
        activeProxy.addOutput(text, outputType);
    }

    @Override
    public void onError(@NotNull String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        this.onError(null, localizedMessage, stackTrace, isCritical);
    }

    public void onError(@Nullable String nodeId, @NotNull String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        LOG.debug("onError " + localizedMessage);
        SMTestProxy activeProxy = null;
        if (nodeId != null) {
            activeProxy = this.findProxyById(nodeId);
        }
        if (activeProxy == null) {
            Node activeNode = this.findActiveNode();
            activeProxy = activeNode.getProxy();
        }
        activeProxy.addError(localizedMessage, stackTrace, isCritical);
    }

    @Override
    public void onTestFailure(@NotNull TestFailedEvent testFailedEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onTestFailure " + testFailedEvent.getId());
        }
        ((Runnable)() -> {
            Node node;
            if (LOG.isDebugEnabled()) {
                LOG.debug("onTestFailure invoked " + testFailedEvent.getId());
            }
            if ((node = this.findNodeToTerminate(testFailedEvent)) == null) {
                return;
            }
            SMTestProxy testProxy = node.getProxy();
            String comparisonFailureActualText = testFailedEvent.getComparisonFailureActualText();
            String comparisonFailureExpectedText = testFailedEvent.getComparisonFailureExpectedText();
            String failureMessage = testFailedEvent.getLocalizedFailureMessage();
            String stackTrace = testFailedEvent.getStacktrace();
            if (comparisonFailureActualText != null && comparisonFailureExpectedText != null) {
                testProxy.setTestComparisonFailed(failureMessage, stackTrace, comparisonFailureActualText, comparisonFailureExpectedText, testFailedEvent);
            } else if (comparisonFailureActualText == null && comparisonFailureExpectedText == null) {
                testProxy.setTestFailed(failureMessage, stackTrace, testFailedEvent.isTestError());
            } else {
                this.logProblem("Comparison failure actual and expected texts should be both null or not null.\nExpected:\n" + comparisonFailureExpectedText + "\nActual:\n" + comparisonFailureActualText);
            }
            long duration = testFailedEvent.getDurationMillis();
            if (duration >= 0L) {
                testProxy.setDuration(duration);
            }
            this.fireOnTestFailed(testProxy);
            this.fireOnTestFinishedIfNeeded(testProxy, node);
            this.terminateNode(node, State.FAILED);
        }).run();
    }

    @Override
    public void onTestIgnored(@NotNull TestIgnoredEvent testIgnoredEvent) {
        LOG.debug("onTestIgnored");
        Node node = this.findNodeToTerminate(testIgnoredEvent);
        if (node != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onTestIgnored node " + node.myId);
            }
            SMTestProxy testProxy = node.getProxy();
            testProxy.setTestIgnored(testIgnoredEvent.getIgnoreComment(), testIgnoredEvent.getStacktrace());
            this.fireOnTestIgnored(testProxy);
            this.fireOnTestFinishedIfNeeded(testProxy, node);
            this.terminateNode(node, State.IGNORED);
        }
    }

    @Override
    public void onTestOutput(@NotNull TestOutputEvent testOutputEvent) {
        LOG.debug("onTestOutput");
        Node node = this.findNode(testOutputEvent);
        if (node == null) {
            this.logProblem("Test wasn't started! But " + testOutputEvent + "!");
            return;
        }
        node.getProxy().addOutput(testOutputEvent.getText(), testOutputEvent.getOutputType());
    }

    @Override
    public void onTestsCountInSuite(int count) {
        LOG.debug("onTestsCountInSuite");
        this.fireOnTestsCountInSuite(count);
    }

    @Nullable
    private String validateAndGetNodeId(@NotNull TreeNodeEvent treeNodeEvent) {
        String nodeId = treeNodeEvent.getId();
        if (nodeId == null || nodeId.equals("0")) {
            this.logProblem((nodeId == null ? "Missing" : "Illegal") + " nodeId: " + treeNodeEvent, true);
        }
        return nodeId;
    }

    @Nullable
    private Node findNode(@NotNull TreeNodeEvent treeNodeEvent) {
        String nodeId = this.validateAndGetNodeId(treeNodeEvent);
        return nodeId != null ? this.myNodeByIdMap.get(nodeId) : null;
    }

    @Nullable
    public SMTestProxy findProxyById(@NotNull String id) {
        Node node = this.myNodeByIdMap.get(id);
        return node != null ? node.getProxy() : null;
    }

    @Override
    public void dispose() {
        Application application;
        super.dispose();
        if (!(this.myRunningTestNodes.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
            this.logProblem("Not all events were processed!");
        }
        this.myRunningTestNodes.clear();
        this.myRunningSuiteNodes.clear();
        this.myNodeByIdMap.clear();
    }

    private void setNodeAndAncestorsRunning(@NotNull Node lowestNode) {
        for (Node node = lowestNode; node != null && node != this.myTestsRootNode && node.getState() == State.NOT_RUNNING; node = node.getParentNode()) {
            node.setState(State.RUNNING, this);
            SMTestProxy proxy = node.getProxy();
            proxy.setStarted();
            if (proxy.isSuite()) {
                this.myRunningSuiteNodes.add(node);
                this.fireOnSuiteStarted(proxy);
                continue;
            }
            this.myRunningTestNodes.add(lowestNode);
            this.fireOnTestStarted(proxy);
        }
    }

    private void terminateNode(@NotNull Node node, @NotNull State terminateState) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("terminateNode " + node.myId);
        }
        node.setState(terminateState, this);
        this.myRunningTestNodes.remove(node);
        this.myRunningSuiteNodes.remove(node);
    }

    @NotNull
    private Node findActiveNode() {
        Iterator<Node> testsIterator = this.myRunningTestNodes.iterator();
        if (testsIterator.hasNext()) {
            return testsIterator.next();
        }
        Iterator<Node> suitesIterator = this.myRunningSuiteNodes.iterator();
        if (suitesIterator.hasNext()) {
            return suitesIterator.next();
        }
        return this.myTestsRootNode;
    }

    private static class Node {
        private final String myId;
        private final Node myParentNode;
        private final SMTestProxy myProxy;
        private State myState;

        Node(@NotNull String id, @Nullable Node parentNode, @NotNull SMTestProxy proxy) {
            this.myId = id;
            this.myParentNode = parentNode;
            this.myProxy = proxy;
            this.myState = State.NOT_RUNNING;
        }

        @NotNull
        public String getId() {
            return this.myId;
        }

        @Nullable
        public Node getParentNode() {
            return this.myParentNode;
        }

        @NotNull
        public SMTestProxy getProxy() {
            return this.myProxy;
        }

        @NotNull
        public State getState() {
            return this.myState;
        }

        public void setState(@NotNull State newState, @NotNull GeneralIdBasedToSMTRunnerEventsConvertor convertor) {
            if (this.myState == State.NOT_RUNNING && newState != State.RUNNING && newState != State.IGNORED || this.myState == State.RUNNING && newState != State.FINISHED && newState != State.FAILED && newState != State.IGNORED || this.myState == State.FINISHED && newState != State.FAILED || this.myState == State.FAILED && newState != State.FINISHED || this.myState == State.IGNORED && newState != State.FINISHED) {
                convertor.logProblem("Illegal state change [" + (Object)((Object)this.myState) + " -> " + (Object)((Object)newState) + "]: " + this.toString(), false);
            }
            if (this.myState.ordinal() < newState.ordinal()) {
                this.myState = newState;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.myId == node.myId;
        }

        public int hashCode() {
            return this.myId.hashCode();
        }

        public String toString() {
            return "{id=" + this.myId + ", parentId=" + (this.myParentNode != null ? this.myParentNode.getId() : "<undefined>") + ", name='" + this.myProxy.getName() + "', isSuite=" + this.myProxy.isSuite() + ", state=" + (Object)((Object)this.myState) + '}';
        }
    }

    private static enum State {
        NOT_RUNNING,
        RUNNING,
        FINISHED,
        FAILED,
        IGNORED;

    }
}

