/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.TestSuiteStack;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralToSMTRunnerEventsConvertor
extends GeneralTestEventsProcessor {
    private final Map<String, SMTestProxy> myRunningTestsFullNameToProxy = ContainerUtil.newConcurrentMap();
    private final TestSuiteStack mySuitesStack;
    private final Map<String, List<SMTestProxy>> myCurrentChildren = new HashMap<String, List<SMTestProxy>>();
    private boolean myIsTestingFinished;

    public GeneralToSMTRunnerEventsConvertor(Project project, @NotNull SMTestProxy.SMRootTestProxy testsRootNode, @NotNull String testFrameworkName) {
        super(project, testFrameworkName, testsRootNode);
        this.mySuitesStack = new TestSuiteStack(testFrameworkName);
    }

    @Override
    protected SMTestProxy createProxy(String testName, String locationHint, String metaInfo, String id, String parentNodeId) {
        SMTestProxy proxy = super.createProxy(testName, locationHint, metaInfo, id, parentNodeId);
        SMTestProxy currentSuite = this.getCurrentSuite();
        currentSuite.addChild(proxy);
        return proxy;
    }

    @Override
    protected SMTestProxy createSuite(String suiteName, String locationHint, String metaInfo, String id, String parentNodeId) {
        SMTestProxy newSuite = super.createSuite(suiteName, locationHint, metaInfo, id, parentNodeId);
        SMTestProxy parentSuite = this.getCurrentSuite();
        parentSuite.addChild(newSuite);
        this.mySuitesStack.pushSuite(newSuite);
        return newSuite;
    }

    @Override
    public void onSuiteTreeEnded(String suiteName) {
        this.myBuildTreeRunnables.add(() -> this.mySuitesStack.popSuite(suiteName));
        super.onSuiteTreeEnded(suiteName);
    }

    @Override
    public void onStartTesting() {
        this.mySuitesStack.pushSuite(this.myTestsRootProxy);
        this.myTestsRootProxy.setStarted();
        this.fireOnTestingStarted(this.myTestsRootProxy);
    }

    @Override
    public void onTestsReporterAttached() {
        GeneralToSMTRunnerEventsConvertor.fireOnTestsReporterAttached(this.myTestsRootProxy);
    }

    @Override
    public void onFinishTesting() {
        this.fireOnBeforeTestingFinished(this.myTestsRootProxy);
        if (this.myIsTestingFinished) {
            return;
        }
        this.myIsTestingFinished = true;
        if (!GeneralToSMTRunnerEventsConvertor.isTreeComplete(this.myRunningTestsFullNameToProxy.keySet(), this.myTestsRootProxy)) {
            this.myTestsRootProxy.setTerminated();
            this.myRunningTestsFullNameToProxy.clear();
        }
        this.mySuitesStack.clear();
        this.myTestsRootProxy.setFinished();
        this.myCurrentChildren.clear();
        this.fireOnTestingFinished(this.myTestsRootProxy);
        super.onFinishTesting();
    }

    @Override
    public void setPrinterProvider(@NotNull TestProxyPrinterProvider printerProvider) {
    }

    @Override
    public void onTestStarted(@NotNull TestStartedEvent testStartedEvent) {
        SMTestProxy parentSuite;
        SMTestProxy testProxy;
        String testName = testStartedEvent.getName();
        String locationUrl = testStartedEvent.getLocationUrl();
        boolean isConfig = testStartedEvent.isConfig();
        String fullName = this.getFullTestName(testName);
        if (this.myRunningTestsFullNameToProxy.containsKey(fullName)) {
            this.logProblem("Test [" + fullName + "] has been already started");
            if (SMTestRunnerConnectionUtil.isInDebugMode()) {
                return;
            }
        }
        if ((testProxy = this.findChild(parentSuite = this.getCurrentSuite(), locationUrl != null ? locationUrl : fullName, false)) == null) {
            testProxy = new SMTestProxy(testName, false, locationUrl, testStartedEvent.getMetainfo(), false);
            testProxy.setConfig(isConfig);
            if (this.myTreeBuildBeforeStart) {
                testProxy.setTreeBuildBeforeStart();
            }
            if (this.myLocator != null) {
                testProxy.setLocator(this.myLocator);
            }
            parentSuite.addChild(testProxy);
        }
        this.myRunningTestsFullNameToProxy.put(fullName, testProxy);
        testProxy.setStarted();
        this.fireOnTestStarted(testProxy);
    }

    @Override
    public void onSuiteStarted(@NotNull TestSuiteStartedEvent suiteStartedEvent) {
        String suiteName = suiteStartedEvent.getName();
        String locationUrl = suiteStartedEvent.getLocationUrl();
        SMTestProxy parentSuite = this.getCurrentSuite();
        SMTestProxy newSuite = this.findChild(parentSuite, locationUrl != null ? locationUrl : suiteName, true);
        if (newSuite == null) {
            newSuite = new SMTestProxy(suiteName, true, locationUrl, suiteStartedEvent.getMetainfo(), parentSuite.isPreservePresentableName());
            if (this.myTreeBuildBeforeStart) {
                newSuite.setTreeBuildBeforeStart();
            }
            if (this.myLocator != null) {
                newSuite.setLocator(this.myLocator);
            }
            parentSuite.addChild(newSuite);
        }
        this.initCurrentChildren(newSuite, true);
        this.mySuitesStack.pushSuite(newSuite);
        newSuite.setSuiteStarted();
        this.fireOnSuiteStarted(newSuite);
    }

    private void initCurrentChildren(SMTestProxy newSuite, boolean preferSuite) {
        if (this.myTreeBuildBeforeStart) {
            for (SMTestProxy sMTestProxy : newSuite.getChildren()) {
                if (sMTestProxy.isFinal() && (!preferSuite || !sMTestProxy.isSuite())) continue;
                String url = sMTestProxy.getLocationUrl();
                if (url != null) {
                    this.myCurrentChildren.computeIfAbsent(url, l -> new ArrayList()).add(sMTestProxy);
                }
                this.myCurrentChildren.computeIfAbsent(sMTestProxy.getName(), l -> new ArrayList()).add(sMTestProxy);
            }
        }
    }

    private SMTestProxy findChild(SMTestProxy parentSuite, String fullName, boolean preferSuite) {
        if (this.myTreeBuildBeforeStart) {
            LinkedHashSet<SMTestProxy> acceptedProxies = new LinkedHashSet<SMTestProxy>();
            Collection children2 = this.myCurrentChildren.get(fullName);
            if (children2 == null) {
                this.initCurrentChildren(parentSuite, preferSuite);
                children2 = this.myCurrentChildren.get(fullName);
            }
            if (children2 != null) {
                for (SMTestProxy proxy : children2) {
                    if (proxy.isFinal() && (!preferSuite || !proxy.isSuite())) continue;
                    acceptedProxies.add(proxy);
                }
                if (!acceptedProxies.isEmpty()) {
                    SMTestProxy accepted = null;
                    for (SMTestProxy proxy : acceptedProxies) {
                        if (proxy.isSuite() != preferSuite || proxy.getParent() != parentSuite) continue;
                        if (!proxy.isFinal()) {
                            return proxy;
                        }
                        if (accepted != null) continue;
                        accepted = proxy;
                    }
                    return accepted != null ? accepted : (SMTestProxy)acceptedProxies.iterator().next();
                }
            }
        }
        return null;
    }

    @Override
    public void onTestFinished(@NotNull TestFinishedEvent testFinishedEvent) {
        String testName = testFinishedEvent.getName();
        Long duration = testFinishedEvent.getDuration();
        String fullTestName = this.getFullTestName(testName);
        SMTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
        if (testProxy == null) {
            this.logProblem("Test wasn't started! TestFinished event: name = {" + testName + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
            return;
        }
        testProxy.setDuration(duration != null ? duration : 0L);
        testProxy.setFrameworkOutputFile(testFinishedEvent.getOutputFile());
        testProxy.setFinished();
        this.myRunningTestsFullNameToProxy.remove(fullTestName);
        this.clearCurrentChildren(fullTestName, testProxy);
        this.fireOnTestFinished(testProxy);
    }

    private void clearCurrentChildren(String fullTestName, SMTestProxy testProxy) {
        this.myCurrentChildren.remove(fullTestName);
        String url = testProxy.getLocationUrl();
        if (url != null) {
            this.myCurrentChildren.remove(url);
        }
    }

    @Override
    public void onSuiteFinished(@NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        String suiteName = suiteFinishedEvent.getName();
        SMTestProxy mySuite = this.mySuitesStack.popSuite(suiteName);
        if (mySuite != null) {
            mySuite.setFinished();
            this.myCurrentChildren.remove(suiteName);
            String locationUrl = mySuite.getLocationUrl();
            if (locationUrl != null) {
                this.myCurrentChildren.remove(locationUrl);
            }
            this.fireOnSuiteFinished(mySuite);
        }
    }

    @Override
    public void onUncapturedOutput(@NotNull String text, Key outputType) {
        SMTestProxy currentProxy = this.findCurrentTestOrSuite();
        currentProxy.addOutput(text, outputType);
    }

    @Override
    public void onError(@NotNull String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        SMTestProxy currentProxy = this.findCurrentTestOrSuite();
        currentProxy.addError(localizedMessage, stackTrace, isCritical);
    }

    @Override
    public void onTestFailure(@NotNull TestFailedEvent testFailedEvent) {
        String testName = testFailedEvent.getName();
        if (testName == null) {
            this.logProblem("No test name specified in " + testFailedEvent);
            return;
        }
        String localizedMessage = testFailedEvent.getLocalizedFailureMessage();
        String stackTrace = testFailedEvent.getStacktrace();
        boolean isTestError = testFailedEvent.isTestError();
        String comparisionFailureActualText = testFailedEvent.getComparisonFailureActualText();
        String comparisionFailureExpectedText = testFailedEvent.getComparisonFailureExpectedText();
        boolean inDebugMode = SMTestRunnerConnectionUtil.isInDebugMode();
        String fullTestName = this.getFullTestName(testName);
        SMTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
        if (testProxy == null) {
            this.logProblem("Test wasn't started! TestFailure event: name = {" + testName + "}, message = {" + localizedMessage + "}, stackTrace = {" + stackTrace + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
            if (inDebugMode) {
                return;
            }
            this.onTestStarted(new TestStartedEvent(testName, null));
            testProxy = this.getProxyByFullTestName(fullTestName);
        }
        if (testProxy == null) {
            return;
        }
        if (comparisionFailureActualText != null && comparisionFailureExpectedText != null) {
            testProxy.setTestComparisonFailed(localizedMessage, stackTrace, comparisionFailureActualText, comparisionFailureExpectedText, testFailedEvent);
        } else if (comparisionFailureActualText == null && comparisionFailureExpectedText == null) {
            testProxy.setTestFailed(localizedMessage, stackTrace, isTestError);
        } else {
            testProxy.setTestFailed(localizedMessage, stackTrace, isTestError);
            this.logProblem("Comparison failure actual and expected texts should be both null or not null.\nExpected:\n" + comparisionFailureExpectedText + "\nActual:\n" + comparisionFailureActualText);
        }
        this.fireOnTestFailed(testProxy);
    }

    @Override
    public void onTestIgnored(@NotNull TestIgnoredEvent testIgnoredEvent) {
        String testName = testIgnoredEvent.getName();
        if (testName == null) {
            this.logProblem("TestIgnored event: no name");
        }
        String ignoreComment = testIgnoredEvent.getIgnoreComment();
        String stackTrace = testIgnoredEvent.getStacktrace();
        String fullTestName = this.getFullTestName(testName);
        SMTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
        if (testProxy == null) {
            boolean debugMode = SMTestRunnerConnectionUtil.isInDebugMode();
            this.logProblem("Test wasn't started! TestIgnored event: name = {" + testName + "}, message = {" + ignoreComment + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
            if (debugMode) {
                return;
            }
            this.onTestStarted(new TestStartedEvent(testName, null));
            testProxy = this.getProxyByFullTestName(fullTestName);
        }
        if (testProxy == null) {
            return;
        }
        testProxy.setTestIgnored(ignoreComment, stackTrace);
        this.fireOnTestIgnored(testProxy);
    }

    @Override
    public void onTestOutput(@NotNull TestOutputEvent testOutputEvent) {
        String testName = testOutputEvent.getName();
        String text = testOutputEvent.getText();
        Key outputType = testOutputEvent.getOutputType();
        String fullTestName = this.getFullTestName(testName);
        SMTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
        if (testProxy == null) {
            this.logProblem("Test wasn't started! TestOutput event: name = {" + testName + "}, outputType = " + outputType + ", text = {" + text + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
            return;
        }
        testProxy.addOutput(text, outputType);
    }

    @Override
    public void onTestsCountInSuite(int count) {
        this.fireOnTestsCountInSuite(count);
    }

    @NotNull
    protected final SMTestProxy getCurrentSuite() {
        SMTestProxy currentSuite = this.mySuitesStack.getCurrentSuite();
        if (currentSuite != null) {
            return currentSuite;
        }
        this.logProblem("Current suite is undefined. Root suite will be used.");
        return this.myTestsRootProxy;
    }

    protected String getFullTestName(String testName) {
        return testName;
    }

    protected int getRunningTestsQuantity() {
        return this.myRunningTestsFullNameToProxy.size();
    }

    @Nullable
    protected SMTestProxy getProxyByFullTestName(String fullTestName) {
        return this.myRunningTestsFullNameToProxy.get(fullTestName);
    }

    protected void clearInternalSuitesStack() {
        this.mySuitesStack.clear();
    }

    private String cannotFindFullTestNameMsg(String fullTestName) {
        return "Cant find running test for [" + fullTestName + "]. Current running tests: {" + this.dumpRunningTestsNames() + "}";
    }

    private StringBuilder dumpRunningTestsNames() {
        Set<String> names = this.myRunningTestsFullNameToProxy.keySet();
        StringBuilder namesDump = new StringBuilder();
        for (String name : names) {
            namesDump.append('[').append(name).append(']').append(',');
        }
        return namesDump;
    }

    @Override
    public void dispose() {
        Application application;
        super.dispose();
        if (!(this.myRunningTestsFullNameToProxy.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
            this.logProblem("Not all events were processed! " + this.dumpRunningTestsNames());
        }
        this.myRunningTestsFullNameToProxy.clear();
        this.mySuitesStack.clear();
    }

    private SMTestProxy findCurrentTestOrSuite() {
        SMTestProxy currentProxy = null;
        Iterator<SMTestProxy> iterator = this.myRunningTestsFullNameToProxy.values().iterator();
        if (iterator.hasNext()) {
            currentProxy = iterator.next();
            if (iterator.hasNext()) {
                currentProxy = null;
            }
        }
        if (currentProxy == null) {
            SMTestProxy currentSuite = this.mySuitesStack.getCurrentSuite();
            currentProxy = currentSuite != null ? currentSuite : this.myTestsRootProxy;
        }
        return currentProxy;
    }
}

