/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OutputLineSplitter {
    public static final int SM_MESSAGE_PREFIX = 105;
    private static final boolean USE_CYCLE_BUFFER = ConsoleBuffer.useCycleBuffer();
    private static final String TEAMCITY_SERVICE_MESSAGE_PREFIX = "##teamcity[";
    private static final char NEW_LINE = '\n';
    private final boolean myStdinSupportEnabled;
    private final List<OutputChunk> myStdOutChunks = new ArrayList<OutputChunk>();
    private final List<OutputChunk> myStdErrChunks = new ArrayList<OutputChunk>();
    private final List<OutputChunk> mySystemChunks = new ArrayList<OutputChunk>();
    private final int myCurrentCyclicBufferSize = ConsoleBuffer.getCycleBufferSize();

    public OutputLineSplitter(boolean stdinEnabled) {
        this.myStdinSupportEnabled = stdinEnabled;
    }

    public void process(@NotNull String text, @NotNull Key outputType) {
        int from = 0;
        int newLineInd = text.indexOf(10);
        int teamcityMessageStartInd = text.indexOf(TEAMCITY_SERVICE_MESSAGE_PREFIX);
        while (from < text.length()) {
            int nextFrom = Math.min(newLineInd != -1 ? newLineInd + 1 : text.length(), teamcityMessageStartInd != -1 ? teamcityMessageStartInd : text.length());
            String chunk = text.substring(from, nextFrom);
            this.processLine(chunk, outputType);
            from = nextFrom;
            if (nextFrom == teamcityMessageStartInd) {
                this.flush();
                teamcityMessageStartInd = text.indexOf(TEAMCITY_SERVICE_MESSAGE_PREFIX, nextFrom + TEAMCITY_SERVICE_MESSAGE_PREFIX.length());
            }
            if (newLineInd == -1 || nextFrom != newLineInd + 1) continue;
            newLineInd = text.indexOf(10, nextFrom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLine(@NotNull String text, @NotNull Key outputType) {
        if (text.isEmpty()) {
            return;
        }
        if (ProcessOutputType.isStdout((Key)outputType)) {
            this.processStdOutConsistently(text, outputType);
        } else {
            List<OutputChunk> chunks;
            ArrayList<OutputChunk> chunksToFlush = null;
            List<OutputChunk> list2 = chunks = outputType == ProcessOutputTypes.SYSTEM ? this.mySystemChunks : this.myStdErrChunks;
            synchronized (list2) {
                OutputChunk lastChunk = (OutputChunk)ContainerUtil.getLastItem(chunks);
                if (lastChunk != null && outputType.equals((Object)lastChunk.getKey())) {
                    lastChunk.append(text);
                } else {
                    chunks.add(new OutputChunk(outputType, text));
                }
                if (StringUtil.endsWithChar((CharSequence)text, (char)'\n')) {
                    chunksToFlush = new ArrayList<OutputChunk>(chunks);
                    chunks.clear();
                }
            }
            if (chunksToFlush != null) {
                this.onChunksAvailable(chunksToFlush, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStdOutConsistently(String text, Key outputType) {
        int textLength = text.length();
        List<OutputChunk> list2 = this.myStdOutChunks;
        synchronized (list2) {
            this.myStdOutChunks.add(new OutputChunk(outputType, text));
        }
        char lastChar = text.charAt(textLength - 1);
        if (lastChar == '\n' || lastChar == '\r') {
            this.flushStdOutBuffer();
        } else if (this.myStdinSupportEnabled && !this.isInTeamcityMessage()) {
            this.flushStdOutBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushStdOutBuffer() {
        ArrayList<OutputChunk> chunks = new ArrayList<OutputChunk>();
        OutputChunk lastChunk = null;
        List<OutputChunk> list2 = this.myStdOutChunks;
        synchronized (list2) {
            for (OutputChunk chunk : this.myStdOutChunks) {
                if (lastChunk != null && chunk.getKey() == lastChunk.getKey()) {
                    StringBuilder builder2;
                    String chunkText = chunk.getText();
                    if (USE_CYCLE_BUFFER && (builder2 = lastChunk.myBuilder) != null && builder2.length() + chunkText.length() > this.myCurrentCyclicBufferSize && this.myCurrentCyclicBufferSize > 210) {
                        builder2.delete(105, Math.min(builder2.length(), this.myCurrentCyclicBufferSize - 105));
                    }
                    lastChunk.append(chunkText);
                    continue;
                }
                lastChunk = chunk;
                chunks.add(chunk);
            }
            this.myStdOutChunks.clear();
        }
        this.onChunksAvailable(chunks, chunks.size() == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ArrayList<OutputChunk> systemChunksToFlush;
        ArrayList<OutputChunk> stderrChunksToFlush;
        this.flushStdOutBuffer();
        List<OutputChunk> list2 = this.myStdErrChunks;
        synchronized (list2) {
            stderrChunksToFlush = new ArrayList<OutputChunk>(this.myStdErrChunks);
            this.myStdErrChunks.clear();
        }
        this.onChunksAvailable(stderrChunksToFlush, false);
        List<OutputChunk> list3 = this.mySystemChunks;
        synchronized (list3) {
            systemChunksToFlush = new ArrayList<OutputChunk>(this.mySystemChunks);
            this.mySystemChunks.clear();
        }
        this.onChunksAvailable(systemChunksToFlush, false);
    }

    private void onChunksAvailable(@NotNull List<OutputChunk> chunks, boolean tcLikeFakeOutput) {
        for (OutputChunk chunk : chunks) {
            this.onLineAvailable(chunk.getText(), chunk.getKey(), tcLikeFakeOutput);
        }
    }

    protected boolean isInTeamcityMessage() {
        return this.myStdOutChunks.stream().anyMatch(chunk -> chunk.getText().startsWith(TEAMCITY_SERVICE_MESSAGE_PREFIX));
    }

    protected abstract void onLineAvailable(@NotNull String var1, @NotNull Key var2, boolean var3);

    private static class OutputChunk {
        private final Key myKey;
        private String myText;
        private StringBuilder myBuilder;

        private OutputChunk(Key key, String text) {
            this.myKey = key;
            this.myText = text;
        }

        public Key getKey() {
            return this.myKey;
        }

        public String getText() {
            if (this.myBuilder != null) {
                this.myText = this.myBuilder.toString();
                this.myBuilder = null;
            }
            return this.myText;
        }

        public void append(String text) {
            if (this.myBuilder == null) {
                this.myBuilder = new StringBuilder(this.myText);
                this.myText = null;
            }
            this.myBuilder.append(text);
        }
    }
}

