/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.Location;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestProxyRoot;
import com.intellij.execution.testframework.sm.SMStacktraceParser;
import com.intellij.execution.testframework.sm.SMStacktraceParserEx;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.events.TestDurationStrategy;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.CompoundTestFailedState;
import com.intellij.execution.testframework.sm.runner.states.NotRunState;
import com.intellij.execution.testframework.sm.runner.states.SuiteFinishedState;
import com.intellij.execution.testframework.sm.runner.states.SuiteInProgressState;
import com.intellij.execution.testframework.sm.runner.states.TerminatedState;
import com.intellij.execution.testframework.sm.runner.states.TestComparisionFailedState;
import com.intellij.execution.testframework.sm.runner.states.TestErrorState;
import com.intellij.execution.testframework.sm.runner.states.TestFailedState;
import com.intellij.execution.testframework.sm.runner.states.TestIgnoredState;
import com.intellij.execution.testframework.sm.runner.states.TestInProgressState;
import com.intellij.execution.testframework.sm.runner.states.TestPassedState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTestProxy
extends AbstractTestProxy {
    public static final Key<String> NODE_ID = Key.create((String)"test.proxy.id");
    private static final Logger LOG = Logger.getInstance((String)SMTestProxy.class.getName());
    private final String myName;
    private boolean myIsSuite;
    private final String myLocationUrl;
    private final String myMetainfo;
    private final boolean myPreservePresentableName;
    private List<SMTestProxy> myChildren;
    private SMTestProxy myParent;
    private AbstractState myState = NotRunState.getInstance();
    private Long myDuration = null;
    private boolean myDurationIsCached = false;
    private boolean myHasCriticalErrors = false;
    private boolean myHasPassedTests = false;
    private boolean myHasPassedTestsCached = false;
    private String myStacktrace;
    private String myErrorMessage;
    private boolean myIsEmptyIsCached = false;
    private boolean myIsEmpty = true;
    private SMTestLocator myLocator = null;
    private Printer myPreferredPrinter = null;
    private String myPresentableName;
    private boolean myConfig = false;
    private boolean myTreeBuildBeforeStart = false;
    private CachedValue<Map<GlobalSearchScope, Ref<Location>>> myLocationMapCachedValue;
    @Nullable
    private TestDurationStrategy myDurationStrategyCached = null;

    public SMTestProxy(String testName, boolean isSuite, @Nullable String locationUrl) {
        this(testName, isSuite, locationUrl, false);
    }

    public SMTestProxy(String testName, boolean isSuite, @Nullable String locationUrl, boolean preservePresentableName) {
        this(testName, isSuite, locationUrl, null, preservePresentableName);
    }

    public SMTestProxy(String testName, boolean isSuite, @Nullable String locationUrl, @Nullable String metainfo, boolean preservePresentableName) {
        this.myName = testName;
        this.myIsSuite = isSuite;
        this.myLocationUrl = locationUrl;
        this.myMetainfo = metainfo;
        this.myPreservePresentableName = preservePresentableName;
    }

    public boolean isPreservePresentableName() {
        return this.myPreservePresentableName;
    }

    public void setLocator(@NotNull SMTestLocator testLocator) {
        this.myLocator = testLocator;
        this.myLocationMapCachedValue = null;
    }

    public void setConfig(boolean config2) {
        this.myConfig = config2;
    }

    public void setPreferredPrinter(@NotNull Printer preferredPrinter) {
        this.myPreferredPrinter = preferredPrinter;
    }

    @Override
    public boolean isInProgress() {
        return this.myState.isInProgress();
    }

    @Override
    public boolean isDefect() {
        return this.myState.isDefect();
    }

    @Override
    public boolean shouldRun() {
        return true;
    }

    @Override
    public int getMagnitude() {
        return this.getMagnitudeInfo().getValue();
    }

    public TestStateInfo.Magnitude getMagnitudeInfo() {
        return this.myState.getMagnitude();
    }

    public boolean hasErrors() {
        return this.myHasCriticalErrors;
    }

    public boolean isFinal() {
        return this.myState.isFinal();
    }

    private void setStacktraceIfNotSet(@Nullable String stacktrace) {
        if (this.myStacktrace == null) {
            this.myStacktrace = stacktrace;
        }
    }

    @Nullable
    public String getStacktrace() {
        return this.myStacktrace;
    }

    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    public SMTestLocator getLocator() {
        return this.myLocator;
    }

    @Override
    public boolean isLeaf() {
        return this.myChildren == null || this.myChildren.isEmpty();
    }

    @Override
    public boolean hasPassedTests() {
        boolean canCache;
        if (this.myHasPassedTestsCached) {
            return this.myHasPassedTests;
        }
        boolean hasPassedTests = this.calcPassedTests();
        boolean bl = canCache = !this.myState.isInProgress();
        if (canCache) {
            this.myHasPassedTests = hasPassedTests;
            this.myHasPassedTestsCached = true;
        }
        return hasPassedTests;
    }

    @Override
    public boolean isInterrupted() {
        return this.myState.wasTerminated();
    }

    private boolean calcPassedTests() {
        if (this.isPassed()) {
            return true;
        }
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            if (!sMTestProxy.hasPassedTests()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIgnored() {
        return this.myState.getMagnitude() == TestStateInfo.Magnitude.IGNORED_INDEX;
    }

    @Override
    public boolean isPassed() {
        return this.myState.getMagnitude() == TestStateInfo.Magnitude.SKIPPED_INDEX || this.myState.getMagnitude() == TestStateInfo.Magnitude.COMPLETE_INDEX || this.myState.getMagnitude() == TestStateInfo.Magnitude.PASSED_INDEX;
    }

    public void addChild(@NotNull SMTestProxy child2) {
        boolean printOwnContentOnly;
        if (this.myChildren == null) {
            this.myChildren = new CopyOnWriteArrayList<SMTestProxy>();
        }
        this.myChildren.add(child2);
        this.addLast(child2);
        child2.setParent(this);
        boolean bl = printOwnContentOnly = this instanceof SMRootTestProxy && ((SMRootTestProxy)this).shouldPrintOwnContentOnly();
        if (!printOwnContentOnly) {
            child2.setPrinter(this.myPrinter);
        }
        if (this.myPreferredPrinter != null && child2.myPreferredPrinter == null) {
            child2.setPreferredPrinter(this.myPreferredPrinter);
        }
    }

    @Nullable
    private Printer getRightPrinter(@Nullable Printer printer) {
        if (this.myPreferredPrinter != null && printer != null) {
            return this.myPreferredPrinter;
        }
        return printer;
    }

    @Override
    public void setPrinter(Printer printer) {
        super.setPrinter(this.getRightPrinter(printer));
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean isConfig() {
        return this.myConfig;
    }

    @Override
    @Nullable
    public Location getLocation(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        String locationUrl = this.getLocationUrl();
        if (locationUrl == null || this.myLocator == null) {
            return null;
        }
        if (this.myLocationMapCachedValue == null) {
            this.myLocationMapCachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
                ConcurrentMap value = ContainerUtil.newConcurrentMap((int)1);
                value.put(searchScope, Ref.create((Object)this.computeLocation(project, searchScope, locationUrl)));
                return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{this.myLocator.getLocationCacheModificationTracker(project)});
            }, false);
        }
        Map value = (Map)this.myLocationMapCachedValue.getValue();
        Ref ref = value.computeIfAbsent(searchScope, scope -> Ref.create((Object)this.computeLocation(project, searchScope, locationUrl)));
        return (Location)ref.get();
    }

    @Nullable
    private Location computeLocation(@NotNull Project project, @NotNull GlobalSearchScope searchScope, @NotNull String locationUrl) {
        SMTestLocator locator = Objects.requireNonNull(this.myLocator);
        String protocolId = VirtualFileManager.extractProtocol((String)locationUrl);
        if (protocolId != null) {
            String path = VirtualFileManager.extractPath((String)locationUrl);
            if (!DumbService.isDumb((Project)project) || DumbService.isDumbAware((Object)locator)) {
                return (Location)DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled(() -> {
                    List<Location> locations = locator.getLocation(protocolId, path, this.myMetainfo, project, searchScope);
                    return (Location)ContainerUtil.getFirstItem(locations);
                });
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Navigatable getDescriptor(@Nullable Location location, @NotNull TestConsoleProperties properties) {
        if (location == null) {
            return null;
        }
        String stacktrace = this.myStacktrace;
        if (stacktrace != null && properties instanceof SMStacktraceParser && this.isLeaf()) {
            Navigatable result2;
            Navigatable navigatable = result2 = properties instanceof SMStacktraceParserEx ? ((SMStacktraceParserEx)((Object)properties)).getErrorNavigatable(location, stacktrace) : ((SMStacktraceParser)((Object)properties)).getErrorNavigatable(location.getProject(), stacktrace);
            if (result2 != null) {
                return result2;
            }
        }
        return location.getOpenFileDescriptor();
    }

    public boolean isSuite() {
        return this.myIsSuite;
    }

    @Override
    public SMTestProxy getParent() {
        return this.myParent;
    }

    public List<? extends SMTestProxy> getChildren() {
        return this.myChildren != null ? this.myChildren : Collections.emptyList();
    }

    public List<SMTestProxy> getAllTests() {
        ArrayList<SMTestProxy> allTests = new ArrayList<SMTestProxy>();
        allTests.add(this);
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            allTests.addAll(sMTestProxy.getAllTests());
        }
        return allTests;
    }

    public void setStarted() {
        this.myState = !this.myIsSuite ? TestInProgressState.TEST : new SuiteInProgressState(this);
    }

    public void setSuiteStarted() {
        this.myState = new SuiteInProgressState(this);
        if (!this.myIsSuite) {
            this.myIsSuite = true;
        }
    }

    @Override
    @Nullable
    public Long getDuration() {
        if (this.myDurationIsCached || this.durationShouldBeSetExplicitly()) {
            return this.myDuration;
        }
        this.myDuration = this.calcSuiteDuration();
        this.myDurationIsCached = true;
        return this.myDuration;
    }

    @Override
    @Nullable
    public String getDurationString(TestConsoleProperties consoleProperties) {
        switch (this.getMagnitudeInfo()) {
            case PASSED_INDEX: 
            case RUNNING_INDEX: {
                return !this.isSubjectToHide(consoleProperties) ? this.getDurationString() : null;
            }
            case COMPLETE_INDEX: 
            case FAILED_INDEX: 
            case ERROR_INDEX: 
            case IGNORED_INDEX: 
            case SKIPPED_INDEX: 
            case TERMINATED_INDEX: {
                return this.getDurationString();
            }
        }
        return null;
    }

    private boolean isSubjectToHide(TestConsoleProperties consoleProperties) {
        return TestConsoleProperties.HIDE_PASSED_TESTS.value((AbstractProperty.AbstractPropertyContainer)consoleProperties) && this.getParent() != null && !this.isDefect();
    }

    private String getDurationString() {
        Long duration = this.getDuration();
        return duration != null ? StringUtil.formatDuration((long)duration, (String)"\u2009") : null;
    }

    @Override
    public boolean shouldSkipRootNodeForExport() {
        return true;
    }

    private boolean durationShouldBeSetExplicitly() {
        return !this.myIsSuite || this.getDurationStrategy() == TestDurationStrategy.MANUAL;
    }

    @NotNull
    protected TestDurationStrategy getDurationStrategy() {
        TestDurationStrategy parentDurationStrategy;
        TestDurationStrategy strategy = this.myDurationStrategyCached;
        if (strategy != null) {
            return strategy;
        }
        SMRootTestProxy root = this.getRoot();
        if (root == null) {
            return TestDurationStrategy.AUTOMATIC;
        }
        this.myDurationStrategyCached = parentDurationStrategy = root.getDurationStrategy();
        return parentDurationStrategy;
    }

    public void setDuration(long duration) {
        if (this.durationShouldBeSetExplicitly()) {
            this.invalidateCachedDurationForContainerSuites(duration - (this.myDuration != null ? this.myDuration : 0L));
            this.myDurationIsCached = true;
            this.myDuration = duration >= 0L ? Long.valueOf(duration) : null;
            return;
        }
        this.invalidateCachedDurationForContainerSuites(-1L);
        LOG.warn("Unsupported operation");
    }

    public void setFinished() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = !this.isSuite() ? TestPassedState.INSTANCE : this.determineSuiteStateOnFinished();
        this.fireOnNewPrintable(this.myState);
    }

    public void setTestFailed(@NotNull String localizedMessage, @Nullable String stackTrace, boolean testError) {
        this.setStacktraceIfNotSet(stackTrace);
        this.myErrorMessage = localizedMessage;
        TestFailedState failedState = new TestFailedState(localizedMessage, stackTrace);
        if (this.myState instanceof TestComparisionFailedState) {
            CompoundTestFailedState states = new CompoundTestFailedState(localizedMessage, stackTrace);
            states.addFailure((TestFailedState)this.myState);
            states.addFailure(failedState);
            this.fireOnNewPrintable(failedState);
            this.myState = states;
        } else if (this.myState instanceof CompoundTestFailedState) {
            ((CompoundTestFailedState)this.myState).addFailure(failedState);
            this.fireOnNewPrintable(failedState);
        } else if (this.myState instanceof TestFailedState) {
            ((TestFailedState)this.myState).addError(localizedMessage, stackTrace, this.myPrinter);
        } else {
            this.myState = testError ? new TestErrorState(localizedMessage, stackTrace) : failedState;
            this.fireOnNewPrintable(this.myState);
        }
    }

    public void setTestComparisonFailed(@NotNull String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText) {
        this.setTestComparisonFailed(localizedMessage, stackTrace, actualText, expectedText, null, null, true);
    }

    public void setTestComparisonFailed(@NotNull String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText, @NotNull TestFailedEvent event) {
        TestComparisionFailedState comparisionFailedState = this.setTestComparisonFailed(localizedMessage, stackTrace, actualText, expectedText, event.getExpectedFilePath(), event.getActualFilePath(), event.shouldPrintExpectedAndActualValues());
        comparisionFailedState.setToDeleteExpectedFile(event.isExpectedFileTemp());
        comparisionFailedState.setToDeleteActualFile(event.isActualFileTemp());
    }

    public TestComparisionFailedState setTestComparisonFailed(@NotNull String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText, @Nullable String expectedFilePath, @Nullable String actualFilePath, boolean printExpectedAndActualValues) {
        this.setStacktraceIfNotSet(stackTrace);
        this.myErrorMessage = localizedMessage;
        TestComparisionFailedState comparisionFailedState = new TestComparisionFailedState(localizedMessage, stackTrace, actualText, expectedText, printExpectedAndActualValues, expectedFilePath, actualFilePath);
        DiffHyperlink hyperlink = comparisionFailedState.getHyperlink();
        if (hyperlink != null) {
            hyperlink.setTestProxyName(this.getName());
        }
        if (this.myState instanceof CompoundTestFailedState) {
            ((CompoundTestFailedState)this.myState).addFailure(comparisionFailedState);
        } else if (this.myState instanceof TestFailedState) {
            CompoundTestFailedState states = new CompoundTestFailedState(localizedMessage, stackTrace);
            states.addFailure((TestFailedState)this.myState);
            states.addFailure(comparisionFailedState);
            this.myState = states;
        } else {
            this.myState = comparisionFailedState;
        }
        this.fireOnNewPrintable(comparisionFailedState);
        return comparisionFailedState;
    }

    @Override
    public void dispose() {
        if (this.myState instanceof TestFailedState) {
            Disposer.dispose((Disposable)((TestFailedState)this.myState));
        }
        super.dispose();
    }

    public void setTestIgnored(@Nullable String ignoreComment, @Nullable String stackTrace) {
        this.setStacktraceIfNotSet(stackTrace);
        this.myState = new TestIgnoredState(ignoreComment, stackTrace);
        this.fireOnNewPrintable(this.myState);
    }

    public void setParent(@Nullable SMTestProxy parent) {
        this.myParent = parent;
    }

    public List<? extends SMTestProxy> collectChildren(@Nullable Filter<SMTestProxy> filter) {
        return SMTestProxy.filterChildren(filter, this.collectChildren());
    }

    public List<? extends SMTestProxy> collectChildren() {
        List<? extends SMTestProxy> allChildren = this.getChildren();
        ArrayList result2 = ContainerUtilRt.newArrayList();
        result2.addAll(allChildren);
        for (SMTestProxy sMTestProxy : allChildren) {
            result2.addAll(sMTestProxy.collectChildren());
        }
        return result2;
    }

    public List<? extends SMTestProxy> getChildren(@Nullable Filter<? super SMTestProxy> filter) {
        return SMTestProxy.filterChildren(filter, this.getChildren());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAfterLastPassed(Printable printable) {
        if (this.myTreeBuildBeforeStart) {
            int idx = 0;
            List list2 = this.myNestedPrintables;
            synchronized (list2) {
                Printable proxy;
                Iterator iterator = this.myNestedPrintables.iterator();
                while (iterator.hasNext() && (!((proxy = (Printable)iterator.next()) instanceof SMTestProxy) || ((SMTestProxy)proxy).isFinal())) {
                    ++idx;
                }
            }
            this.insert(printable, idx);
        } else {
            this.addLast(printable);
        }
    }

    public void setTreeBuildBeforeStart() {
        this.myTreeBuildBeforeStart = true;
    }

    private static List<? extends SMTestProxy> filterChildren(@Nullable Filter<? super SMTestProxy> filter, List<? extends SMTestProxy> allChildren) {
        if (filter == Filter.NO_FILTER || filter == null) {
            return allChildren;
        }
        ArrayList<SMTestProxy> selectedChildren = new ArrayList<SMTestProxy>();
        for (SMTestProxy sMTestProxy : allChildren) {
            if (!filter.shouldAccept(sMTestProxy)) continue;
            selectedChildren.add(sMTestProxy);
        }
        if (selectedChildren.isEmpty()) {
            return Collections.emptyList();
        }
        return selectedChildren;
    }

    public boolean wasLaunched() {
        return this.myState.wasLaunched();
    }

    @Override
    public void printOn(Printer printer) {
        Printer rightPrinter = this.getRightPrinter(printer);
        super.printOn(rightPrinter);
        SMTestProxy.printState(this.myState, rightPrinter);
    }

    @Override
    public void printOwnPrintablesOn(Printer printer) {
        if (this.isLeaf()) {
            super.printOn(printer);
        } else {
            super.printOwnPrintablesOn(printer);
        }
        SMTestProxy.printState(this.myState, printer);
    }

    private static void printState(AbstractState oldState, Printer rightPrinter) {
        SMTestProxy.invokeInAlarm(() -> oldState.printOn(rightPrinter));
    }

    @Deprecated
    public void addStdOutput(String output, Key outputType) {
        this.addOutput(output, outputType);
    }

    public final void addStdOutput(@NotNull String output) {
        this.addOutput(output, ProcessOutputTypes.STDOUT);
    }

    public final void addStdErr(@NotNull String output) {
        this.addOutput(output, ProcessOutputTypes.STDERR);
    }

    public final void addSystemOutput(String output) {
        this.addOutput(output, ProcessOutputTypes.SYSTEM);
    }

    public void addOutput(final @NotNull String output, final @NotNull Key outputType) {
        this.addAfterLastPassed(new Printable(){

            @Override
            public void printOn(@NotNull Printer printer) {
                printer.printWithAnsiColoring(output, outputType);
            }
        });
    }

    public void addError(final String output, final @Nullable String stackTrace, boolean isCritical) {
        this.myHasCriticalErrors = isCritical;
        if (isCritical) {
            this.invalidateCachedHasErrorMark();
        }
        this.setStacktraceIfNotSet(stackTrace);
        this.addAfterLastPassed(new Printable(){

            @Override
            public void printOn(Printer printer) {
                String errorText = TestFailedState.buildErrorPresentationText(output, stackTrace);
                if (errorText != null) {
                    TestFailedState.printError(printer, Collections.singletonList(errorText));
                }
            }
        });
    }

    private void invalidateCachedHasErrorMark() {
        this.myHasCriticalErrors = true;
        SMTestProxy containerSuite = this.getParent();
        if (containerSuite != null && !containerSuite.hasErrors()) {
            containerSuite.invalidateCachedHasErrorMark();
        }
    }

    @NotNull
    public String getPresentableName() {
        if (this.myPresentableName == null) {
            this.myPresentableName = this.myPreservePresentableName ? TestsPresentationUtil.getPresentableNameTrimmedOnly(this) : TestsPresentationUtil.getPresentableName(this);
        }
        return this.myPresentableName;
    }

    @Override
    @Nullable
    public DiffHyperlink getDiffViewerProvider() {
        if (this.myState instanceof TestComparisionFailedState) {
            return ((TestComparisionFailedState)this.myState).getHyperlink();
        }
        if (this.myState instanceof CompoundTestFailedState) {
            return ((CompoundTestFailedState)this.myState).getHyperlinks().get(0);
        }
        return null;
    }

    @Override
    @NotNull
    public List<DiffHyperlink> getDiffViewerProviders() {
        if (this.myState instanceof CompoundTestFailedState) {
            return ((CompoundTestFailedState)this.myState).getHyperlinks();
        }
        return super.getDiffViewerProviders();
    }

    public String toString() {
        return this.getPresentableName();
    }

    public void setTerminated() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = TerminatedState.INSTANCE;
        List<? extends SMTestProxy> children2 = this.getChildren();
        for (SMTestProxy sMTestProxy : children2) {
            sMTestProxy.setTerminated();
        }
        this.fireOnNewPrintable(this.myState);
    }

    public boolean wasTerminated() {
        return this.myState.wasTerminated();
    }

    @Override
    @Nullable
    public String getLocationUrl() {
        return this.myLocationUrl;
    }

    @Override
    @Nullable
    public String getMetainfo() {
        return this.myMetainfo;
    }

    private boolean containsErrorTests() {
        List<? extends SMTestProxy> children2 = this.getChildren();
        for (SMTestProxy sMTestProxy : children2) {
            if (sMTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.ERROR_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean containsFailedTests() {
        List<? extends SMTestProxy> children2 = this.getChildren();
        for (SMTestProxy sMTestProxy : children2) {
            if (sMTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.FAILED_INDEX) continue;
            return true;
        }
        return false;
    }

    protected AbstractState determineSuiteStateOnFinished() {
        SuiteFinishedState state = this.isLeaf() ? SuiteFinishedState.EMPTY_SUITE : (this.isDefect() ? (this.containsErrorTests() ? SuiteFinishedState.ERROR_SUITE : (this.containsFailedTests() ? SuiteFinishedState.FAILED_SUITE : SuiteFinishedState.WITH_IGNORED_TESTS_SUITE)) : (this.isEmptySuite() ? SuiteFinishedState.EMPTY_SUITE : SuiteFinishedState.PASSED_SUITE));
        return state;
    }

    public boolean isEmptySuite() {
        if (this.myIsEmptyIsCached) {
            return this.myIsEmpty;
        }
        if (!this.isSuite()) {
            this.myIsEmpty = true;
            this.myIsEmptyIsCached = true;
            return true;
        }
        this.myIsEmpty = true;
        List<? extends SMTestProxy> allTestCases = this.getChildren();
        for (SMTestProxy sMTestProxy : allTestCases) {
            if (sMTestProxy.isSuite()) {
                if (!sMTestProxy.isEmptySuite()) {
                    this.myIsEmpty = false;
                    this.myIsEmptyIsCached = true;
                    break;
                }
                this.myIsEmpty = true;
                this.myIsEmptyIsCached = this.myState.isFinal();
                continue;
            }
            this.myIsEmpty = false;
            this.myIsEmptyIsCached = true;
            break;
        }
        return this.myIsEmpty;
    }

    @Nullable
    private Long calcSuiteDuration() {
        long partialDuration = 0L;
        boolean durationOfChildrenIsUnknown = true;
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            Long duration = sMTestProxy.getDuration();
            if (duration == null) continue;
            durationOfChildrenIsUnknown = false;
            partialDuration += duration.longValue();
        }
        return durationOfChildrenIsUnknown ? null : Long.valueOf(partialDuration);
    }

    private void invalidateCachedDurationForContainerSuites(long duration) {
        SMTestProxy containerSuite;
        if (!this.durationShouldBeSetExplicitly()) {
            if (duration >= 0L) {
                this.myDuration = this.myDuration == null ? Long.valueOf(duration) : Long.valueOf(this.myDuration + duration);
            } else {
                this.myDuration = null;
                this.myDurationIsCached = false;
            }
        }
        if ((containerSuite = this.getParent()) != null) {
            containerSuite.invalidateCachedDurationForContainerSuites(duration);
        }
    }

    public SMRootTestProxy getRoot() {
        SMTestProxy parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof SMRootTestProxy); parent = parent.getParent()) {
        }
        return parent != null ? (SMRootTestProxy)parent : null;
    }

    public static class SMRootTestProxy
    extends SMTestProxy
    implements TestProxyRoot {
        private boolean myTestsReporterAttached;
        private String myPresentation;
        private String myComment;
        private String myRootLocationUrl;
        private ProcessHandler myHandler;
        private boolean myShouldPrintOwnContentOnly = false;
        @NotNull
        private TestDurationStrategy myDurationStrategy = TestDurationStrategy.AUTOMATIC;

        public SMRootTestProxy() {
            this(false);
        }

        public SMRootTestProxy(boolean preservePresentableName) {
            super("[root]", true, null, preservePresentableName);
        }

        public void setTestsReporterAttached() {
            this.myTestsReporterAttached = true;
        }

        final void setDurationStrategy(@NotNull TestDurationStrategy strategy) {
            this.myDurationStrategy = strategy;
        }

        @Override
        @NotNull
        public final TestDurationStrategy getDurationStrategy() {
            return this.myDurationStrategy;
        }

        public boolean isTestsReporterAttached() {
            return this.myTestsReporterAttached;
        }

        @Override
        public String getPresentation() {
            return this.myPresentation;
        }

        public void setPresentation(String presentation) {
            this.myPresentation = presentation;
        }

        public void setComment(String comment) {
            this.myComment = comment;
        }

        @Override
        public String getComment() {
            return this.myComment;
        }

        public void setRootLocationUrl(String locationUrl) {
            this.myRootLocationUrl = locationUrl;
            ((SMTestProxy)this).myLocationMapCachedValue = null;
        }

        @Override
        @Nullable
        public String getLocationUrl() {
            return this.myRootLocationUrl;
        }

        public ProcessHandler getHandler() {
            return this.myHandler;
        }

        @Override
        public void setHandler(ProcessHandler handler2) {
            this.myHandler = handler2;
        }

        @Override
        protected AbstractState determineSuiteStateOnFinished() {
            if (this.isLeaf() && !this.isTestsReporterAttached()) {
                return SuiteFinishedState.TESTS_REPORTER_NOT_ATTACHED;
            }
            return super.determineSuiteStateOnFinished();
        }

        public void testingRestarted() {
            if (!this.getChildren().isEmpty()) {
                this.getChildren().clear();
            }
            this.clear();
        }

        boolean shouldPrintOwnContentOnly() {
            return this.myShouldPrintOwnContentOnly;
        }

        public void setShouldPrintOwnContentOnly(boolean shouldPrintOwnContentOnly) {
            this.myShouldPrintOwnContentOnly = shouldPrintOwnContentOnly;
        }

        @Override
        public void printOn(@NotNull Printer printer) {
            if (this.myShouldPrintOwnContentOnly) {
                this.printOwnPrintablesOn(printer, false);
            } else {
                super.printOn(printer);
            }
        }
    }
}

