/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.testframework.ui.TestsOutputConsolePrinter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestProxyPrinterProvider {
    private final TestProxyFilterProvider myFilterProvider;
    private final BaseTestsOutputConsoleView myTestOutputConsoleView;

    public TestProxyPrinterProvider(@NotNull BaseTestsOutputConsoleView testsOutputConsoleView, @NotNull TestProxyFilterProvider filterProvider) {
        this.myTestOutputConsoleView = testsOutputConsoleView;
        this.myFilterProvider = filterProvider;
    }

    @Nullable
    public Printer getPrinterByType(@NotNull String nodeType, @NotNull String nodeName, @Nullable String nodeArguments) {
        Filter filter = this.myFilterProvider.getFilter(nodeType, nodeName, nodeArguments);
        if (filter != null && !Disposer.isDisposed((Disposable)this.myTestOutputConsoleView)) {
            return new HyperlinkPrinter(this.myTestOutputConsoleView, HyperlinkPrinter.ERROR_CONTENT_TYPE, filter);
        }
        return null;
    }

    private static class HyperlinkPrinter
    extends TestsOutputConsolePrinter {
        public static final Condition<ConsoleViewContentType> ERROR_CONTENT_TYPE = contentType -> ConsoleViewContentType.ERROR_OUTPUT == contentType;
        private static final String NL = "\n";
        private final Condition<? super ConsoleViewContentType> myContentTypeCondition;
        private final Filter myFilter;

        HyperlinkPrinter(@NotNull BaseTestsOutputConsoleView testsOutputConsoleView, @NotNull Condition<? super ConsoleViewContentType> contentTypeCondition, @NotNull Filter filter) {
            super(testsOutputConsoleView, testsOutputConsoleView.getProperties(), null);
            this.myContentTypeCondition = contentTypeCondition;
            this.myFilter = filter;
        }

        @Override
        public void print(String text, ConsoleViewContentType contentType) {
            if (contentType == null || !this.myContentTypeCondition.value((Object)contentType)) {
                this.defaultPrint(text, contentType);
                return;
            }
            text = StringUtil.replace((String)text, (String)"\r\n", (String)NL, (boolean)false);
            StringTokenizer tokenizer = new StringTokenizer(text, NL, true);
            while (tokenizer.hasMoreTokens()) {
                String line = tokenizer.nextToken();
                if (NL.equals(line)) {
                    this.defaultPrint(line, contentType);
                    continue;
                }
                this.printLine(line, contentType);
            }
        }

        private void defaultPrint(String text, ConsoleViewContentType contentType) {
            super.print(text, contentType);
        }

        private void printLine(@NotNull String line, @NotNull ConsoleViewContentType contentType) {
            Filter.Result result2;
            try {
                result2 = this.myFilter.applyFilter(line, line.length());
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while applying " + this.myFilter + " to '" + line + "'", t);
            }
            if (result2 != null) {
                List<Filter.ResultItem> items = HyperlinkPrinter.sort(result2.getResultItems());
                int lastOffset = 0;
                for (Filter.ResultItem item : items) {
                    this.defaultPrint(line.substring(lastOffset, item.getHighlightStartOffset()), contentType);
                    String linkText = line.substring(item.getHighlightStartOffset(), item.getHighlightEndOffset());
                    this.printHyperlink(linkText, item.getHyperlinkInfo());
                    lastOffset = item.getHighlightEndOffset();
                }
                this.defaultPrint(line.substring(lastOffset), contentType);
            } else {
                this.defaultPrint(line, contentType);
            }
        }

        @NotNull
        private static List<Filter.ResultItem> sort(@NotNull List<Filter.ResultItem> items) {
            if (items.size() <= 1) {
                return items;
            }
            ArrayList<Filter.ResultItem> copy = new ArrayList<Filter.ResultItem>(items);
            Collections.sort(copy, Comparator.comparingInt(Filter.ResultItem::getHighlightStartOffset));
            return copy;
        }
    }
}

