/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestSuiteStack {
    private static final Logger LOG = Logger.getInstance((String)TestSuiteStack.class.getName());
    @NonNls
    private static final String EMPTY = "empty";
    private final ConcurrentLinkedDeque<SMTestProxy> myStack = new ConcurrentLinkedDeque();
    private final String myTestFrameworkName;

    public TestSuiteStack(@NotNull String testFrameworkName) {
        this.myTestFrameworkName = testFrameworkName;
    }

    public void pushSuite(@NotNull SMTestProxy suite) {
        this.myStack.push(suite);
    }

    @Nullable
    public SMTestProxy getCurrentSuite() {
        return this.myStack.peek();
    }

    @Nullable
    public SMTestProxy popSuite(String suiteName) throws EmptyStackException {
        if (this.myStack.isEmpty()) {
            if (SMTestRunnerConnectionUtil.isInDebugMode()) {
                LOG.error("Pop error: Tests/suites stack is empty. Test runner tried to close test suite which has been already closed or wasn't started at all. Unexpected suite name [" + suiteName + "]");
            }
            return null;
        }
        SMTestProxy topSuite = this.myStack.peek();
        if (suiteName == null) {
            String msg = "Pop error: undefined suite name. Rest of stack: " + this.getSuitePathPresentation();
            GeneralTestEventsProcessor.logProblem(LOG, msg, true, this.myTestFrameworkName);
            return null;
        }
        if (!suiteName.equals(topSuite.getName())) {
            if (!SMTestRunnerConnectionUtil.isInDebugMode()) {
                SMTestProxy expectedProxy = null;
                for (SMTestProxy candidateProxy : this.myStack) {
                    if (!suiteName.equals(candidateProxy.getName())) continue;
                    expectedProxy = candidateProxy;
                    break;
                }
                if (expectedProxy != null) {
                    SMTestProxy proxy = topSuite;
                    while (proxy != expectedProxy) {
                        proxy = this.myStack.pop();
                    }
                    return expectedProxy;
                }
                return null;
            }
            LOG.error("Pop error: Unexpected closing suite. Expected [" + suiteName + "] but [" + topSuite.getName() + "] was found. Rest of stack: " + this.getSuitePathPresentation());
            return null;
        }
        this.myStack.pop();
        return topSuite;
    }

    public final boolean isEmpty() {
        return this.getStackSize() == 0;
    }

    protected int getStackSize() {
        return this.myStack.size();
    }

    protected String[] getSuitePath() {
        int stackSize = this.getStackSize();
        String[] names = new String[stackSize];
        int i = 0;
        Iterator<SMTestProxy> it = this.myStack.descendingIterator();
        while (it.hasNext()) {
            names[i++] = it.next().getName();
        }
        return names;
    }

    protected String getSuitePathPresentation() {
        Object[] names = this.getSuitePath();
        if (names.length == 0) {
            return EMPTY;
        }
        return StringUtil.join((Object[])names, s -> "[" + s + "]", (String)"->");
    }

    public void clear() {
        this.myStack.clear();
    }
}

