/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeNodeEvent {
    @NonNls
    public static final String ROOT_NODE_ID = "0";
    private final String myName;
    private final String myId;

    public TreeNodeEvent(@Nullable String name, @Nullable String id) {
        this.myName = name;
        this.myId = id;
    }

    protected void fail(@NotNull String message) {
        throw new IllegalStateException(message + ", " + this.toString());
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getId() {
        return this.myId;
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getSimpleName() + "{");
        TreeNodeEvent.append(buf, "name", this.myName);
        TreeNodeEvent.append(buf, "id", this.myId);
        this.appendToStringInfo(buf);
        buf.setLength(buf.length() - 2);
        buf.append("}");
        return buf.toString();
    }

    protected abstract void appendToStringInfo(@NotNull StringBuilder var1);

    protected static void append(@NotNull StringBuilder buffer, @NotNull String key, @Nullable Object value) {
        if (value != null) {
            buffer.append(key).append("=");
            if (value instanceof String) {
                buffer.append("'").append(value).append("'");
            } else {
                buffer.append(value);
            }
            buffer.append(", ");
        }
    }

    @Nullable
    public static String getNodeId(@NotNull ServiceMessage message) {
        return TreeNodeEvent.getNodeId(message, "nodeId");
    }

    @Nullable
    public static String getNodeId(@NotNull ServiceMessage message, String key) {
        return (String)message.getAttributes().get(key);
    }
}

