/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.states;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.states.TestFailedState;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestComparisionFailedState
extends TestFailedState {
    private final String myErrorMsgPresentation;
    private final String myStacktracePresentation;
    private final DiffHyperlink myHyperlink;
    private boolean myToDeleteExpectedFile;
    private boolean myToDeleteActualFile;

    public TestComparisionFailedState(@Nullable String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText) {
        this(localizedMessage, stackTrace, actualText, expectedText, null);
    }

    public TestComparisionFailedState(@Nullable String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText, @Nullable String filePath) {
        this(localizedMessage, stackTrace, actualText, expectedText, true, filePath, null);
    }

    public TestComparisionFailedState(@Nullable String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText, boolean printExpectedAndActualValues, @Nullable String expectedFilePath, @Nullable String actualFilePath) {
        super(localizedMessage, stackTrace);
        this.myHyperlink = new DiffHyperlink(expectedText, actualText, expectedFilePath, actualFilePath, printExpectedAndActualValues);
        this.myErrorMsgPresentation = StringUtil.isEmptyOrSpaces((String)localizedMessage) ? "" : localizedMessage;
        this.myStacktracePresentation = StringUtil.isEmptyOrSpaces((String)stackTrace) ? "" : stackTrace;
    }

    @Override
    public void printOn(Printer printer) {
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        printer.mark();
        printer.printWithAnsiColoring(this.myErrorMsgPresentation, ProcessOutputTypes.STDERR);
        this.myHyperlink.printOn(printer);
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        printer.printWithAnsiColoring(this.myStacktracePresentation, ProcessOutputTypes.STDERR);
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
    }

    @Nullable
    public DiffHyperlink getHyperlink() {
        return this.myHyperlink;
    }

    public void setToDeleteExpectedFile(boolean expectedTemp) {
        this.myToDeleteExpectedFile = expectedTemp;
    }

    public void setToDeleteActualFile(boolean actualTemp) {
        this.myToDeleteActualFile = actualTemp;
    }

    @Override
    public void dispose() {
        if (this.myToDeleteActualFile) {
            FileUtil.delete((File)new File(this.myHyperlink.getActualFilePath()));
        }
        if (this.myToDeleteExpectedFile) {
            FileUtil.delete((File)new File(this.myHyperlink.getFilePath()));
        }
    }
}

