/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.HyperLink;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.AttachToProcessListener;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTRunnerConsoleView
extends BaseTestsOutputConsoleView {
    private SMTestRunnerResultsForm myResultsViewer;
    @Nullable
    private final String mySplitterProperty;
    private final List<AttachToProcessListener> myAttachToProcessListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    @Deprecated
    public SMTRunnerConsoleView(TestConsoleProperties consoleProperties, ExecutionEnvironment environment) {
        this(consoleProperties, environment, null);
    }

    @Deprecated
    public SMTRunnerConsoleView(TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @Nullable String splitterProperty) {
        super(consoleProperties, null);
        this.mySplitterProperty = splitterProperty;
    }

    public SMTRunnerConsoleView(TestConsoleProperties consoleProperties) {
        this(consoleProperties, (String)null);
    }

    public SMTRunnerConsoleView(TestConsoleProperties consoleProperties, @Nullable String splitterProperty) {
        super(consoleProperties, null);
        this.mySplitterProperty = splitterProperty;
    }

    @Override
    protected TestResultsPanel createTestResultsPanel() {
        this.myResultsViewer = new SMTestRunnerResultsForm(this.getConsole().getComponent(), this.getConsole().createConsoleActions(), this.myProperties, this.mySplitterProperty);
        return this.myResultsViewer;
    }

    @Override
    public void initUI() {
        super.initUI();
        this.myResultsViewer.addEventsListener(new TestResultsViewer.SMEventsAdapter(){

            @Override
            public void onSelected(@Nullable SMTestProxy selectedTestProxy, @NotNull TestResultsViewer viewer, @NotNull TestFrameworkRunningModel model) {
                if (selectedTestProxy == null || SMTRunnerConsoleView.this.myResultsViewer.getTreeBuilder().isDisposed()) {
                    return;
                }
                SMTRunnerConsoleView.this.getPrinter().updateOnTestSelected(selectedTestProxy);
            }
        });
    }

    public SMTestRunnerResultsForm getResultsViewer() {
        return this.myResultsViewer;
    }

    @Override
    public void print(final @NotNull String s, final @NotNull ConsoleViewContentType contentType) {
        this.myResultsViewer.getRoot().addLast(new Printable(){

            @Override
            public void printOn(Printer printer) {
                printer.print(s, contentType);
            }
        });
    }

    @Override
    public void printHyperlink(@NotNull String hyperlinkText, HyperlinkInfo info) {
        this.myResultsViewer.getRoot().addLast(new HyperLink(hyperlinkText, info));
    }

    @Override
    public void attachToProcess(ProcessHandler processHandler2) {
        super.attachToProcess(processHandler2);
        for (AttachToProcessListener listener2 : this.myAttachToProcessListeners) {
            listener2.onAttachToProcess(processHandler2);
        }
    }

    public void addAttachToProcessListener(@NotNull AttachToProcessListener listener2) {
        this.myAttachToProcessListeners.add(listener2);
    }

    public void remoteAttachToProcessListener(@NotNull AttachToProcessListener listener2) {
        this.myAttachToProcessListeners.remove(listener2);
    }

    @Override
    public void dispose() {
        this.myAttachToProcessListeners.clear();
        super.dispose();
    }
}

