/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.MacroComboBoxModel;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.ui.TextAccessor;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacroComboBoxWithBrowseButton
extends ComponentWithBrowseButton<ComboBox<String>>
implements TextAccessor {
    private Module module;
    private boolean always;
    private final TextComponentAccessor<ComboBox<String>> accessor = new TextComponentAccessor<ComboBox<String>>(){

        public String getText(ComboBox<String> component) {
            Object item = component == null ? null : component.getSelectedItem();
            return item == null ? "" : item.toString();
        }

        public void setText(ComboBox<String> component, @NotNull String text) {
            if (component != null) {
                component.setSelectedItem((Object)text);
            }
        }
    };

    public MacroComboBoxWithBrowseButton(FileChooserDescriptor descriptor, Project project) {
        super((JComponent)new ComboBox((ComboBoxModel)new MacroComboBoxModel()), null);
        Component component;
        ComboBox combobox = (ComboBox)this.getChildComponent();
        combobox.setEditable(true);
        descriptor.withShowHiddenFiles(true);
        this.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<ComboBox<String>>(null, null, (ComponentWithBrowseButton)this, project, descriptor, this.accessor){

            private Module getModule() {
                Module module = MacroComboBoxWithBrowseButton.this.module;
                if (module == null) {
                    module = (Module)this.myFileChooserDescriptor.getUserData(LangDataKeys.MODULE_CONTEXT);
                }
                if (module == null) {
                    module = (Module)this.myFileChooserDescriptor.getUserData(LangDataKeys.MODULE);
                }
                return module;
            }

            @Nullable
            protected Project getProject() {
                Project project = super.getProject();
                if (project != null) {
                    return project;
                }
                Module module = this.getModule();
                return module == null ? null : module.getProject();
            }

            @NotNull
            protected String expandPath(@NotNull String path) {
                Module module;
                Project project = this.getProject();
                if (project != null) {
                    path = PathMacroManager.getInstance((ComponentManager)project).expandPath(path);
                }
                if ((module = this.getModule()) != null) {
                    path = PathMacroManager.getInstance((ComponentManager)module).expandPath(path);
                }
                return super.expandPath(path);
            }
        });
        ComboBoxEditor editor = combobox.getEditor();
        if (editor != null && (component = editor.getEditorComponent()) instanceof JTextField) {
            FileChooserFactory.getInstance().installFileCompletion((JTextField)component, descriptor, true, null);
        }
    }

    private MacroComboBoxModel getModel() {
        ComboBoxModel model = ((ComboBox)this.getChildComponent()).getModel();
        return model instanceof MacroComboBoxModel ? (MacroComboBoxModel)model : null;
    }

    public String getText() {
        return this.accessor.getText((Component)this.getChildComponent());
    }

    public void setText(String text) {
        this.accessor.setText((Component)this.getChildComponent(), text != null ? text : "");
    }

    public void setModule(Module module) {
        this.module = module;
        this.configure();
    }

    public void showModuleMacroAlways() {
        this.always = true;
        this.configure();
    }

    private void configure() {
        MacroComboBoxModel model = this.getModel();
        if (model != null) {
            model.useModuleDir(this.always || this.module != null);
        }
    }
}

