/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBRunnerTabs
extends JBEditorTabs {
    public JBRunnerTabs(@Nullable Project project, @NotNull ActionManager actionManager, IdeFocusManager focusManager, @NotNull Disposable parent) {
        super(project, actionManager, focusManager, parent);
    }

    public boolean useSmallLabels() {
        return true;
    }

    public int getToolbarInset() {
        return 0;
    }

    public int tabMSize() {
        return 8;
    }

    public boolean shouldAddToGlobal(Point point) {
        TabLabel label2 = this.getSelectedLabel();
        if (label2 == null || point == null) {
            return true;
        }
        Rectangle bounds2 = label2.getBounds();
        return point.y <= bounds2.y + bounds2.height;
    }

    public Rectangle layout(JComponent c, Rectangle bounds2) {
        if (c instanceof JBTabsImpl.Toolbar) {
            bounds2.height -= 5;
            return super.layout(c, bounds2);
        }
        return super.layout(c, bounds2);
    }

    public void processDropOver(TabInfo over, RelativePoint relativePoint) {
        Point point = relativePoint.getPoint((Component)this.getComponent());
        this.myShowDropLocation = this.shouldAddToGlobal(point);
        super.processDropOver(over, relativePoint);
        for (Map.Entry entry : this.myInfo2Label.entrySet()) {
            TabLabel label2 = (TabLabel)entry.getValue();
            if (!label2.getBounds().contains(point) || this.myDropInfo == entry.getKey()) continue;
            this.select((TabInfo)entry.getKey(), false);
            break;
        }
    }

    protected Color getEmptySpaceColor() {
        return UIUtil.getBgFillColor((Component)this.getParent());
    }

    protected TabLabel createTabLabel(TabInfo info) {
        return new MyTabLabel((JBTabsImpl)this, info);
    }

    private static class MyTabLabel
    extends TabLabel {
        MyTabLabel(JBTabsImpl tabs2, TabInfo info) {
            super(tabs2, info);
        }

        public void apply(UiDecorator.UiDecoration decoration) {
            this.setBorder(JBUI.Borders.empty((int)4));
        }

        public void setTabActionsAutoHide(boolean autoHide) {
            super.setTabActionsAutoHide(autoHide);
            this.apply(null);
        }

        public void setTabActions(ActionGroup group) {
            super.setTabActions(group);
            if (this.myActionPanel != null) {
                JComponent wrapper2 = (JComponent)this.myActionPanel.getComponent(0);
                wrapper2.remove(0);
                wrapper2.add(Box.createHorizontalStrut(6), "West");
            }
        }
    }
}

