/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerLayout {
    public static final Key<Integer> DEFAULT_INDEX = Key.create((String)"RunnerLayoutDefaultIndex");
    public static final Key<Integer> DROP_INDEX = Key.create((String)"RunnerLayoutDropIndex");
    private final String myID;
    protected Map<String, ViewImpl> myViews = new LinkedHashMap();
    private final Map<String, ViewImpl.Default> myDefaultViews = new HashMap<String, ViewImpl.Default>();
    protected Set<TabImpl> myTabs = new TreeSet<TabImpl>(Comparator.comparingInt(TabImpl::getIndex));
    private final Map<Integer, TabImpl.Default> myDefaultTabs = new HashMap<Integer, TabImpl.Default>();
    protected General myGeneral = new General();
    private final Map<String, Pair<String, LayoutAttractionPolicy>> myDefaultFocus = new HashMap<String, Pair<String, LayoutAttractionPolicy>>();
    private Set<String> myLightWeightIds = null;

    public RunnerLayout(@NotNull String ID2) {
        this.myID = ID2;
    }

    @Nullable
    public String getDefaultDisplayName(int defaultIndex) {
        TabImpl.Default tab = this.myDefaultTabs.get(defaultIndex);
        return tab != null ? tab.myDisplayName : null;
    }

    @NotNull
    public TabImpl getOrCreateTab(int index) {
        if (index < 0) {
            return this.createNewTab();
        }
        TabImpl tab = this.findTab(index);
        if (tab != null) {
            return tab;
        }
        tab = this.createNewTab(index);
        return tab;
    }

    @NotNull
    private TabImpl createNewTab(int index) {
        TabImpl.Default defaultTab = this.getOrCreateDefaultTab(index);
        TabImpl tab = defaultTab.createTab();
        this.myTabs.add(tab);
        return tab;
    }

    @NotNull
    private TabImpl.Default getOrCreateDefaultTab(int index) {
        TabImpl.Default tab = this.myDefaultTabs.get(index);
        if (tab == null) {
            tab = new TabImpl.Default(index, null, null);
            this.myDefaultTabs.put(index, tab);
        }
        return tab;
    }

    @NotNull
    public TabImpl createNewTab() {
        int index = this.myTabs.stream().mapToInt(x -> x.getIndex()).max().orElse(-1) + 1;
        return this.createNewTab(index);
    }

    private boolean isUsed(@NotNull TabImpl tab) {
        for (ViewImpl each : this.myViews.values()) {
            if (each.getTab() != tab) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected TabImpl findTab(int index) {
        for (TabImpl each : this.myTabs) {
            if (index != each.getIndex()) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public Element getState() {
        return this.write(new Element("layout"));
    }

    public void loadState(@NotNull Element state) {
        this.read(state);
    }

    @NotNull
    public Element read(@NotNull Element parentNode) {
        List tabs2 = parentNode.getChildren(StringUtil.getShortName((String)TabImpl.class.getName()));
        for (Element eachTabElement : tabs2) {
            TabImpl eachTab = (TabImpl)XmlSerializer.deserialize((Element)eachTabElement, TabImpl.class);
            XmlSerializer.deserializeInto((Object)this.getOrCreateTab(eachTab.getIndex()), (Element)eachTabElement);
        }
        List views = parentNode.getChildren(StringUtil.getShortName((String)ViewImpl.class.getName()));
        for (Object content : views) {
            ViewImpl state = new ViewImpl(this, (Element)content);
            this.myViews.put(state.getID(), state);
        }
        XmlSerializer.deserializeInto((Object)this.myGeneral, (Element)parentNode.getChild(StringUtil.getShortName((String)this.myGeneral.getClass().getName(), (char)'$')));
        return parentNode;
    }

    @NotNull
    public Element write(@NotNull Element parentNode) {
        for (ViewImpl eachState : this.myViews.values()) {
            if (this.myLightWeightIds != null && this.myLightWeightIds.contains(eachState.getID())) continue;
            parentNode.addContent(XmlSerializer.serialize((Object)eachState));
        }
        SkipDefaultValuesSerializationFilters filter = new SkipDefaultValuesSerializationFilters();
        for (TabImpl eachTab : this.myTabs) {
            if (!this.isUsed(eachTab)) continue;
            parentNode.addContent(XmlSerializer.serialize((Object)eachTab, (SerializationFilter)filter));
        }
        parentNode.addContent(XmlSerializer.serialize((Object)this.myGeneral, (SerializationFilter)filter));
        return parentNode;
    }

    public void resetToDefault() {
        this.myViews.clear();
        this.myTabs.clear();
    }

    public boolean isToolbarHorizontal() {
        return false;
    }

    public void setToolbarHorizontal(boolean horizontal) {
        this.myGeneral.horizontalToolbar = horizontal;
    }

    @NotNull
    public ViewImpl getStateFor(@NotNull Content content) {
        return this.getOrCreateView(RunnerLayout.getOrCreateContentId(content));
    }

    public void clearStateFor(@NotNull Content content) {
        Tab tab;
        String id = RunnerLayout.getOrCreateContentId(content);
        this.myDefaultViews.remove(id);
        ViewImpl view = this.myViews.remove(id);
        if (view != null && (tab = view.getTab()) instanceof TabImpl) {
            this.myTabs.remove(tab);
        }
    }

    @NotNull
    private static String getOrCreateContentId(@NotNull Content content) {
        String id = (String)content.getUserData(ViewImpl.ID);
        if (id == null) {
            id = "UnknownView-" + content.getDisplayName();
            content.putUserData(ViewImpl.ID, (Object)id);
        }
        return id;
    }

    @NotNull
    private ViewImpl getOrCreateView(@NotNull String id) {
        ViewImpl view = this.myViews.get(id);
        if (view == null) {
            view = this.getOrCreateDefault(id).createView(this);
            this.myViews.put(id, view);
        }
        return view;
    }

    @NotNull
    private ViewImpl.Default getOrCreateDefault(@NotNull String id) {
        if (this.myDefaultViews.containsKey(id)) {
            return this.myDefaultViews.get(id);
        }
        return this.setDefault(id, Integer.MAX_VALUE, PlaceInGrid.bottom, false);
    }

    @NotNull
    public TabImpl.Default setDefault(int tabID, String displayName, Icon icon) {
        TabImpl.Default tab = new TabImpl.Default(tabID, displayName, icon);
        this.myDefaultTabs.put(tabID, tab);
        return tab;
    }

    @NotNull
    public ViewImpl.Default setDefault(@NotNull String id, int tabIndex, @NotNull PlaceInGrid placeInGrid, boolean isMinimized) {
        ViewImpl.Default view = new ViewImpl.Default(id, tabIndex, placeInGrid, isMinimized);
        this.myDefaultViews.put(id, view);
        return view;
    }

    @NotNull
    public PlaceInGrid getDefaultGridPlace(@NotNull Content content) {
        return this.getOrCreateDefault(RunnerLayout.getOrCreateContentId(content)).getPlaceInGrid();
    }

    public boolean isToFocus(String id, @NotNull String condition) {
        return Comparing.equal((String)id, (String)this.getToFocus(condition));
    }

    public void setToFocus(String id, @NotNull String condition) {
        this.myGeneral.focusOnCondition.put(condition, id);
    }

    public void setDefaultToFocus(@NotNull String id, @NotNull String condition, @NotNull LayoutAttractionPolicy policy) {
        this.myDefaultFocus.put(condition, (Pair<String, LayoutAttractionPolicy>)Pair.create((Object)id, (Object)policy));
    }

    void cancelDefaultFocusBy(@NotNull String condition) {
        this.myDefaultFocus.remove(condition);
    }

    @Nullable
    public String getToFocus(@NotNull String condition) {
        return this.myGeneral.focusOnCondition.containsKey(condition) ? this.myGeneral.focusOnCondition.get(condition) : (this.myDefaultFocus.containsKey(condition) ? (String)this.myDefaultFocus.get(condition).getFirst() : null);
    }

    @NotNull
    public LayoutAttractionPolicy getAttractionPolicy(@NotNull String condition) {
        Pair<String, LayoutAttractionPolicy> pair = this.myDefaultFocus.get(condition);
        return pair == null ? new LayoutAttractionPolicy.FocusOnce() : (LayoutAttractionPolicy)pair.getSecond();
    }

    public void setLightWeight(Content content) {
        if (this.myLightWeightIds == null) {
            this.myLightWeightIds = new HashSet<String>();
        }
        this.myLightWeightIds.add(RunnerLayout.getOrCreateContentId(content));
    }

    public static class General {
        public volatile boolean horizontalToolbar = false;
        public volatile Map<String, String> focusOnCondition = new HashMap<String, String>();
    }
}

